#include "irc.h"
#include "struct.h"
#include "ircaux.h"
#include "misc.h"
#include "output.h"
#include "module.h"
#include "list.h"
#include "vars.h"
#include "modval.h"
#include "napster.h"

static IgnoreStruct *ignores = NULL;

int check_nignore(char *nick)
{
	if (ignores && find_in_list((List **)&ignores, nick, 0))
		return 1;
	return 0;
}

void ignore_user(IrcCommandDll *intp, char *command, char *args, char *subargs, char *help)
{
IgnoreStruct *new;
char *nick;
	if (command && !my_stricmp(command, "nignore"))
	{
		if (!args || !*args)
		{
			char buffer[NAP_BUFFER_SIZE+1];
			int cols =	get_dllint_var("napster_names_columns") ? 
					get_dllint_var("napster_names_columns") : 
					get_int_var(NAMES_COLUMNS_VAR);
			int count = 0;
			if (!cols)
				cols = 1;
			*buffer = 0;
			nap_say("%s", cparse("Ignore List:", NULL));
			for (new = ignores; new; new = new->next)
			{
				strcat(buffer, cparse(get_dllstring_var("napster_names_nickcolor"), "%s %d %d", new->nick, 0, 0));
				strcat(buffer, space);
				if (count++ >= (cols - 1))
				{
					nap_put("%s", buffer);
					*buffer = 0;
					count = 0;
				}
			}
			if (*buffer)
				nap_put("%s", buffer);
			return;
		}
		while ((nick = next_arg(args, &args)))
		{
			if (*nick == '-')
			{
				nick++;
				if (!*nick)
					continue;
				if ((new = (IgnoreStruct *)remove_from_list((List **)&ignores, nick)))
				{
					new_free(&new->nick);
					new_free(&new);
					nap_say("Removed %s from ignore list", nick);
				}
			}
			else
			{
				new = new_malloc(sizeof(IgnoreStruct));
				new->nick = m_strdup(nick);
				new->start = time(NULL);
				new->next = ignores;
				ignores = new;
				nap_say("Added %s to ignore list", new->nick);
			}
		}
		return;
	}
}


void nap_echo(IrcCommandDll *intp, char *command, char *args, char *subargs, char *help)
{
int (*func)(char *, ...);
	if (!args || !*args)
		return;

	func = nap_say;
	while (args && (*args == '-'))
	{
		args++;
		if (!*args)
			break;
		if (tolower(*args) == 'x')
		{
			func = nap_put;
			next_arg(args, &args);
		}
		else
		{
			args--;
			break;
		}
	}
	if (args)
		(func)("%s", args);
}

extern GetFile *napster_sendqueue;

int count_download(char *nick)
{
int count = 0;
GetFile *gf;
	for (gf = napster_sendqueue; gf; gf = gf->next)
		if (!my_stricmp(gf->nick, nick))
			count++;
	return count;
}
