/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 /*
  * Last modified: $Date: 2005/02/02 10:08:19 $ by $Author: juergenk $
  */

#ifndef _KAFFEINEPREF_H_
#define _KAFFEINEPREF_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class QCheckBox;
class QSpinBox;
class QComboBox;

class KaffeinePreferences : public KDialogBase
{
    Q_OBJECT

public:
  KaffeinePreferences();
  virtual ~KaffeinePreferences() {}
  
  void setConfig(bool pauseVideo, int timeout, bool tray, uint duration, bool showGoTab, bool useEncoding, const QString& encoding);
  
signals:
  void signalClearRecent();    
  void signalTimeoutInterval(int);
  void signalEmbedSystemTray(bool);
  void signalUseAlternateEncoding(bool);
  void signalAlternateEncoding(const QString&);
  void signalShowGoTab(bool);
  void signalSetOSDTimeout(uint);
  void signalPauseVideo(bool);
  
private slots:
  void slotOkPressed();
  void slotApplyPressed();
  void slotUseAlternateEncodingToggled(bool);
  void slotEmbedInTrayToggled(bool);
  
private:
  QCheckBox* m_systemTray;
  QCheckBox* m_showGoTab;
  QSpinBox* m_timeout;
  QSpinBox* m_osdTimeout;
  QCheckBox* m_useAlternateEncoding;
  QComboBox* m_alternateEncoding;
  QCheckBox* m_pauseVideo;
};


#endif // _KAFFEINEPREF_H_
