
#ifndef __DECCXX
#include <fstream.h>
#endif
#include <qaccel.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qlistbox.h>
#include <qwhatsthis.h>

#include <klocale.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>
#include <kwin.h>

#include "kwuftpd.h"

static const char *description = 
	I18N_NOOP("KDE tool to configure wuftpd");

static const char *version = "0.2.0";

void kwuftpd::init()
{
	ftpxs=new ftpaccess("/etc/ftpaccess");
	setFixedSize(640,380);
	resize(640,380);

	// initialization stuff
	KWin::setIcons(winId(), kapp->icon(), kapp->miniIcon());

	// Menu
	// File
	file = new QPopupMenu;
	file->insertItem(i18n("&Load /etc/ftpaccess"), ID_FILE_LOADFTPACCESS);
	file->insertItem(i18n("Load &other file"), ID_FILE_LOADOTHER);
	file->insertSeparator();
	file->insertItem(i18n("&Save /etc/ftpaccess"), ID_FILE_SAVEFTPACCESS);
	file->insertItem(i18n("Save o&ther file"), ID_FILE_SAVEOTHER);
	file->insertSeparator();
	file->insertItem(i18n("&Quit"), ID_FILE_QUIT);
	connect(file, SIGNAL(activated (int)), SLOT(handleMenu(int)));

	// Help
	// #### HPB: String removed because it was not i18n()ed.
	//           Using appdata instead.
	help=helpMenu();//"kwuftpd - the KDE wuftpd configurator\n(c) 2000 Red Hat, Inc.\nWritten by Bernhard Rosenkrnzer <bero@redhat.com>.\n\nWritten for wu-ftpd 2.6.0");

	menu=menuBar(); //new KMenuBar(this);
//	CHECK_PTR( menu );
	menu->insertItem( i18n("&File"), file );
	menu->insertSeparator();
	menu->insertItem( i18n("&Help"), help );
	menu->show();

	// tab dialog...
	ktc=new QTabWidget(this,"kwuftpd");

	// tab #1: User classes
	ClassesTab=new UserClasses(ktc, "User Classes");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), ClassesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), ClassesTab, SLOT(update()));

	// tab #2: Directories
	DirectoriesTab=new Directories(ktc, "Directories");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), DirectoriesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), DirectoriesTab, SLOT(update()));

	// tab #3: Security
	SecurityTab=new Security(ktc, "Security");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), SecurityTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), SecurityTab, SLOT(update()));

	// tab #4: User Information
	MessagesTab=new Messages(ktc, "Messages");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), MessagesTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), MessagesTab, SLOT(update()));

	// tab #5: Logging
	LoggingTab=new Logging(ktc, "Logging");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), LoggingTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), LoggingTab, SLOT(update()));

	// tab #6: Ratios
	RatiosTab=new Ratios(ktc, "Ratios");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), RatiosTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), RatiosTab, SLOT(update()));
	
	// tab #7: Uploads
	UploadsTab=new Uploads(ktc, "Uploads");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), UploadsTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), UploadsTab, SLOT(update()));

	// tab #8: Virtual Hosts
	VirtualTab=new Virtual(ktc, "Virtual Hosts");
	connect(this, SIGNAL(ftpaccessLoaded(ftpaccess *)), VirtualTab, SLOT(ftpaccessLoaded(ftpaccess *)));
	connect(this, SIGNAL(aboutToSave()), VirtualTab, SLOT(update()));

	// show tabs...
	ktc->move(0,menu->height());
	ktc->resize(640,380-menu->height());
	
	ktc->addTab(ClassesTab, i18n("User &Classes"));
	ktc->addTab(DirectoriesTab, i18n("&Directories"));
	ktc->addTab(SecurityTab, i18n("&Security"));
	ktc->addTab(MessagesTab, i18n("&Messages"));
	ktc->addTab(LoggingTab, i18n("&Logging"));
	ktc->addTab(RatiosTab, i18n("Rat&ios"));
	ktc->addTab(UploadsTab, i18n("&Uploads"));
	ktc->addTab(VirtualTab, i18n("&Virtual Hosts"));

	// Set some default values...
	emit ftpaccessLoaded(ftpxs);

	ktc->show();

	show();
}
void kwuftpd::handleMenu(int item)
{
	switch(item) {
	case ID_FILE_LOADFTPACCESS:
	case ID_FILE_LOADOTHER:
		{
			KURL url;
			if(item==ID_FILE_LOADOTHER) {
				url=KFileDialog::getOpenURL("/etc", "*", this, i18n("Select ftpaccess file"));
				if ( !url.isLocalFile() ) {
					KMessageBox::sorry(0, i18n("Only local files are supported yet.\n/etc/ftpaccess used instead."));
					url=KURL("/etc/ftpaccess");
				}
			} else
				url=KURL("/etc/ftpaccess");
			ftpxs->read(url.path());
			emit ftpaccessLoaded(ftpxs);
			break;
		}
	case ID_FILE_SAVEFTPACCESS:
	case ID_FILE_SAVEOTHER:
		{
			KURL url;
			if(item==ID_FILE_SAVEOTHER) {
				url=KFileDialog::getSaveURL("/etc", "*", this, i18n("Select ftpaccess file"));
				if(!url.isLocalFile()) {
					KMessageBox::sorry(0, i18n("Only local files are currently supported."));
					break;
				}
			} else
				url=KURL("/etc/ftpaccess");
			emit aboutToSave();
			if(!ftpxs->write(url.path()))
				KMessageBox::sorry(this, 
						   i18n("An error occured while trying to save."));
			break;
		}
	case ID_FILE_QUIT:
		kapp->quit();
		break;
	}
}
kwuftpd::kwuftpd() : KMainWindow(0)
{
	init();
}
kwuftpd::~kwuftpd()
{
	if(ftpxs!=0)
		delete ftpxs;
}
int main(int argc, char **argv)
{
	KAboutData aboutData( "kwuftpd", I18N_NOOP("KWuFTPd"), 
		version, description, KAboutData::License_GPL, 
		"(c) 2000 Red Hat, Inc.");
	aboutData.addAuthor("Bernhard Rosenkraenzer",0, "bero@redhat.com");
	KCmdLineArgs::init( argc, argv, &aboutData );
//	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
	KApplication app;

	kwuftpd *a=new kwuftpd;
	a->setCaption(QString::fromLatin1("kwuftpd ") + version);
	app.setMainWidget(a);
	return app.exec();
}
#include "kwuftpd.moc"
