/*
    Empath - Mailer for KDE
    
    Copyright 1999, 2000
        Rik Hemsley <rik@kde.org>
        Wilco Greven <j.w.greven@student.utwente.nl>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef EMPATH_HEADER_SPEC_WIDGET_H
#define EMPATH_HEADER_SPEC_WIDGET_H

// Qt includes
#include <qhbox.h>
#include <qstring.h>

class QLabel;

class EmpathHeaderBodyWidget;

class EmpathHeaderSpecWidget : public QHBox
{
    Q_OBJECT

    public:
        
        EmpathHeaderSpecWidget(
            const QString & headerName,
            const QString & headerBody,
            QWidget * parent = 0
        );

        virtual ~EmpathHeaderSpecWidget();

        int     sizeOfColumnOne() const;
        void    setColumnOneSize(int);

        QString headerName() const;

        QString headerBody() const;

    signals:

        void goUp();
        void goDown();
    
    protected:
       
        void focusInEvent   (QFocusEvent *);
        void keyPressEvent  (QKeyEvent *);

    private:

        QLabel * headerNameWidget_;
        EmpathHeaderBodyWidget * headerBodyWidget_;
       
        QString headerName_;
        QString headerBody_;
};

#endif
// vim:ts=4:sw=4:tw=78
