// dialogs.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 199

//
// 1999-11-21-Espen Sand <espen@kde.org>:
// Changed to KDialogBase
//
#include <qaccel.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qslider.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include <knumvalidator.h>

#include "dialogs.h"


//
// ValueDialog: modal dialog to input a single string value
//
ValueDialog::ValueDialog( const QString &caption, const QString &msg,
			  const QString &ed_txt)
  : KDialogBase( kapp->mainWidget(), "value", true, caption, Ok|Cancel, Ok )
{
  QFrame *page = makeMainWidget();
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QHBoxLayout *hlay = new QHBoxLayout( topLayout );
  QLabel *label = new QLabel(msg, page);
  hlay->addWidget(label);

  lined = new QLineEdit(page);
  lined->setMinimumWidth( fontMetrics().maxWidth()*15 );
  lined->setText(ed_txt);
  lined->selectAll();
  lined->setFocus();
  lined->setValidator( new KIntValidator( lined ) );
  hlay->addWidget(lined);

  topLayout->addStretch( 1 );
}

void ValueDialog::slotOk( void )
{
  ed_result = lined->text();
  ed_result = ed_result.stripWhiteSpace();
  accept();
}






SliderDialog::SliderDialog(const QString &caption, const QString &msg,
			   int defaultval, int minval, int maxval,
			   QWidget *parent )
  : KDialogBase( parent, "slider", true, caption, Ok|Cancel, Ok )
{
  QWidget *page = new QWidget( this );
  setMainWidget( page );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QHBoxLayout *hl = new QHBoxLayout();
  topLayout->addLayout(hl);

  QLabel *label = new QLabel(msg, page);
  hl->addWidget(label);

  lined = new QLineEdit(page);
  lined->setMinimumWidth( fontMetrics().maxWidth()*10 );
  lined->setText( QString().setNum(defaultval) );
  lined->selectAll();
  lined->setFocus();
  lined->setValidator( new KIntValidator( lined ) );
  hl->addWidget(lined);

  slider = new QSlider(minval,maxval, 1,defaultval, QSlider::Horizontal,page);
  slider->setTickInterval(10);
  slider->setFixedHeight(slider->sizeHint().height());
  slider->setMinimumWidth(200);
  connect(slider, SIGNAL(valueChanged(int)), this, SLOT(slider_change(int)));
  topLayout->addWidget(slider);

  // decorate slider
  QLabel *left = new QLabel(page);
  QLabel *mid = new QLabel(page);
  QLabel *right = new QLabel(page);
  left->setNum(minval);
  mid->setNum((minval + maxval) / 2);
  right->setNum(maxval);

  hl = new QHBoxLayout();
  topLayout->addLayout(hl);
  hl->addWidget(left);
  hl->addStretch(1);
  hl->addWidget(mid);
  hl->addStretch(1);
  hl->addWidget(right);

  topLayout->addSpacing( spacingHint() );
  topLayout->addStretch( 10 );
}


void SliderDialog::slider_change(int val)
{
  QString s;
  s.setNum(val);
  lined->setText(s);
  lined->selectAll();
}

void SliderDialog::slotOk( void )
{
  ed_result = lined->text();
  ed_result = ed_result.stripWhiteSpace();
  accept();
}

