#ifndef KPHONEVIEW_H_INCLUDED
#define KPHONEVIEW_H_INCLUDED
#include <qwidget.h>
#include <qptrdict.h>
#include <qvbox.h>
#include <qradiobutton.h>
#include <qxml.h>
#include <qcombobox.h>

#include "../dissipate2/sipuri.h"
#include "ksipauthentication.h"

class SipClient;
class SipUser;
class SipCall;
class SipCallMember;
class KCallWidget;
class KInstantMessageWidget;
class QListViewItem;
class CallAudio;
class KPhone;
class KSipRegistrations;
class KSipAuthentication;
class ContactsListView;


class ContactParser : public QXmlDefaultHandler
{
public:
	ContactParser( void );
	bool startDocument();
	bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
	bool endElement( const QString&, const QString&, const QString& );
	QStringList getListContacts( void ) { return contacts; }
private:
	QStringList contacts;
};

class KPhoneView : public QWidget
{
	Q_OBJECT
public:
	enum State { ONLINE, OFFLINE };
	KPhoneView( SipClient *c, SipUser *u, QWidget *parent = 0, const char *name = 0 );
	~KPhoneView( void );
	void switchCall( SipCall *call );
	void updateIdentity( SipUser *newUser, SipRegister *newReg = 0 );
	void identities( KSipRegistrations *i );
	void updateContacts( QString file );
	void setContactsOffline( void );
	void setContactsOnline( void );
	void setStunSrv( QString );
	bool useStunSrv( void );
	QString getStunSrv( void );
	void kphoneQuit( void );
	bool getState( void );

signals:
	void stateChanged( void );

public slots:
	void makeNewCall( void );
	void makeVideoCall( void );
	void redirectCall( const SipUri &calluri, const QString &subject );
	void showIdentities( void );
	void localStatusUpdate( void );
	void stateUpdated( int id );
	void updateSubscribes( void );
	void buttonOffOnlineClicked( void );

private slots:
	void incomingInstantMessage( SipMessage *message );
	void incomingSubscribe( SipCallMember *member, bool sendSubscribe );
	void incomingCall( SipCall *call, QString body );
	void hideCallWidget( SipCall *call );
	void contactDoubleClicked( QListViewItem *i );
	void busyToggled( bool onoff );
	void contactSendMessage();
	void contactCall( void );
	void contactVideoCall( void );
	void showPhoneBook( void );
	void buttonUpdateClicked( void );

protected:
	SipClient *client;
	SipUser *user;
	ContactsListView *clist;
	int callcount;
	QPushButton *buttonSipUri;
	QPushButton *buttonNewCall;
	QPushButton *buttonVideoCall;
	QLineEdit *lineeditCall;
	QLabel *labelSipUri;
	QLabel *labelFullname;
	KPhone *kphone;
	KSipRegistrations *identitiesDialog;
	KSipAuthentication *sipauthentication;

private:
	void sendNotify( int id, SipCallMember *member = 0 );
	QString getUserPrefix( void );
	void saveRejectContactList( void );
	QPtrList<KCallWidget> cwList;
	QPtrList<KInstantMessageWidget> imwList;
	QStringList rejectedContactList;
	void saveContacts( void );
	void addContactToPhoneBook( SipCallMember *member );
	SipRegister *reg;
	QPushButton *buttonOffOnline;
	QPushButton *buttonUpdate;
	QComboBox *stateComboBox;
	int atomId;
	QTimer *subscribeTimer;
	int subscribeExpiresTime;
	CallAudio *callAudio;
	bool isOnline;
	bool buttonSetOffline;
	bool setSubscribeOffline;
	void updateWidgetList( void );
	QString stateText( QString text );
	bool useStunProxy;
	QString stunProxyUri;
};

#endif // KPHONEVIEW_H_INCLUDED
