#include "question_header.h"

namespace ADNS {

	QuestionHeader::QuestionHeader()
	{
		qname = gcnew DOMAIN_NAME();
	}

	DOMAIN_NAME^ QuestionHeader::GetQuestionName()
	{
		return qname->Clone();
	}

	Void QuestionHeader::SetQuestionName(DOMAIN_NAME^ qn)
	{
		qname = qn->Clone();
		return;
	}

	RR_TYPE QuestionHeader::GetQuestionType()
	{
		return qtype;
	}

	Void QuestionHeader::SetQuestionType(RR_TYPE t)
	{
		qtype = t;
		return;
	}

	RR_CLASS QuestionHeader::GetQuestionClass()
	{
		return qclass;
	}
	
	Void QuestionHeader::SetQuestionClass(RR_CLASS c)
	{
		qclass = c;
		return;
	}

	array<Byte>^ QuestionHeader::ToWire()
	{
		array<Byte>^ output;
		
		output = gcnew array<Byte>(qname->Size() + 4);
		qname->GetName()->CopyTo(output,0);
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) qtype))->CopyTo(output,qname->Size());
		BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) qclass))->CopyTo(output,qname->Size() + 2);

		return output;
	}

	String^ QuestionHeader::Print()
	{
		String^ output;

		output = qname->Print();
		output += " " + Enum::GetName(RR_CLASS::typeid,qclass);
		output += " " + Enum::GetName(RR_TYPE::typeid,qtype);
		return output;
	}
 
}