/*
 * $Id: debug.c,v 1.6 2002/03/29 22:38:06 ceder Exp $
 * Copyright (C) 1991, 1993-1996, 1999, 2001-2002  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * debug.c
 *
 * Testing and debugging calls.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <malloc.h>
#include <setjmp.h>

#include "misc-types.h"
#include "kom-types.h"
#include "kom-errno.h"
#include "cache.h"
#include "async.h"
#include "com.h"
#include "connections.h"
#include "services.h"
#include "manipulate.h"



#ifdef DEBUG_CALLS

extern Success
get_memory_info (Memory_info *result)
{
    struct mallinfo info;

    CHK_CONNECTION(FAILURE);

#ifdef HAVE_MALLINFO
    info = mallinfo();
    result->arena = info.arena;
    result->ordblks = info.ordblks;
    result->smblks = info.smblks;
    result->hblks = info.hblks;
    result->hblkhd = info.hblkhd;
    result->usmblks = info.usmblks;
    result->fsmblks = info.fsmblks;
    result->uordblks = info.uordblks;
    result->fordblks = info.fordblks;
    result->keepcost = info.keepcost;
#else
    result->arena = 0;
    result->ordblks = 0;
    result->smblks = 0;
    result->hblks = 0;
    result->hblkhd = 0;
    result->usmblks = 0;
    result->fsmblks = 0;
    result->uordblks = 0;
    result->fordblks = 0;
    result->keepcost = 0;
#endif    

    return OK;
}


extern Success
set_marks (Text_no text_no,
           unsigned long no_of_marks)
{
    Text_stat *text_s;

    CHK_LOGIN(FAILURE);
    GET_T_STAT(text_s, text_no, FAILURE);

    text_s->no_of_marks = no_of_marks;
    mark_text_as_changed(text_no);
    return OK;
}

extern Success
backdate_text(Text_no text_no,
              unsigned long seconds)
{
    Text_stat *text_s;

    CHK_LOGIN(FAILURE);
    GET_T_STAT(text_s, text_no, FAILURE);

    text_s->creation_time -= seconds;
    mark_text_as_changed(text_no);

    return OK;
}

/* start_garb is in text-garb.c since it needs access to static variables */

#endif
