<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Utils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_POST["documentid"]) || !is_numeric($_POST["documentid"]) || intval($_POST["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_POST["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");
UI::contentHeading(getMLText("override_content_status"));

if ($document->getAccessMode($user) < M_ALL) {
	UI::contentContainer(getMLText("override_privilege_insufficient"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_POST["version"]) || !is_numeric($_POST["version"]) || intval($_POST["version"])<1) {
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$version = $_POST["version"];
$content = $document->getContentByVersion($version);
if (!is_object($content)) {
	// die ("Unable to retrieve version information for document '". $document->getName() ."', version ". $version .".");
	UI::contentContainer(getMLText("invalid_version"));
	UI::htmlEndPage();
	exit;
}
$overallStatus = $content->getStatus();
$reviewStatus = $content->getReviewStatus();
$approvalStatus = $content->getApprovalStatus();

if (!isset($_POST["overrideStatus"]) || !is_numeric($_POST["overrideStatus"]) ||
		(intval($_POST["overrideStatus"])<-3 && intval($_POST["overrideStatus"])>2)) {
	UI::contentContainer(getMLText("invalid_status"));
	UI::htmlEndPage();
	exit;
}
$overrideStatus = $_POST["overrideStatus"];

$comment = sanitizeString($_POST["comment"]);

UI::contentContainerStart();

// If the document version is already in one of the terminal states (expired,
// obsolete, rejected), report a warning.
if ($overallStatus["status"] == -1 || $overallStatus["status"] == -2 || $overallStatus["status"] == -3) {
	printMLText("cannot_change_final_states");
	UI::contentContainerEnd();
	UI::htmlEndPage();
	exit;
}
// If new status == old status, return an error and exit.
if ($overrideStatus == $overallStatus["status"]) {
	printMLText("new_equals_old_state");
	UI::contentContainerEnd();
	UI::htmlEndPage();
	exit;
}

switch ($overallStatus["status"]) {
	case 0: // Existing status == "pending review".
		// Update the database.
		if (!$content->setStatus($overrideStatus, $comment, $user)) {
			print getMLText("warning").": ".getMLText("error_updating_revision");
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		// Inform all existing reviewers that have not submitted a review.
		foreach ($reviewStatus as $r) {
			if ($r["status"] == 0) {
				// Send an email notification to the document reviewers.
				$subject = "[Document Review]: ".$document->getName().", v. ".$version;
				$message = $user->getFullName()." <". $user->getEmail() ."> ".
					"has altered the status of the following document:";
				$message = wordwrap ($message, 72, "\r\n");
				$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
					"\tVersion: ".$version."\r\n".
					"\tNew Status: ".getOverallStatusText($overrideStatus)."\r\n".
					"\tComment: ".$comment."\r\n".
					"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n\r\n".
					"You may still submit a review of this document revision but said review\r\n".
					"will no longer affect the revision's state within the work-flow.\r\n";
				if ($r["type"]==0) {
					$ru=getUser($r["required"]);
					if (Email::toIndividual($user, $ru, $subject, $message)<0) {
						UI::contentSubHeading(getMLText("warning"));
						print "<p>Error sending email to reviewer '".$ru->getFullName()."', &lt;".$ru->getEmail().">.</p>";
					}
				}
				else if ($r["type"]==1) {
					$rg=getGroup($r["required"]);
					if (Email::toGroup($user, $rg, $subject, $message)<0) {
						UI::contentSubHeading(getMLText("warning"));
						print "<p>Error sending email to one or more members of review group '".$rg->getName()."'.</p>";
					}
				}
			}
		}

		// If moving to "pending approval", inform all approvers.
		if ($overrideStatus==1) {
			$subject = "[Document Approval Request]: ".$document->getName().", v. ".$version;
			$docOwner = $document->getOwner();
			$message = "\r\n\r\n\t   Name: ".$content->getOriginalFileName()."\r\n".
				"\tVersion: ".$version."\r\n".
				"\tComment: ".$content->getComment()."\r\n".
				"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ApproveDocument.php?documentid=".$documentid."&version=".$version."\r\n";
			foreach ($approvalStatus as $dastat) {
				if ($dastat["status"] == 0) {
					if ($dastat["type"] == 0) {
						$imessage = $docOwner->getFullName()." <". $docOwner->getEmail() ."> ".
							"has requested that you approve the following document:";
						$imessage = wordwrap ($imessage, 72, "\r\n");
						$approver = getUser($dastat["required"]);
						if (Email::toIndividual($document->getOwner(), $approver, $subject, $imessage.$message)<0) {
							UI::contentSubHeading(getMLText("warning"));
							print "<p>Error sending email to approver ".$approver->getFullName()."</p>";
						}
					}
					else if ($dastat["type"] == 1) {
						$gmessage = $docOwner->getFullName()." <". $docOwner->getEmail() ."> ".
							"has requested that a member of the group '". $group->getName() ."' approve the following document:";
						$gmessage = wordwrap ($gmessage, 72, "\r\n");
						$group = getGroup($dastat["required"]);
						if (Email::toGroup($document->getOwner(), $group, $subject, $gmessage.$message)<0) {
							UI::contentSubHeading(getMLText("warning"));
							print "<p>Error sending email to one or more members of approver group '".$group->getName()."'.</p>";
						}
					}
				}
			}
		}
		break;
	case 1: // Existing status == "pending approval".
		if ($overrideStatus==0) {
			UI::contentSubHeading(getMLText("warning"));
			print "<p>Cannot change from status '".getOverallStatusText($overallStatus["status"])."' to status '".getOverallStatusText($overrideStatus)."'.</p>";
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		// Update the database.
		if (!$content->setStatus($overrideStatus, $comment, $user)) {
			UI::contentSubHeading(getMLText("warning"));
			print "<p>Error updating status of document revision.</p>";
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		
		// Inform existing approvers that have not already submitted an approval.
		foreach ($approvalStatus as $a) {
			if ($a["status"] == 0) {
				// Send an email notification to the document approvers.
				$subject = "[Document Approval]: ".$document->getName().", v. ".$version;
				$message = $user->getFullName()." <". $user->getEmail() ."> ".
					"has altered the status of the following document:";
				$message = wordwrap ($message, 72, "\r\n");
				$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
					"\tVersion: ".$version."\r\n".
					"\New Status: ".getOverallStatusText($overrideStatus)."\r\n".
					"\tComment: ".$comment."\r\n".
					"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n\r\n".
					"You may still submit an approval of this document revision but said approval\r\n".
					"will no longer affect the revision's state within the work-flow.\r\n";
				if ($a["type"]==0) {
					$au=getUser($a["required"]);
					if (Email::toIndividual($user, $au, $subject, $message)<0) {
						UI::contentSubHeading(getMLText("warning"));
						print "<p>Error sending email to approver '".$au->getFullName()."', &lt;".$au->getEmail().">.</p>";
					}
				}
				else if ($a["type"]==1) {
					$ag=getGroup($a["required"]);
					if (Email::toGroup($user, $ag, $subject, $message)<0) {
						UI::contentSubHeading(getMLText("warning"));
						print "<p>Error sending email to one or more members of approval group '".$ag->getName()."'.</p>";
					}
				}
			}
		}
		break;
	case 2: // Existing status == "released".
		if ($overrideStatus>=0) {
			UI::contentSubHeading(getMLText("warning"));
			print "<p>Cannot change from status '".getOverallStatusText($overallStatus["status"])."' to status '".getOverallStatusText($overrideStatus)."'.</p>";
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		// Update the database.
		if (!$content->setStatus($overrideStatus, $comment, $user)) {
			UI::contentSubHeading(getMLText("warning"));
			print "<p>Error updating status of document revision.</p>";
			UI::contentContainerEnd();
			UI::htmlEndPage();
			exit;
		}
		
		// Inform document owner.
		$docOwner = $document->getOwner();
		$subject = "[Document Approval]: ".$document->getName().", v. ".$version;
		$message = $user->getFullName()." <". $user->getEmail() ."> ".
			"has altered the status of the following document:";
		$message = wordwrap ($message, 72, "\r\n");
		$message .= "\r\n\r\n\t   Name: ".$document->getName()."\r\n".
			"\tVersion: ".$version."\r\n".
			"\tNew Status: ".getOverallStatusText($overrideStatus)."\r\n".
			"\tComment: ".$comment."\r\n".
			"\t    URL: http".(isset($_SERVER['HTTPS']) ? "s" : "")."://".$_SERVER['HTTP_HOST'].$settings->_httpRoot."out/out.ViewDocument.php?documentid=".$documentid."\r\n\r\n";
		if (Email::toIndividual($user, $docOwner, $subject, $message)<0) {
			UI::contentSubHeading(getMLText("warning"));
			print "<p>Error sending email to document owner '".$docOwner->getFullName()."', &lt;".$docOwner->getEmail().">.</p>";
		}
		break;
	default:
		UI::contentSubHeading(getMLText("warning"));
		print "<p>Cannot change from status '".getOverallStatusText($overallStatus["status"])."' to status '".getOverallStatusText($overrideStatus)."'.</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
		break;
}

print "<p></p>";
UI::contentSubHeading(getMLText("override_content_status_complete"));
printMLText("status_change_summary", array("oldstatus"=>getOverallStatusText($overallStatus["status"]), "newstatus"=>getOverallStatusText($overrideStatus)));
UI::contentContainerEnd();
UI::htmlEndPage();
?>
