# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

# Adds an --enable-warnings argument to configure to
# allow enabling GCC warnings
#
# Usage:
#   NEON_WARNINGS

AC_DEFUN([NEON_WARNINGS],[

AC_REQUIRE([AC_PROG_CC])

AC_ARG_ENABLE(warnings,
	[  --enable-warnings       enable compiler warnings during build ],
	[with_warnings=$enableval],
	[with_warnings=no])  dnl Defaults to DISABLED

if test "$with_warnings" = "yes"; then
    if test "$GCC" = "yes"; then
	CFLAGS="$CFLAGS -Wall -ansi-pedantic -Wmissing-declarations -Winline -Wshadow -Wreturn-type -Wsign-compare -Wundef -Wpointer-arith -Wcast-align -Wbad-function-cast -Wimplicit-prototypes"
	if test -z "$with_ssl" -o "$with_ssl" = "no"; then
	    # OpenSSL headers fail strict prototypes checks
	    CFLAGS="$CFLAGS -Wstrict-prototypes"
	fi
    else
	# non-GCC compilers
	case `uname` in
	OSF1) CFLAGS="$CFLAGS -check -msg_disable returnchecks -msg_disable alignment -msg_disable overflow" ;;
	IRIX) CFLAGS="$CFLAGS -fullwarn" ;;
	UnixWare) CFLAGS="$CFLAGS -v" ;;
	*) AC_MSG_WARN([warning flags unknown for compiler on this platform]) ;;
	esac
    fi
fi

])

