/* 
   Utility functions for HTTP client tests
   Copyright (C) 2001-2002, Joe Orton <joe@manyfish.co.uk>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ne_session.h"

#include "child.h"
#include "tests.h"
#include "utils.h"

int make_session(ne_session **sess, server_fn fn, void *ud)
{
    *sess = ne_session_create("http", "localhost", 7777);
    return spawn_server(7777, fn, ud);
}

int single_serve_string(nsocket *s, void *userdata)
{
    const char *str = userdata;
    char buf[1024];

    ON(discard_request(s));
    
    while (clength > 0) {
	NE_DEBUG(NE_DBG_HTTP, "Discarding %ld bytes...\n", clength);
	clength -= sock_read(s, buf, clength);
    }

    ON(sock_send_string(s, str));

    return OK;
}

int many_serve_string(nsocket *s, void *userdata)
{
    char buf[1024];
    int n;
    struct many_serve_args *args = userdata;
    
    for (n = 0; n < args->count; n++) {
	ON(discard_request(s));
	
	while (clength > 0) {
	    NE_DEBUG(NE_DBG_HTTP, "Discarding %ld bytes...\n", clength);
	    clength -= sock_read(s, buf, clength);
	}
	
	ON(sock_send_string(s, args->str));
    }

    return OK;
}

int any_request(ne_session *sess, const char *uri)
{
    ne_request *req = ne_request_create(sess, "GET", uri);
    int ret;

    ret = ne_request_dispatch(req);

    ne_request_destroy(req);

    return ret;
}
