Description: fix privilege escalation bug
 OpenBSD 6.6 errata 019, January 30, 2020:
 .
 An incorrect check allows an attacker to trick mbox delivery into executing
 arbitrary commands as root and lmtp delivery into executing arbitrary commands
 as an unprivileged user.
Origin: https://ftp.openbsd.org/pub/OpenBSD/patches/6.6/common/019_smtpd_exec.patch.sig
Bug-Debian: https://bugs.debian.org/950121
---
This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
Index: opensmtpd/smtpd/smtp_session.c
===================================================================
--- opensmtpd.orig/smtpd/smtp_session.c	2020-01-28 17:56:24.026693606 -0500
+++ opensmtpd/smtpd/smtp_session.c	2020-01-28 17:56:24.022693963 -0500
@@ -2006,25 +2006,23 @@
 		memmove(maddr->user, p, strlen(p) + 1);
 	}
 
-	if (!valid_localpart(maddr->user) ||
-	    !valid_domainpart(maddr->domain)) {
-		/* accept empty return-path in MAIL FROM, required for bounces */
-		if (mailfrom && maddr->user[0] == '\0' && maddr->domain[0] == '\0')
-			return (1);
+	/* accept empty return-path in MAIL FROM, required for bounces */
+	if (mailfrom && maddr->user[0] == '\0' && maddr->domain[0] == '\0')
+		return (1);
 
-		/* no user-part, reject */
-		if (maddr->user[0] == '\0')
-			return (0);
-
-		/* no domain, local user */
-		if (maddr->domain[0] == '\0') {
-			(void)strlcpy(maddr->domain, domain,
-			    sizeof(maddr->domain));
-			return (1);
-		}
+	/* no or invalid user-part, reject */
+	if (maddr->user[0] == '\0' || !valid_localpart(maddr->user))
 		return (0);
+
+	/* no domain part, local user */
+	if (maddr->domain[0] == '\0') {
+		(void)strlcpy(maddr->domain, domain,
+			sizeof(maddr->domain));
 	}
 
+	if (!valid_domainpart(maddr->domain))
+		return (0);
+
 	return (1);
 }
 
