/* This is (osh) consult.c Version 1.0

Description:
   This program takes either 'ok' or 'no' to turn on and off the consult
key in the user's home directory.

----
Copyright (c) 1993 The Regents of the University of California
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that: (1) source code distributions
retain the above copyright notice and this paragraph in its entirety, (2)
distributions including binary code include the above copyright notice and
this paragraph in its entirety in the documentation or other materials
provided with the distribution, and (3) all advertising materials mentioning
features or use of this software display the following acknowledgement:
``This product includes software developed by the University of California,
Los Alamos National Laboratory and its contributors.'' Neither the name of
the University nore the names of its contributors may be used to endorse
or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

static char *rcsid="@(#) $Id: consult.c,v 1.2 1994/11/08 02:35:08 mcn Exp $";

#ifdef HAVE_CONFIG_H
#include <defs.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#ifdef HAVE_UDB_H
#include <udb.h>
#else
#include <pwd.h>
#endif
#include <unistd.h>
#include "config.h"

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

print_status()

{
#ifdef HAVE_UDB_H
struct udb *u_info;
#else
struct passwd *u_info;
#endif
char x[MAXPATHLEN];

#ifdef HAVE_UDB_H
u_info=getudbuid(getuid());
strcpy(x,u_info->ue_dir); /* User's home directory */
#else
u_info=getpwuid(getuid());
strcpy(x,u_info->pw_dir);
#endif
strcat(x,"/");
strcat(x,ACCESS_FILE);
if (!access(x,F_OK)) /* ie. if it exists */
  printf("Consulting is turned ON\n");
else
  printf("Consulting is turned OFF\n");
}


print_usage(cmd)
char *cmd;

{
printf("Consulting Approval Utility v1.0\n\n");
printf("  This program allows you to turn on and off the ability for the\n");
printf("consultants (and them ALONE) to look at your directory and files.\n\n");
printf("Usage:\n");
printf("%s on        Allow access\n",cmd);
printf("%s off       Disallow access\n\n",cmd);
printf("Currently: ");
print_status();
}


main(argc,argv)
int argc;
char *argv[];

{
#ifdef HAVE_UDB_H
struct udb *u_info;
#else
struct passwd *u_info;
#endif
char x[MAXPATHLEN];
FILE *fp;

if (argc!=2) {
	print_status();
	exit(0);
}

#ifdef HAVE_UDB_H
u_info=getudbuid(getuid());
strcpy(x,u_info->ue_dir);
#else
u_info=getpwuid(getuid());
strcpy(x,u_info->pw_dir);
#endif
strcat(x,"/");
strcat(x,ACCESS_FILE);

if (!strcmp(argv[1],"on")) {
	fp=fopen(x,"a");
	fprintf(fp,"\n");
	fclose(fp);
	print_status();
} else
if (!strcmp(argv[1],"off")) {
	if (!access(x,F_OK))
		unlink(x);
	print_status();
} else
print_usage(argv[0]);

exit(0);
}
