# --
# Kernel/Language/zh_TW.pm - provides Chinese Traditional language translation
# Copyright (C) 2009 Bin Du <bindu2008 at gmail.com>
# Copyright (C) 2009 Yiye Huang <yiyehuang at gmail.com>
# Copyright (C) 2009 Qingjiu Jia <jiaqj at yahoo.com>
# --
# $Id: zh_TW.pm,v 1.3.2.4 2009/12/09 12:03:37 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::zh_TW;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.3.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Thurs July16 13:56:58 2009

    # possible charsets
    $Self->{Charset} = ['big5', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = ' %A %Y/%M/%D %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'O',
        'No' => '_',
        'yes' => 'O',
        'no' => ']m',
        'Off' => '',
        'off' => '',
        'On' => '}',
        'on' => '}',
        'top' => '',
        'end' => '',
        'Done' => 'T{',
        'Cancel' => '',
        'Reset' => 'm',
        'last' => '̦Z',
        'before' => '',
        'day' => '',
        'days' => '',
        'day(s)' => '',
        'hour' => 'p',
        'hours' => 'p',
        'hour(s)' => 'p',
        'minute' => '',
        'minutes' => '',
        'minute(s)' => '',
        'month' => '',
        'months' => '',
        'month(s)' => '',
        'week' => 'P',
        'week(s)' => 'P',
        'year' => '~',
        'years' => '~',
        'year(s)' => '~',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'gD',
        'Message' => '',
        'Error' => '~',
        'Bug Report' => 'Bug i',
        'Attention' => '`N',
        'Warning' => 'ĵi',
        'Module' => 'Ҷ',
        'Modulefile' => 'Ҷ',
        'Subfunction' => 'l\',
        'Line' => '',
        'Setting' => ']m',
        'Settings' => ']m',
        'Example' => 'ܨ',
        'Examples' => 'ܨ',
        'valid' => '',
        'invalid' => 'L',
        '* invalid' => '* L',
        'invalid-temporarily' => 'ȮɵL',
        ' 2 minutes' => ' 2 ',
        ' 5 minutes' => ' 5 ',
        ' 7 minutes' => ' 7 ',
        '10 minutes' => '10 ',
        '15 minutes' => '15 ',
        'Mr.' => '',
        'Mrs.' => 'ҤH',
        'Next' => 'U@',
        'Back' => 'Zh',
        'Next...' => 'U@...',
        '...Back' => '...Zh',
        '-none-' => '-L-',
        'none' => 'L',
        'none!' => 'L!',
        'none - answered' => 'L - w_',
        'please do not edit!' => 'ns!',
        'AddLink' => 'W[챵',
        'Link' => '챵',
        'Unlink' => '챵',
        'Linked' => 'w챵',
        'Link (Normal)' => '챵 (`)',
        'Link (Parent)' => '챵 ()',
        'Link (Child)' => '챵 (l)',
        'Normal' => '`',
        'Parent' => '',
        'Child' => 'l',
        'Hit' => 'I',
        'Hits' => 'I',
        'Text' => '',
        'Lite' => '²',
        'User' => 'Τ',
        'Username' => 'ΤW',
        'Language' => 'y',
        'Languages' => 'y',
        'Password' => 'KX',
        'Salutation' => 'ٿ',
        'Signature' => 'ñW',
        'Customer' => 'Ȥ',
        'CustomerID' => 'Ȥs',
        'CustomerIDs' => 'Ȥs',
        'customer' => 'Ȥ',
        'agent' => '޳NH',
        'system' => 't',
        'Customer Info' => 'ȤH',
        'Customer Company' => 'Ȥ',
        'Company' => '',
        'go!' => '}l!',
        'go' => '}l',
        'All' => '',
        'all' => '',
        'Sorry' => '藍_',
        'update!' => 's!',
        'update' => 's',
        'Update' => 's',
        'Updated!' => '',
        'submit!' => '!',
        'submit' => '',
        'Submit' => '',
        'change!' => 'ק!',
        'Change' => 'ק',
        'change' => 'ק',
        'click here' => 'Io',
        'Comment' => '`',
        'Valid' => '',
        'Invalid Option!' => 'LĿﶵ!',
        'Invalid time!' => 'LĮɶ!',
        'Invalid date!' => 'LĤ!',
        'Name' => 'W',
        'Group' => 'զW',
        'Description' => 'yz',
        'description' => 'yz',
        'Theme' => 'DD',
        'Created' => 'Ы',
        'Created by' => 'Ыإ',
        'Changed' => 'wק',
        'Changed by' => 'ק',
        'Search' => 'j',
        'and' => 'M',
        'between' => 'b',
        'Fulltext Search' => 'j',
        'Data' => '',
        'Options' => 'ﶵ',
        'Title' => 'D',
        'Item' => '',
        'Delete' => 'R',
        'Edit' => 's',
        'View' => 'd',
        'Number' => 's',
        'System' => 't',
        'Contact' => 'ptH',
        'Contacts' => 'ptH',
        'Export' => 'ɥX',
        'Up' => 'W',
        'Down' => 'U',
        'Add' => 'W[',
        'Added!' => '',
        'Category' => 'ؿ',
        'Viewer' => 'dݾ',
        'Expand' => 'Xi',
        'New message' => 's',
        'New message!' => 's!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Х^_ TicketAMZ^쥿`C!',
        'You got new message!' => 'zs!',
        'You have %s new message(s)!' => 'z %s s!',
        'You have %s reminder ticket(s)!' => 'z %s Ӵ!',
        'The recommended charset for your language is %s!' => 'ĳzҥλyrŶ %s!',
        'Passwords doesn\'t match! Please try it again!' => 'KXšAЭ!',
        'Password is already in use! Please use an other password!' => 'ӱKXQϥΡAШϥΨLKX!',
        'Password is already used! Please use an other password!' => 'ӱKXQϥΡAШϥΨLKX!',
        'You need to activate %s first to use it!' => '%s bϥΤeХE!',
        'No suggestions' => 'Lĳ',
        'Word' => 'r',
        'Ignore' => '',
        'replace with' => '',
        'There is no account with that login name.' => 'ӥΤWSbH.',
        'Login failed! Your username or password was entered incorrectly.' => 'nѡAzΤWαKXT.',
        'Please contact your admin' => 'pttκ޲z',
        'Logout successful. Thank you for using OTRS!' => '\`PA¨ϥ!',
        'Invalid SessionID!' => 'LĪ|ܼѲ!',
        'Feature not active!' => 'ӯSʩ|E!',
        'Notification (Event)' => 'q]ƥ^',
        'Login is needed!' => 'ݭnn!',
        'Password is needed!' => 'ݭnKX!',
        'License' => '\i',
        'Take this Customer' => 'ooӫȤ',
        'Take this User' => 'ooӥΤ',
        'possible' => 'i',
        'reject' => 'ڵ',
        'reverse' => 'Zh',
        'Facility' => 'O',
        'Timeover' => '',
        'Pending till' => 'ݦ',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'nϥ UserID 1 (tν㸹)! гЫؤ@ӷsΤ!',
        'Dispatching by email To: field.' => 'l: .',
        'Dispatching by selected Queue.' => 'lҿﶤC.',
        'No entry found!' => 'Le!',
        'Session has timed out. Please log in again.' => '|ܶWɡAЭsn.',
        'No Permission!' => 'Lv!',
        'To: (%s) replaced with database email!' => 'To: (%s) Qƾڮwla}ҴN',
        'Cc: (%s) added database email!' => 'Cc: (%s) W[ƾڮwla}!',
        '(Click here to add)' => '(IBW[)',
        'Preview' => 'w',
        'Package not correctly deployed! You should reinstall the Package again!' => 'n]i}`! zݭnA@sw˳oӳn]',
        'Added User "%s"' => 'W[Τ "%s".',
        'Contract' => 'XP',
        'Online Customer: %s' => 'buȤ: %s',
        'Online Agent: %s' => 'bu޳NHG%s',
        'Calendar' => '',
        'File' => '',
        'Filename' => 'W',
        'Type' => '',
        'Size' => 'jp',
        'Upload' => 'W',
        'Directory' => 'ؿ',
        'Signed' => 'wñW',
        'Sign' => 'ñp',
        'Crypted' => 'w[K',
        'Crypt' => '[K',
        'Office' => '줽',
        'Phone' => 'q',
        'Fax' => 'ǯu',
        'Mobile' => '',
        'Zip' => 'ls',
        'City' => '',
        'Street' => 'D',
        'Country' => 'a',
        'Location' => '',
        'installed' => 'ww',
        'uninstalled' => 'w',
        'Security Note: You should activate %s because application is already running!' => 'w: zE %s, ]ΤwgbB!',
        'Unable to parse Online Repository index document!' => 'Cbu귽ޤ',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'bu귽Sn]ݭnج[ALج[һݳn]',
        'No Packages or no new Packages in selected Online Repository!' => 'bҿ諸bu귽AS{sηsn]',
        'printed at' => 'L',
        'Dear Mr. %s,' => 'Lq %s :',
        'Dear Mrs. %s,' => 'Lq %s kh:',
        'Dear %s,' => 'Lq %s:',
        'Hello %s,' => 'zn, %s:',
        'This account exists.' => 'oӱbwsb',
        'New account created. Sent Login-Account to %s.' => 'sbwЫ, ñHeq %s.',
        'Please press Back and try again.' => 'Ъ^Aդ@.',
        'Sent password token to: %s' => 'oeKX: %s',
        'Sent new password to: %s' => 'oesKX: %s',
        'Upcoming Events' => 'YNӪƥ',
        'Event' => 'ƥ',
        'Events' => 'ƥ',
        'Invalid Token!' => 'DkаO',
        'more' => 'h',
        'For more info see:' => 'hHЬ',
        'Package verification failed!' => 'n]',
        'Collapse' => '',
        'News' => 'sD',
        'Product News' => '~sD',
        'Bold' => '',
        'Italic' => '',
        'Underline' => 'u',
        'Font Color' => 'rC',
        'Background Color' => 'I',
        'Remove Formatting' => 'R榡',
        'Show/Hide Hidden Elements' => '/ ín',
        'Align Left' => '',
        'Align Center' => '~',
        'Align Right' => 'k',
        'Justify' => '',
        'Header' => 'HY',
        'Indent' => 'Y',
        'Outdent' => '~',
        'Create an Unordered List' => 'Ыؤ@ӵLǦC',
        'Create an Ordered List' => 'Ыؤ@ӦǦC',
        'HTML Link' => 'HTML챵',
        'Insert Image' => 'JϹ',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => '_',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => '@',
        'Feb' => 'G',
        'Mar' => 'T',
        'Apr' => '|',
        'May' => '',
        'Jun' => '',
        'Jul' => 'C',
        'Aug' => 'K',
        'Sep' => 'E',
        'Oct' => 'Q',
        'Nov' => 'Q@',
        'Dec' => 'QG',
        'January' => '@',
        'February' => 'G',
        'March' => 'T',
        'April' => '|',
        'June' => '',
        'July' => 'C',
        'August' => 'K',
        'September' => 'E',
        'October' => 'Q',
        'November' => 'Q@',
        'December' => 'QG',

        # Template: AAANavBar
        'Admin-Area' => '޲zϰ',
        'Agent-Area' => '޳NH',
        'Ticket-Area' => 'Ticket',
        'Logout' => '`P',
        'Agent Preferences' => 'ӤH]m',
        'Preferences' => ']m',
        'Agent Mailbox' => '޳NHlc',
        'Stats' => 'έp',
        'Stats-Area' => 'έp',
        'Admin' => '޲z',
        'Customer Users' => 'ȤΤ',
        'Customer Users <-> Groups' => 'ȤΤ <-> ',
        'Users <-> Groups' => 'Τ <-> ',
        'Roles' => '',
        'Roles <-> Users' => ' <-> Τ',
        'Roles <-> Groups' => ' <-> ',
        'Salutations' => 'ٿ',
        'Signatures' => 'ñW',
        'Email Addresses' => 'Email a}',
        'Notifications' => 'tγq',
        'Category Tree' => 'ؿ',
        'Admin Notification' => '޲zq',

        # Template: AAAPreferences
        'Preferences updated successfully!' => ']ms\!',
        'Mail Management' => 'l]m',
        'Frontend' => 'eݬɭ',
        'Other Options' => 'Lﶵ',
        'Change Password' => 'קKX',
        'New password' => 'sKX',
        'New password again' => '_sKX',
        'Select your QueueView refresh time.' => 'CϨsɶ.',
        'Select your frontend language.' => 'ɭy',
        'Select your frontend Charset.' => 'ɭrŶ.',
        'Select your frontend Theme.' => 'ɭDD.',
        'Select your frontend QueueView.' => 'C.',
        'Spelling Dictionary' => 'gˬdr',
        'Select your default spelling dictionary.' => 'ʬ٫gˬdr.',
        'Max. shown Tickets a page in Overview.' => 'C@ܪ̤j Tickets ƥ.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'KX⦸šALksAЭsJ',
        'Can\'t update password, invalid characters!' => 'LksKXA]tLĦr.',
        'Can\'t update password, must be at least %s characters!' => 'LksKXAKXצܤ%s.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'LksKXAܤ֥]t2ӤjgrũM2Ӥpgr.',
        'Can\'t update password, needs at least 1 digit!' => 'LksKXAܤ֥]t1Ʀr',
        'Can\'t update password, needs at least 2 characters!' => 'LksKXAܤ֥]t2Ӧr!',

        # Template: AAAStats
        'Stat' => 'έp',
        'Please fill out the required fields!' => 'жgrq',
        'Please select a file!' => 'пܤ@Ӥ!',
        'Please select an object!' => 'пܤ@ӹH!',
        'Please select a graph size!' => 'пܹϤؤo!',
        'Please select one element for the X-axis!' => 'пܤ@ӤX-b',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'аܤ@ӤQ쪺\'Fixed\'s',
        'If you use a checkbox you have to select some attributes of the select field!' => 'pGAϥδ_اAܳQ쪺@ݩ!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'bwJдJ@ӭȡA\'Fixed\'_ءI',
        'The selected end time is before the start time!' => 'wɶ}lɶI',
        'You have to select one or more attributes from the select field!' => 'qQ줤Aܤ@өΦhݩʡI',
        'The selected Date isn\'t valid!' => 'ҿ',
        'Please select only one or two elements via the checkbox!' => 'qL_ءAаܤ@өΨӭnI',
        'If you use a time scale element you can only select one element!' => 'pGzϥΪOɶث׭nAܨ䤤@Ӳզ',
        'You have an error in your time selection!' => 'A@ӿ~ɶܡI',
        'Your reporting time interval is too small, please use a larger time scale!' => 'ziɶjӤpAШϥΧjj',
        'The selected start time is before the allowed start time!' => 'w}lɶ󤹳\}lɶ',
        'The selected end time is after the allowed end time!' => 'wɶߩ󤹳\ɶ',
        'The selected time period is larger than the allowed time period!' => 'bwɶqj󤹳\ɶq',
        'Common Specification' => '@PWS',
        'Xaxis' => 'Xb',
        'Value Series' => 'ȨtC',
        'Restrictions' => '',
        'graph-lines' => 'u',
        'graph-bars' => 'W',
        'graph-hbars' => 'HW',
        'graph-points' => 'I',
        'graph-lines-points' => 'ϽuI',
        'graph-area' => 'ϰ',
        'graph-pie' => '',
        'extended' => 'Xi',
        'Agent/Owner' => 'Ҧ',
        'Created by Agent/Owner' => '޳NHЫت',
        'Created Priority' => 'Ыتu',
        'Created State' => 'ЫتA',
        'Create Time' => 'Ыخɶ',
        'CustomerUserLogin' => 'Ȥn',
        'Close Time' => 'ɶ',
        'TicketAccumulation' => 'Ticketn',
        'Attributes to be printed' => 'nLݩ',
        'Sort sequence' => 'ƧǧǦC',
        'Order by' => 'Ǳ',
        'Limit' => '',
        'Ticketlist' => 'TicketM',
        'ascending' => 'ɧ',
        'descending' => '',
        'First Lock' => 'w',
        'Evaluation by' => 'H',
        'Total Time' => '`ɶ',
        'Ticket Average' => 'TicketBzɶ',
        'Ticket Min Time' => 'TicketBz̤pɶ',
        'Ticket Max Time' => 'TicketBz̤jɶ',
        'Number of Tickets' => 'Ticketƥ',
        'Article Average' => 'ArticleBzɶ',
        'Article Min Time' => 'ArticleBz̤pɶ',
        'Article Max Time' => 'ArticleBz̤jɶ',
        'Number of Articles' => 'Articleƶq',
        'Accounted time by Agent' => '޳NHBzTicketҥΪɶ',
        'Ticket/Article Accounted Time' => 'Ticket/ArticleҦΪɶ',
        'TicketAccountedTime' => 'TicketҦΪɶ',
        'Ticket Create Time' => 'TicketЫخɶ',
        'Ticket Close Time' => 'Ticketɶ',

        # Template: AAATicket
        'Lock' => 'w',
        'Unlock' => '',
        'History' => 'v',
        'Zoom' => 'li}',
        'Age' => '`ɶ',
        'Bounce' => '^h',
        'Forward' => 'o',
        'From' => 'oH',
        'To' => 'H',
        'Cc' => '۰e',
        'Bcc' => 'te',
        'Subject' => 'D',
        'Move' => '',
        'Queue' => 'C',
        'Priority' => 'u',
        'Priority Update' => 'su',
        'State' => 'A',
        'Compose' => 'g',
        'Pending' => '',
        'Owner' => 'Ҧ',
        'Owner Update' => 'sҦ',
        'Responsible' => 'tdH',
        'Responsible Update' => 'stdH',
        'Sender' => 'oH',
        'Article' => 'H',
        'Ticket' => 'Ticket',
        'Createtime' => 'Ыخɶ',
        'plain' => '¤奻',
        'Email' => 'la}',
        'email' => 'E-Mail',
        'Close' => '',
        'Action' => 'ʧ@',
        'Attachment' => '',
        'Attachments' => '',
        'This message was written in a character set other than your own.' => 'oʶlҥΦrŶPtΦrŶ',
        'If it is not displayed correctly,' => 'pGܤT,',
        'This is a' => 'oO@',
        'to open it in a new window.' => 'bsf}',
        'This is a HTML email. Click here to show it.' => 'oO@HTML榡lAIo.',
        'Free Fields' => 'B~H',
        'Merge' => 'X',
        'merged' => 'wX',
        'closed successful' => '\',
        'closed unsuccessful' => '',
        'new' => 's',
        'open' => '}',
        'Open' => '}',
        'closed' => '',
        'Closed' => '',
        'removed' => 'R',
        'pending reminder' => 'ݴ',
        'pending auto' => '۰ʵ',
        'pending auto close+' => 'ݦ۰+',
        'pending auto close-' => 'ݦ۰-',
        'email-external' => '~ E-Mail ',
        'email-internal' => ' E-Mail ',
        'note-external' => '~`',
        'note-internal' => '`',
        'note-report' => '`ѳi',
        'phone' => 'q',
        'sms' => 'uH',
        'webrequest' => 'WebШD',
        'lock' => 'w',
        'unlock' => 'w',
        'very low' => 'D`C',
        'low' => 'C',
        'normal' => '`',
        'high' => '',
        'very high' => 'D`',
        '1 very low' => '1 D`C',
        '2 low' => '2 C',
        '3 normal' => '3 `',
        '4 high' => '4 ',
        '5 very high' => '5 D`',
        'Ticket "%s" created!' => 'Ticket "%s" wЫ!',
        'Ticket Number' => 'Ticket s',
        'Ticket Object' => 'Ticket H',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ticket "%s" sbAЫب䪺챵!',
        'Don\'t show closed Tickets' => 'ܤw Tickets',
        'Show closed Tickets' => 'ܤw Tickets',
        'New Article' => 's峹',
        'Email-Ticket' => 'l Ticket',
        'Create new Email Ticket' => 'Ыطsl Ticket',
        'Phone-Ticket' => 'q Ticket',
        'Search Tickets' => 'j Tickets',
        'Edit Customer Users' => 'sȤb',
        'Edit Customer Company' => 'sȤ',
        'Bulk Action' => 'qBz',
        'Bulk Actions on Tickets' => 'qBz Tickets',
        'Send Email and create a new Ticket' => 'oe Email óЫؤ@ӷs Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Ыطs TicketõoeXh',
        'Create new Phone Ticket (Inbound)' => 'ЫطsqTicket]iӪTicket^',
        'Overview of all open Tickets' => 'Ҧ} Tickets p',
        'Locked Tickets' => 'ww Ticket',
        'Watched Tickets' => 'q\ Tickets',
        'Watched' => 'q',
        'Subscribe' => 'q',
        'Unsubscribe' => 'hq',
        'Lock it to work on it!' => 'wö}lu@ !',
        'Unlock to give it back to the queue!' => 'ðe^C!',
        'Shows the ticket history!' => ' Ticket vp!',
        'Print this ticket!' => 'L Ticket !',
        'Change the ticket priority!' => 'ק Ticket u',
        'Change the ticket free fields!' => 'ק Ticket B~H',
        'Link this ticket to an other objects!' => '챵 Ticket LH!',
        'Change the ticket owner!' => 'ק Ticket Ҧ!',
        'Change the ticket customer!' => 'ק Ticket ݫȤ!',
        'Add a note to this ticket!' => ' Ticket W[`!',
        'Merge this ticket!' => 'Xø Ticket!',
        'Set this ticket to pending!' => 'N Ticket JݪA',
        'Close this ticket!' => ' Ticket!',
        'Look into a ticket!' => 'd Ticket e',
        'Delete this ticket!' => 'R Ticket!',
        'Mark as Spam!' => 'аOU!',
        'My Queues' => 'ڪC',
        'Shown Tickets' => ' Tickets',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'zl "<OTRS_TICKET>" QXè "<OTRS_MERGE_TO_TICKET>" !',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: Ĥ@TɶwӮ(%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: Ĥ@TɶNӮ(%s)!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: sɶwӮ(%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: sɶNӮ(%s)!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: BzѨMwӮ(%s)!',
        'Ticket %s: solution time will be over in %s!' => 'BzѨMNӮ(%s)!',
        'There are more escalated tickets!' => 'hɯŪtickets',
        'New ticket notification' => 's Ticket q',
        'Send me a notification if there is a new ticket in "My Queues".' => 'pGڪCs TicketAгq.',
        'Follow up notification' => 'ܳq',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'pGȤoeF Ticket ^_AåBڬO Ticket Ҧ.',
        'Ticket lock timeout notification' => 'Ticket wWɳq ',
        'Send me a notification if a ticket is unlocked by the system.' => 'pG Ticket QtθAгq.',
        'Move notification' => 'ʳq',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'pG Ticket QJڪCAгq.',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'ẕ`ζCApGzl]mEAzN|oӶCAq.',
        'Custom Queue' => 'ȤᶤC',
        'QueueView refresh time' => 'CϨsɶ',
        'Screen after new ticket' => 'Ыطs Ticket Z',
        'Select your screen after creating a new ticket.' => 'ܱzЫطs Ticket ZAܪ.',
        'Closed Tickets' => ' Tickets',
        'Show closed tickets.' => 'ܤw Tickets.',
        'Max. shown Tickets a page in QueueView.' => 'CϨC Ticket .',
        'Watch notification' => '`q',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'ک`ticketAticket֦H@ˡAڤ]o@q',
        'Out Of Office' => 'b줽',
        'Select your out of office time.' => 'ܧAb줽Ǫɶ',
        'CompanyTickets' => 'qTickets',
        'MyTickets' => 'ڪ Tickets',
        'New Ticket' => 's Ticket',
        'Create new Ticket' => 'Ыطs Ticket',
        'Customer called' => 'ȤPq',
        'phone call' => 'qܩIs',
        'Reminder Reached' => 'wF',
        'Reminder Tickets' => ' Ticket',
        'Escalated Tickets' => 'ɯŪTicket',
        'New Tickets' => 'sTicket',
        'Open Tickets / Need to be answered' => '}Tickets/ݭn^',
        'Tickets which need to be answered!' => 'ݭn^ Ticket',
        'All new tickets!' => 'Ҧstickets',
        'All tickets which are escalated!' => 'ҦɯŪtickets',
        'All tickets where the reminder date has reached!' => 'Ҧw촣Ticket',
        'Responses' => '^_',
        'Responses <-> Queue' => '^_ <-> C',
        'Auto Responses' => '۰ʦ^_\',
        'Auto Responses <-> Queue' => '۰ʦ^_ <-> C',
        'Attachments <-> Responses' => ' <-> ^_',
        'History::Move' => 'Ticket 춤C "%s" (%s) qC "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'sAȯŧOĳ to %s (ID=%s).',
        'History::NewTicket' => 'New ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => '۰ʩڵoe "%s".',
        'History::SendAutoReply' => '۰ʦ^_oe "%s".',
        'History::SendAutoFollowUp' => '۰ʸܵoe "%s".',
        'History::Forward' => 'o "%s".',
        'History::Bounce' => '^h "%s".',
        'History::SendAnswer' => 'Hoe "%s".',
        'History::SendAgentNotification' => '"%s"-Benachrichtigung versand an "%s".',
        'History::SendCustomerNotification' => 'qoe "%s".',
        'History::EmailAgent' => 'ol󵹫Ȥ.',
        'History::EmailCustomer' => 'Add mail. %s',
        'History::PhoneCallAgent' => 'Called customer',
        'History::PhoneCallCustomer' => 'ȤwLq',
        'History::AddNote' => '[` (%s)',
        'History::Lock' => 'Ticket w.',
        'History::Unlock' => 'Ticket .',
        'History::TimeAccounting' => '%s time unit(d) counted. Totaly %s time unit(s) counted.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Refreshed: %s',
        'History::PriorityUpdate' => 'uųQsAq  "%s" (%s)  "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop protection! sent no auto answer to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Refreshed: %s',
        'History::StateUpdate' => 'Before "%s" s: "%s"',
        'History::TicketFreeTextUpdate' => 'Refreshed: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'ȤiWШD.',
        'History::TicketLinkAdd' => 'Link to "%s" established.',
        'History::TicketLinkDelete' => 'Link to "%s" removed.',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'P',
        'Mon' => 'P@',
        'Tue' => 'PG',
        'Wed' => 'PT',
        'Thu' => 'P|',
        'Fri' => 'P',
        'Sat' => 'P',

        # Template: AdminAttachmentForm
        'Attachment Management' => '޲z',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => '۰ʦ^_޲z',
        'Response' => '^_',
        'Auto Response From' => '۰ʦ^_Ӧ',
        'Note' => '`',
        'Useable options' => 'iΧܶq',
        'To get the first 20 character of the subject.' => 'ܼDe20Ӧr`',
        'To get the first 5 lines of the email.' => 'ܹqle',
        'To get the realname of the sender (if given).' => 'ܵoHuWr',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'eȤHiﶵ (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Ticket֦̪iﶵ e. g. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Ticketdﶵ (e. g. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => '',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '޲zȤH',
        'Search for' => 'j',
        'Add Customer Company' => 'W[ȤH',
        'Add a new Customer Company.' => 'W[ȤH',
        'List' => 'C',
        'This values are required.' => 'ӱإg.',
        'This values are read only.' => 'ӼƾڰŪ.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'igfwgQ,hX.',
        'This window must be called from compose window' => 'ӵfѼgfե',
        'Customer User Management' => 'ȤΤ޲z',
        'Add Customer User' => 'W[ȤH',
        'Source' => 'ƾڷ',
        'Create' => 'Ы',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'ȤΤᥲ@ӽ㸹qȤnnt.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'ȤΤ <->  ޲z',
        'Change %s settings' => 'ק %s ]m',
        'Select the user:group permissions.' => ' Τ: v.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'pGܡAhӲըSv (ӲյLkBz Ticket)',
        'Permission' => 'v',
        'ro' => 'Ū',
        'Read only access to the ticket in this group/queue.' => 'C Ticket Ū.',
        'rw' => 'Ūg',
        'Full read and write access to the tickets in this group/queue.' => 'C Ticket Ū/g.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Ȥb <-> AȺ޲z',
        'CustomerUser' => 'ȤΤ',
        'Service' => 'A',
        'Edit default services.' => 'sq{A',
        'Search Result' => 'jG',
        'Allocate services to CustomerUser' => 'tAȵȤ',
        'Active' => 'E',
        'Allocate CustomerUser to service' => 'ȤA',

        # Template: AdminEmail
        'Message sent to' => 'oe',
        'A message should have a subject!' => 'l󥲶D!',
        'Recipients' => 'H',
        'Body' => 'e',
        'Send' => 'oe',

        # Template: AdminGenericAgent
        'GenericAgent' => 'p',
        'Job-List' => 'u@C',
        'Last run' => '̦ZB',
        'Run Now!' => '{bB!',
        'x' => '',
        'Save Job as?' => 'Osu@?',
        'Is Job Valid?' => 'u@O_?',
        'Is Job Valid' => 'u@',
        'Schedule' => 'w',
        'Currently this generic agent job will not run automatically.' => 'ثeo@qAgent@~N|۰ʹB',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'ҥΦ۰ʰܤֿܤ@ӭȤAɶM',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '峹j (Ҧp: "Mar*in" Ϊ "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '  Ҧp: 10*5144 Ϊ 105658*',
        '(e. g. 234321)' => 'Ҧp: 234321',
        'Customer User Login' => 'ȤΤnH',
        '(e. g. U5150)' => 'Ҧp: U5150',
        'SLA' => 'AȯŧOĳ(SLA)',
        'Agent' => '޳NH',
        'Ticket Lock' => 'Ticket ꪬA',
        'TicketFreeFields' => 'Ticket ۥѰϰ',
        'Create Times' => 'Ыخɶ',
        'No create time settings.' => 'SЫخɶ]m',
        'Ticket created' => 'Ыخɶ',
        'Ticket created between' => ' Ыخɶb',
        'Close Times' => 'ɶ',
        'No close time settings.' => '',
        'Ticket closed' => ' Ticket',
        'Ticket closed between' => '',
        'Pending Times' => 'ݩwɶ',
        'No pending time settings.' => 'S]mݩwɶ',
        'Ticket pending time reached' => 'ݩwɶw쪺Ticket',
        'Ticket pending time reached between' => 'bݩwɶTicket ',
        'Escalation Times' => 'ɯŮɶ',
        'No escalation time settings.' => 'SɯŮɶ]m',
        'Ticket escalation time reached' => 'wɯŮɶTicket',
        'Ticket escalation time reached between' => 'bɯŮɶTicket',
        'Escalation - First Response Time' => 'Ƚդ - ^_ɶ',
        'Ticket first response time reached' => '^_ɶw쪺Ticket',
        'Ticket first response time reached between' => 'b^_ɶTicket',
        'Escalation - Update Time' => 'Ƚդ - sɶ',
        'Ticket update time reached' => 'sɶw쪺Ticket',
        'Ticket update time reached between' => 'bsɶTicket',
        'Escalation - Solution Time' => 'Ƚդ - ѨMɶ',
        'Ticket solution time reached' => '׸ѨMɶw쪺Ticket',
        'Ticket solution time reached between' => 'b׸ѨMɶw쪺Ticket',
        'New Service' => 'sAȯŧO',
        'New SLA' => 'sAȯŧOĳ(SLA)',
        'New Priority' => 'su',
        'New Queue' => 'sC',
        'New State' => 'sA',
        'New Agent' => 's޳NH',
        'New Owner' => 'sҦ',
        'New Customer' => 'sȤ',
        'New Ticket Lock' => 's Ticket ',
        'New Type' => 's',
        'New Title' => 'sD',
        'New TicketFreeFields' => 's Ticket ۥѰϰ',
        'Add Note' => 'W[`',
        'Time units' => 'ɶ椸',
        'CMD' => 'RO',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'NoөRO, Ĥ@ӰѼƬO Ticket sAĤGӰѼƬO Ticket Ѳ.',
        'Delete tickets' => 'R Tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'ĵi!  Ticket N|qƾڮwRALk_!',
        'Send Notification' => 'oeq',
        'Param 1' => 'Ѽ 1',
        'Param 2' => 'Ѽ 2',
        'Param 3' => 'Ѽ 3',
        'Param 4' => 'Ѽ 4',
        'Param 5' => 'Ѽ 5',
        'Param 6' => 'Ѽ 6',
        'Send agent/customer notifications on changes' => 'oeNz/Ȥqܧ',
        'Save' => 'Os',
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets vT! zTwnϥγoӭp?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'ĵiGz\'޲z\'ժWٮɡAbSysConfig@XܤƤeAANQ޲zOIpGoͳoرpAХSQLyyզW^\'admin\'',
        'Group Management' => 'պ޲z',
        'Add Group' => 'W[s',
        'Add a new Group.' => 'W[@ӷs',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin եiHiJtκ޲zϰ, Stats եiHiJέp޲z',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'ЫطsըӱPsv',
        'It\'s useful for ASP solutions.' => 'oO@ӦĪΪAȴѰ(ASP)ѨM.',

        # Template: AdminLog
        'System Log' => 'tΤ',
        'Time' => 'ɶ',

        # Template: AdminMailAccount
        'Mail Account Management' => 'lb޲z',
        'Host' => 'D',
        'Trusted' => 'O_H',
        'Dispatching' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'ҦӦۤ@Ӷl㸹lN|QoҿﶤC!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'pGzbOȱoH઺A{X-OTRSDFɶ]uA ... ^NQϥΡIlFLoNQϥ',

        # Template: AdminNavigationBar
        'Users' => 'Τ',
        'Groups' => '',
        'Misc' => 'X',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'q޲z',
        'Add Notification' => 'W[q',
        'Add a new Notification.' => '',
        'Name is required!' => 'ݭnW!',
        'Event is required!' => 'ݭnƥ',
        'A message should have a body!' => 'l󥲶]te!',
        'Recipient' => 'H',
        'Group based' => 'ժ',
        'Agent based' => '޳NN',
        'Email based' => 'ql',
        'Article Type' => 'ArticleO ',
        'Only for ArticleCreate Event.' => '',
        'Subject match' => 'Dǰt',
        'Body match' => 'eǰt',
        'Notifications are sent to an agent or a customer.' => 'qQoe޳NHΪ̫Ȥ.',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminNotificationForm
        'Notification' => 'tγq',

        # Template: AdminPackageManager
        'Package Manager' => 'n]޲z',
        'Uninstall' => '',
        'Version' => '',
        'Do you really want to uninstall this package?' => 'O_T{ӳn]?',
        'Reinstall' => 'sw',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'zO_Ʀnsw˳oǳn] (Ҧu]mN|)?',
        'Continue' => '~',
        'Install' => 'w',
        'Package' => 'n]',
        'Online Repository' => 'buѮw',
        'Vendor' => 'Ѫ',
        'Module documentation' => 'Ҷ',
        'Upgrade' => 'ɯ',
        'Local Repository' => 'aѮw',
        'Status' => 'A',
        'Overview' => 'p',
        'Download' => 'U',
        'Rebuild' => 'sc',
        'ChangeLog' => 'ܰO',
        'Date' => '',
        'Filelist' => 'M',
        'Download file from package!' => 'qn]UoӤ',
        'Required' => 'ݪ',
        'PrimaryKey' => '䪺Key',
        'AutoIncrement' => '۰ʻW',
        'SQL' => 'SQL',
        'Diff' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'tκʵ',
        'This feature is enabled!' => 'ӥ\wҥ',
        'Just use this feature if you want to log each request.' => 'pGzQԲӰOCӽШD, ziHϥθӥ\.',
        'Activating this feature might affect your system performance!' => 'Ұʸӥ\ivTztΩʯ',
        'Disable it here!' => 'ӥ\',
        'This feature is disabled!' => 'ӥ\w',
        'Enable it here!' => '}ӥ\',
        'Logfile too large!' => 'ӤLj',
        'Logfile too large, you need to reset it!' => 'ӤLj, Aݭnm',
        'Range' => 'S',
        'Interface' => 'ɭ',
        'Requests' => 'ШD',
        'Min Response' => '̤p^',
        'Max Response' => '̤j^',
        'Average Response' => '^',
        'Period' => 'P',
        'Min' => '̤p',
        'Max' => '̤j',
        'Average' => '',

        # Template: AdminPGPForm
        'PGP Management' => 'PGP ޲z',
        'Result' => 'G',
        'Identifier' => 'Ѳ',
        'Bit' => '',
        'Key' => 'K',
        'Fingerprint' => 'L',
        'Expires' => 'L',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'oؤ覡AziHsbSysConfig]m',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'lLo޲z',
        'Filtername' => 'LoW',
        'Stop after match' => '',
        'Match' => 'ǰt',
        'Value' => '',
        'Set' => ']m',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'pGzQھ X-Headers eӹLoAiHϥΥWhF.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'pGzQȤǰtemail a}A ШϥEMAILADDRESS:info@example.com in From, To or Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'pGzRegExpAz]ϥΤǰtin () as [***] in \'Set\'',

        # Template: AdminPriority
        'Priority Management' => 'uv޲z',
        'Add Priority' => 'K[uv',
        'Add a new Priority.' => 'W[@ӷsuv',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'C <-> ۰ʦ^_޲z',
        'settings' => ']m',

        # Template: AdminQueueForm
        'Queue Management' => 'C޲z',
        'Sub-Queue of' => 'lC',
        'Unlock timeout' => '۰ʸWɴ',
        '0 = no unlock' => '0 = ۰ʸ  ',
        'Only business hours are counted.' => 'ȥHWZɶp',
        '0 = no escalation' => '0 = L  ',
        'Notify by' => 'i׳q',
        'Follow up Option' => 'iﶵ',
        'Ticket lock after a follow up' => 'iT{HZATicket NQ۰ʤW',
        'Systemaddress' => 'tζla}',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'pG޳NHwF Ticket,Ob@wɶS^_A Ticket N|Q۰ʸAӹҦ޳NHi.',
        'Escalation time' => 'ɵ_ɶ',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'ӶCܳWwɶSQBz Ticket',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'pG Ticket wgBAAӫȤNoeF@Ӹi TicketAo Ticket N|Q[AөҦ̳QwqөҦ',
        'Will be the sender address of this queue for email answers.' => '^_lҥΪoe̦a}',
        'The salutation for email answers.' => '^_lҥκٿ.',
        'The signature for email answers.' => '^_lҥñW.',
        'Customer Move Notify' => 'Ticket ʫȤq',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'pG Ticket QʡAtαN|oe@ӳql󵹫Ȥ',
        'Customer State Notify' => 'Ticket AȤq',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'pG Ticket AܡAtαN|oeql󵹫Ȥ',
        'Customer Owner Notify' => 'ȤҦ̳qi',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'pG Ticket Ҧ̧ܡAtαN|oeql󵹫Ȥ.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => '^_ <-> C޲z',

        # Template: AdminQueueResponsesForm
        'Answer' => '^_',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => '^_ <-> ޲z',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => '^_e޲z',
        'A response is default text to write faster answer (with default text) to customers.' => 'Fֳt^_A^_ewqFCӦ^__e.',
        'Don\'t forget to add a new response a queue!' => 'nѰOW[@ӷs^_e춤C!',
        'The current ticket state is' => 'e Ticket AO',
        'Your email address is new' => 'zla}Os',

        # Template: AdminRoleForm
        'Role Management' => '޲z',
        'Add Role' => 'W[',
        'Add a new Role.' => 'sW@Ө',
        'Create a role and put groups in it. Then add the role to the users.' => 'Ыؤ@ӨñNե[J,MZNᵹΤ.',
        'It\'s useful for a lot of users and groups.' => 'jqΤMժɭԡAD`AX.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => ' <-> պ޲z',
        'move_into' => 'ʨ',
        'Permissions to move tickets into this group/queue.' => '\ Tickets Ӳ/C.',
        'create' => 'Ы',
        'Permissions to create tickets in this group/queue.' => 'bӲ/CЫ Tickets v.',
        'owner' => 'Ҧ',
        'Permissions to change the ticket owner in this group/queue.' => 'bӲ/Cק Tickets Ҧ̪v.',
        'priority' => 'u',
        'Permissions to change the ticket priority in this group/queue.' => 'bӲ/Cק Tickets uŪv.',

        # Template: AdminRoleGroupForm
        'Role' => '',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => ' <-> Τ޲z',
        'Select the role:user relations.' => ' :Τ p.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => '٩Iy޲z',
        'Add Salutation' => 'W[٩Iy',
        'Add a new Salutation.' => 'W[@ӷs٩Iy',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'wҦݭnҰ',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'blw˵ZAwҦq`NQ]m',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'FsWeb ɭwˡAwҦdisabled',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'pGҰʼҦSQҰʡAгqLtγ]mҰʥ]zOTRS{ǤwgB',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'SQLdߵf',
        'Go' => '',
        'Select Box Result' => 'dߵG',

        # Template: AdminService
        'Service Management' => 'AȺ޲z',
        'Add Service' => 'W[A',
        'Add a new Service.' => 'sW@ӪA',
        'Sub-Service of' => 'lAݩ',

        # Template: AdminSession
        'Session Management' => '|ܺ޲z',
        'Sessions' => '|',
        'Uniq' => '@',
        'Kill all sessions' => 'פҦ|',
        'Session' => '|',
        'Content' => 'e',
        'kill session' => 'פ|',

        # Template: AdminSignatureForm
        'Signature Management' => 'ñW޲z',
        'Add Signature' => 'W[ñW',
        'Add a new Signature.' => 'sW@ñW',

        # Template: AdminSLA
        'SLA Management' => 'AȯŧOĳ(SLA)޲z',
        'Add SLA' => 'W[AȯŧOĳ(SLA)',
        'Add a new SLA.' => 'sW@ӪAȯŧOĳ(SLA).',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'S/MIME ޲z',
        'Add Certificate' => 'K[',
        'Add Private Key' => 'K[p',
        'Secret' => 'KX',
        'Hash' => 'Hash',
        'In this way you can directly edit the certification and private keys in file system.' => 'γoؤ覡ziHsѩMp',

        # Template: AdminStateForm
        'State Management' => 'A޲z',
        'Add State' => 'W[A',
        'Add a new State.' => 'W[@ӷsA',
        'State Type' => 'A',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'zPɧsF Kernel/Config.pm ʬ٪A!',
        'See also' => 'Ѩ',

        # Template: AdminSysConfig
        'SysConfig' => 'tΰtm',
        'Group selection' => 'ܲ',
        'Show' => '',
        'Download Settings' => 'U]m',
        'Download all system config changes.' => 'UҦtΰtmܤ.',
        'Load Settings' => '[]m',
        'Subgroup' => 'l',
        'Elements' => '',

        # Template: AdminSysConfigEdit
        'Config Options' => 'tmﶵ',
        'Default' => 'ʬ',
        'New' => 's',
        'New Group' => 's',
        'Group Ro' => 'Ūv',
        'New Group Ro' => 'sŪv',
        'NavBarName' => 'ɯW',
        'NavBar' => 'ɯ',
        'Image' => 'Ϥ',
        'Prio' => 'u',
        'Block' => '',
        'AccessKey' => 'i_',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'tζla}޲z',
        'Add System Address' => 'W[tζla}',
        'Add a new System Address.' => 'W[@ӷstζla}.',
        'Realname' => 'umW',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'ҦoeӦHNQҿܪC',

        # Template: AdminTypeForm
        'Type Management' => '޲z',
        'Add Type' => 'W[',
        'Add a new Type.' => 'W[@ӷs',

        # Template: AdminUserForm
        'User Management' => 'H޲z',
        'Add User' => 'W[H',
        'Add a new Agent.' => 'W[@ӷsH',
        'Login as' => 'nW',
        'Firstname' => 'W',
        'Lastname' => 'm',
        'Start' => '}l',
        'End' => '',
        'User will be needed to handle tickets.' => 'ݭnΤӳBz Tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'nѰOW[@ӥΤթM!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Τ <-> պ޲z',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'a}ï',
        'Return to the compose screen' => '^켶g',
        'Discard all changes and return to the compose screen' => 'Ҧק,^켶g',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => 'Чs',
        'Release Note' => 'o`',
        'Level' => 'ŧO',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Ա',

        # Template: AgentLinkObject
        'Link Object: %s' => 'sH: %s',
        'Object' => 'H',
        'Link Object' => '챵H',
        'with' => 'M',
        'Select' => '',
        'Unlink Object: %s' => 'sH %s',

        # Template: AgentLookup
        'Lookup' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'gˬd',
        'spelling error(s)' => 'g~',
        'or' => 'Ϊ',
        'Apply these changes' => 'γoǧ',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'zO_T{RӹH?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'ܭѼơAϲέpS',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => 'аܤ@ӤQ쪺\'Fixed\'s',
        'Absolut Period' => 'P',
        'Between' => '',
        'Relative Period' => '۹P',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => 'ziHzέpwѼ',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'pGzR_bTw_ءAͦӲέp޳NNiHܬnݩ',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'J@PWS',
        'Permissions' => 'i',
        'Format' => '榡',
        'Graphsize' => 'ϧΤ',
        'Sum rows' => '`M',
        'Sum columns' => '`MC',
        'Cache' => 'ws',
        'Required Field' => 'rq',
        'Selection needed' => 'ܻݭn',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => 'HoاΦAziHܰ򥻳WS',
        'Attribute' => 'ݩ',
        'Title of the stat.' => 'έpD',
        'Here you can insert a description of the stat.' => 'ziHJέpyz',
        'Dynamic-Object' => 'ʺAH',
        'Here you can select the dynamic object you want to use.' => 'ziHܱzݭnϥΪʺAH',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '`GoMzw˦hְʺAHiHϥ',
        'Static-File' => 'RA',
        'For very complex stats it is possible to include a hardcoded file.' => 'D`_έpi]A@ӵwsX',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'pG@ӷswsXsbAiݩʱNܡAziHܨ䤤@',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'v]mCziHܤ@өΦhӹAP޳NNiݨӰtmέp',
        'Multiple selection of the output format.' => 'X榡hؿ',
        'If you use a graph as output format you have to select at least one graph size.' => 'pGzϥΪOϧΪX榡Aܤֿܤ@ӹϧΪjp',
        'If you need the sum of every row select yes' => 'pݭnC檺`M yes',
        'If you need the sum of every column select yes.' => 'pݭnCC`Mܡyes',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'jhƪέpƥiHws,oN[ֳo@έpi.',
        '(Note: Useful for big databases and low performance server)' => '`GAΩjƾڮwMCʯ઺AȾ',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'εLĪέpiͦέp',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'oOD`ΪApGAQHoέpGβέpGä',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'ܻȨtCn',
        'Scale' => 'ث',
        'minimal' => '̤p',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'аOAoBȨtCnjXbثס]pX -b=>A ValueSeries =>~^ ',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwq@tCȡCAiܤ@өΨӦ]CMZziHܤݩʡCCݩʱNܬ@ȡCpGzܥݩ, zͦ@ӲέpɭԩҦݩʱNQϥΡCåB@ӷsݩʳQsWtm',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'ܱNΦbxb',
        'maximal period' => '̤jP',
        'minimal scale' => '̤pث',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwqxbCziHܪ@Ӧ]qLsCpGASܡAҦݩʱNQϥηzͦ@ӲέpɭԡCåB@ӷsݩʳQsWtm',

        # Template: AgentStatsImport
        'Import' => 'ɤJ',
        'File is not a Stats config' => '󤣬O@Ӳέptm',
        'No File selected' => 'SQ襤',

        # Template: AgentStatsOverview
        'Results' => 'G',
        'Total hits' => 'I',
        'Page' => '',

        # Template: AgentStatsPrint
        'Print' => 'L',
        'No Element selected.' => 'SQ襤',

        # Template: AgentStatsView
        'Export Config' => 'ɥXtm',
        'Information about the Stat' => 'έpH',
        'Exchange Axis' => 'ഫb',
        'Configurable params of static stat' => 'RAέptmѼ',
        'No element selected.' => 'SQѼ',
        'maximal period from' => '̤jP',
        'to' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'qLJMܦrqAziHzݨDӰtmέpCziHקs診ǲέpnѱzέpƺ޲zӳ]mC',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'l󥲶H!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'HHOla}(ҦpGcustomer@example.com)',
        'Bounce ticket' => '^h Ticket ',
        'Ticket locked!' => 'Ticket Qw!',
        'Ticket unlock!' => ' Ticket!',
        'Bounce to' => '^h ',
        'Next ticket state' => 'Tickets A',
        'Inform sender' => 'qoe',
        'Send mail!' => 'oe!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'zݭnOɶ',
        'Ticket Bulk Action' => 'Ticket qBz',
        'Spell Check' => 'gˬd',
        'Note type' => '`',
        'Next state' => 'Ticket A',
        'Pending date' => 'ݳBz',
        'Merge to' => 'Xè',
        'Merge to oldest' => 'Xè̦Ѫ',
        'Link together' => 'Xæb@_',
        'Link to Parent' => 'XèW@',
        'Unlock Tickets' => ' Tickets',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Ticket O!',
        'A required field is:' => 'rqO',
        'Close ticket' => ' Ticket',
        'Previous Owner' => 'e@өҦ',
        'Inform Agent' => 'q޳NH',
        'Optional' => 'ﶵ',
        'Inform involved Agents' => 'q޳NH',
        'Attach' => '',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'gLgˬd!',
        'Compose answer for ticket' => 'g_,Ticket s',
        'Pending Date' => 'iJݪA',
        'for pending* states' => 'wﵥݪA',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'ק Tickets ݫȤ',
        'Set customer user and customer id of a ticket' => ']m Ticket ݫȤΤ',
        'Customer User' => 'ȤΤ',
        'Search Customer' => 'jȤ',
        'Customer Data' => 'Ȥƾ',
        'Customer history' => 'Ȥvp',
        'All customer tickets.' => 'ӫȤҦ Tickets O.',

        # Template: AgentTicketEmail
        'Compose Email' => 'g Email',
        'new ticket' => 's Ticket',
        'Refresh' => 's',
        'Clear To' => 'M',
        'All Agents' => 'Ҧ޳NH',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => '峹',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'ק Ticket B~H',

        # Template: AgentTicketHistory
        'History of' => 'v',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'zݭnϥΤ@ Ticket s!',
        'Ticket Merge' => 'Ticket X',

        # Template: AgentTicketMove
        'If you want to account time, please provide Subject and Text!' => '',
        'Move Ticket' => ' Ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'W[`Ѩ Ticket',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'iɶ',
        'Service Time' => 'AȮɶ',
        'Update Time' => 'sɶ',
        'Solution Time' => 'ѨMɶ',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'zܤֻݭnܤ@ Ticket!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Lo',
        'Change search options' => 'קjﶵ',
        'Tickets' => '',
        'of' => '',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'g_',
        'Contact customer' => 'ptȤ',
        'Change queue' => 'ܶC',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'ǱƧ',
        'up' => 'W',
        'sort downward' => 'fǱƧ',
        'down' => 'U',
        'Escalation in' => '',
        'Locked' => 'wA',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'ק Ticket Ҧ',

        # Template: AgentTicketPending
        'Set Pending' => ']mݳBzA',

        # Template: AgentTicketPhone
        'Phone call' => 'q',
        'Clear From' => 'm',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => '¤奻',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'TicketH',
        'Accounted time' => 'ҥήɶ',
        'Linked-Object' => 'w챵H',
        'by' => '',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'վ Ticket u',

        # Template: AgentTicketQueue
        'Tickets shown' => ' Ticket',
        'Tickets available' => 'i Ticket',
        'All tickets' => 'ҦTicket',
        'Queues' => 'C',
        'Ticket escalation!' => 'Ticket ɳBz!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => ' Ticket tdH',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Ticket j',
        'Profile' => 'j',
        'Search-Template' => 'jҪO',
        'TicketFreeText' => 'Ticket B~H',
        'Created in Queue' => 'bC̫إ',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => 'ܮɶ',
        'No change time settings.' => 'ܮɶ]m',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'jGܬ',
        'Save Search-Profile as Template?' => 'NjOsҪO',
        'Yes, save it with name' => 'O, OsW',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'i}',
        'Collapse View' => '|',
        'Split' => '',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Article Lo]m',
        'Save filter settings as default' => 'OsLo]mʬ٭',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'l',

        # Template: CustomerFooter
        'Powered by' => 'Xʤ',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'n',
        'Lost your password?' => 'ѰOKX?',
        'Request new password' => ']msKX',
        'Create Account' => 'Ыرb',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'w %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'ɶ',
        'No time settings.' => 'Lɶ.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Io̳i@ Bug!',

        # Template: Footer
        'Top of Page' => '',

        # Template: FooterSmall

        # Template: Header
        'Home' => '',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'WEB w˦V',
        'Welcome to %s' => 'wϥ %s',
        'Accept license' => 'PN\i',
        'Don\'t accept license' => 'PN',
        'Admin-User' => '޲z',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'pGzƾڮw]m root KX, Цbo̿J, _h, ЫOdť. XwҼ{, ڭ̫ĳz root ]m@ӱKX, hHаѦҼƾڮwU.',
        'Admin-Password' => '޲zKX',
        'Database-User' => 'ƾڮwΤW',
        'default \'hot\'' => 'q{KX \'hot\'',
        'DB connect host' => 'ƾڳsD',
        'Database' => 'ƾڮw',
        'Default Charset' => 'ʬ٦rŶ',
        'utf8' => 'UTF-8',
        'false' => '',
        'SystemID' => 'tID',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(tμѲ. Ticket sM http |ܳHoӼѲŶ}Y)',
        'System FQDN' => 'tΰW',
        '(Full qualified domain name of your system)' => '(tΰW)',
        'AdminEmail' => '޲za}',
        '(Email of the system admin)' => '(tκ޲zla})',
        'Organization' => '´',
        'Log' => '',
        'LogModule' => 'ӼҶ',
        '(Used log backend)' => 'ϥΤӦZ',
        'Logfile' => 'Ӥ',
        '(Logfile just needed for File-LogModule!)' => '(E File-LogModule ɤ~ݭn Logfile!)',
        'Webfrontend' => 'Web e',
        'Use utf-8 it your database supports it!' => 'pGzƾڮwAϥUTF-8rŽsX!',
        'Default Language' => 'ʬٻy',
        '(Used default language)' => '(ϥίʬٻy)',
        'CheckMXRecord' => 'ˬd MX O',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'qLgרˬdιLqlla}MXOCzOTRSbJCt̡AФnϥCheckMXRecord!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'FϥOTRS, zHrootJHUbRO椤(Terminal/Shell).',
        'Restart your webserver' => 'ЭsҰʱz webserver.',
        'After doing so your OTRS is up and running.' => 'ZAziHҰ OTRS tΤF.',
        'Start page' => '}l',
        'Your OTRS Team' => 'z OTRS p.',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Lv',

        # Template: Notify
        'Important' => 'n',

        # Template: PrintFooter
        'URL' => '}',

        # Template: PrintHeader
        'printed by' => 'L',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS խ',
        'Counter' => 'pƾ',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => 'sH',
        'Create Database' => 'Ыؼƾڮw',
        'DB Host' => 'ƾڮwD',
        'Ticket Number Generator' => 'Ticket sͦ',
        'Create new Phone Ticket' => 'Ыطsq Ticket',
        'Symptom' => 'g',
        'U' => 'ɧ',
        'Site' => 'I',
        'Customer history search (e. g. "ID342425").' => 'jȤv (ҦpG "ID342425").',
        'Can not delete link with %s!' => 'R %s s',
        'Close!' => '!',
        'for agent firstname' => '޳NH W',
        'No means, send agent and customer notifications on changes.' => 'ܮɤoeq޳NHΫȤ.',
        'A web calendar' => 'Web ',
        'to get the realname of the sender (if given)' => 'loeHumW (pGsb)',
        'OTRS DB Name' => 'ƾڮwW',
        'Notification (Customer)' => '',
        'Select Source (for add)' => 'ܼƾڷ(W[\ϥ)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Child-Object' => 'lH',
        'Days' => '',
        'Queue ID' => 'Cs',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'tmﶵ (Ҧp:<OTRS_CONFIG_HttpType>)',
        'System History' => 'tξv',
        'customer realname' => 'ȤumW',
        'Pending messages' => 'JݪA',
        'for agent login' => '޳NH nW',
        'Keyword' => 'r',
        'Close type' => '',
        'DB Admin User' => 'ƾڮw޲zΤW',
        'for agent user id' => '޳NH ΤW',
        'Change user <-> group settings' => 'ק Τ <->  ]m',
        'Problem' => 'D',
        'Escalation' => 'վ',
        '"}' => '',
        'Order' => '',
        'next step' => 'U@B',
        'Follow up' => 'i',
        'Customer history search' => 'Ȥvj',
        'PostMaster Mail Account' => 'lb޲z',
        'Stat#' => '',
        'Create new database' => 'Ыطsƾڮw',
        'Keywords' => 'r',
        'Ticket Escalation View' => 'վd Ticket',
        'Today' => '',
        'No * possible!' => 'iϥγqt "*" !',
        'Load' => '[',
        'PostMaster Filter' => 'l󤺮eLo',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_USERFIRSTNAME>)' => '',
        'Message for new Owner' => 'Ҧ̪',
        'to get the first 5 lines of the email' => 'l󥿤e5',
        'Sort by' => 'Ƨ',
        'OTRS DB Password' => 'OTRS ΤKX',
        'Last update' => '̦Zs',
        'Tomorrow' => '',
        'not rated' => '',
        'to get the first 20 character of the subject' => 'lDe20Ӧr',
        'Select the customeruser:service relations.' => '',
        'DB Admin Password' => 'ƾڨtκ޲zKX',
        'Drop Database' => 'Rƾڮw',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwqxbCziHܪ@Ӧ]qLsCMZAAܸӤөΨӥHWݩʡCpGzܥݩ, zͦ@ӲέpɭԩҦݩʱNQϥΡCåB@ӷsݩʳQsWtm',
        'FileManager' => '޲z',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'eȤΤH (Ҧp: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'ݳBz',
        'Comment (internal)' => '` ()',
        'Ticket owner options (e. g. <OTRS_OWNER_USERFIRSTNAME>)' => 'iΪ Ticket kݤHH (Ҧp: <OTRS_OWNER_USERFIRSTNAME>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'iΪ Ticket H (Ҧp: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(ϥ Ticket s榡)',
        'Reminder' => '',
        'OTRS DB connect host' => 'OTRS ƾڮwD',
        'All Agent variables.' => 'Ҧ޳NHܶq',
        ' (work units)' => 'u@椸',
        'Next Week' => 'UP',
        'All Customer variables like defined in config option CustomerUser.' => 'ҦȤܶqiHbtmﶵCustomerUserwq',
        'for agent lastname' => '޳NH W',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'ʧ@ШD̫H (Ҧp: <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => '',
        'Parent-Object' => 'H',
        'Of couse this feature will take some system performance it self!' => 'M, ӥ\|Τ@wtθ귽, [tΪt!',
        'Detail' => 'Ӹ`',
        'Your own Ticket' => 'zۤv Ticket',
        'TicketZoom' => 'Ticket i}',
        'Don\'t forget to add a new user to groups!' => 'nѰOW[sΤ!',
        'Open Tickets' => '} Tickets',
        'General Catalog' => '`ؿ',
        'CreateTicket' => 'Ы Ticket',
        'You have to select two or more attributes from the select field!' => 'AqҿrqܨөΨӥHWݩ',
        'System Settings' => 'ƾڮw]m ',
        'Finished' => '',
        'D' => '',
        'All messages' => 'Ҧ',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Object already linked as %s.' => 'Hws %s.',
        'A article should have a title!' => '峹D!',
        'Customer Users <-> Services' => 'Ȥb <-> AȺ޲z',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'tmﶵ (Ҧp: <OTRS_CONFIG_HttpType>)',
        'All email addresses get excluded on replaying on composing and email.' => 'ҦQgl\઺la}',
        'A web mail client' => 'WebMail Ȥ',
        'Compose Follow up' => 'gܵ_',
        'WebMail' => 'WebMail',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Ticket Ҧ̿ﶵ (Ҧp: <OTRS_OWNER_UserFirstname>)',
        'DB Type' => 'ƾڮw',
        'kill all sessions' => 'Ҧ|',
        'to get the from line of the email' => 'lӦ',
        'Solution' => 'ѨM',
        'QueueView' => 'C',
        'My Queue' => 'ڪC',
        'Select Box' => 'ܤ',
        'New messages' => 's',
        'Can not create link with %s!' => 'ର %s Ыسs',
        'Linked as' => 'ws',
        'modified' => 'ק',
        'Delete old database' => 'R¼ƾڮw',
        'A web file manager' => 'Web ޲z',
        'Have a lot of fun!' => 'Have a lot of fun!',
        'send' => 'oe',
        'QuickSearch' => 'ֳtj',
        'Send no notifications' => 'oeq',
        'Note Text' => '`',
        'POP3 Account Management' => 'POP3 b޲z',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_USERFIRSTNAME>)' => '',
        'System State Management' => 'tΪA޲z',
        'OTRS DB User' => 'OTRS ƾڮwΤW',
        'Mailbox' => 'lc',
        'PhoneView' => 'qܵ',
        'maximal period form' => '̤jP',
        'Escaladed Tickets' => '',
        'Yes means, send no agent and customer notifications on changes.' => 'ܮɤoeq޳NHΫȤ.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'zl s: "<OTRS_TICKET>" ^h "<OTRS_BOUNCE_TO>" . ptHUa}ԲӫH.',
        'Ticket Status View' => 'Ticket A',
        'Modified' => 'ק',
        'Ticket selected for bulk action!' => 'Q襤iqާ@ Tickets',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
    };
    # $$STOP$$
    return;
}

1;
