/*
 * Decompiled with CFR 0.152.
 */
package com.tiobe.jacobe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Jacobe {
    public static final int JACOBE_OK = 0;
    public static final int JACOBE_UNDEFINED_ERROR = -1;
    public static final int JACOBE_PROCESS_CREATE_FAILED = -2;
    private static final String JACOBE = "jacobe";

    public static void main(String[] stringArray) {
        new Jacobe().runJacobe(stringArray);
    }

    public int runJacobe(String[] stringArray) {
        return this.runJacobe(stringArray, System.out, System.err);
    }

    public int runJacobe(String[] stringArray, OutputStream outputStream, OutputStream outputStream2) {
        return this.execCommand(this.createCommand(stringArray), outputStream, outputStream2);
    }

    public int runJacobe(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        return this.execCommand(this.createCommand(stringArray), inputStream, outputStream, outputStream2);
    }

    protected String[] createCommand(String[] stringArray) {
        if (this.exeProvided(stringArray)) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = JACOBE;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }

    protected int execCommand(String[] stringArray, OutputStream outputStream, OutputStream outputStream2) {
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            Thread thread = this.createThread(process.getErrorStream(), outputStream2, false);
            Thread thread2 = this.createThread(process.getInputStream(), outputStream, false);
            thread.start();
            thread2.start();
            thread2.join();
            thread.join();
            process.waitFor();
        }
        catch (IOException iOException) {
            n = -2;
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            if (n == 0) {
                n = -1;
            }
            exception.printStackTrace();
        }
        return n;
    }

    protected int execCommand(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            Thread thread = this.createThread(inputStream, new BufferedOutputStream(process.getOutputStream()), true);
            Thread thread2 = this.createThread(process.getErrorStream(), outputStream2, false);
            Thread thread3 = this.createThread(process.getInputStream(), outputStream, false);
            thread2.start();
            thread.start();
            thread3.start();
            thread2.join();
            thread.join();
            thread3.join();
            process.waitFor();
        }
        catch (IOException iOException) {
            n = -2;
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            if (n == 0) {
                n = -1;
            }
            exception.printStackTrace();
        }
        return n;
    }

    protected Thread createThread(final InputStream inputStream, final OutputStream outputStream, final boolean bl) {
        return new Thread(){

            public void run() {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    int n = bufferedInputStream.read();
                    while (n != -1) {
                        outputStream.write(n);
                        n = bufferedInputStream.read();
                    }
                    if (bl) {
                        outputStream.close();
                    } else {
                        outputStream.flush();
                    }
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    protected boolean exeProvided(String[] stringArray) {
        if (0 < stringArray.length) {
            String string = new File(stringArray[0]).getName();
            return string.equals(JACOBE) || string.equalsIgnoreCase("jacobe.exe");
        }
        return false;
    }
}

