/* # skkinput (Simple Kana-Kanji Input)
 * skkkey.h --- define key tables.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SKKKEY_H
#define SKKKEY_H

/*
 * ǽΰʬ긺äꤹ뤫⤷ޤ
 * ä skk Ƥޤ
 */
enum {
  FUNCNO_SELF_INSERT_CHARACTER = 0,
  FUNCNO_J_SELF_INSERT,
  FUNCNO_J_SELF_ZENKAKU_INSERT, 
  FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT,
  FUNCNO_J_SET_HENKAN_POINT,
  FUNCNO_J_SET_HENKAN_POINT_SUBR,
  FUNCNO_J_INSERT_A,
  FUNCNO_J_INSERT_E,
  FUNCNO_J_INSERT_I,
  FUNCNO_J_INSERT_O,
  FUNCNO_J_INSERT_U,
  FUNCNO_J_KANA_INPUT,
  FUNCNO_J_START_HENKAN,
  FUNCNO_J_INSERT_COMMA,
  FUNCNO_J_INSERT_PERIOD,
  FUNCNO_J_PURGE_FROM_JISYO,
  FUNCNO_J_INPUT_BY_CODE_OR_MENU,
  FUNCNO_J_MODE_OFF,
  FUNCNO_J_TOGGLE_KANA,
  FUNCNO_J_PREVIOUS_CANDIDATE,
  FUNCNO_J_KAKUTEI,
  FUNCNO_J_ABBREV_INPUT,
  FUNCNO_J_ABBREV_PERIOD,
  FUNCNO_J_ABBREV_COMMA,
  FUNCNO_J_ZENKAKU_EIJI,
  FUNCNO_J_ZENKAKU_HENKAN,
  FUNCNO_J_TODAY,
  FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO,

  FUNCNO_J_KANAINPUT_MODE_ON,
  FUNCNO_J_NEWLINE,
  FUNCNO_J_SET_MARK_COMMAND,
  FUNCNO_J_FORWARD_CHAR,
  FUNCNO_J_BACKWARD_CHAR,
  FUNCNO_J_DELETE_CHAR,
  FUNCNO_J_DELETE_BACKWARD_CHAR,
  FUNCNO_J_TRY_COMPLETION,
  FUNCNO_J_END_OF_LINE,
  FUNCNO_J_BEGINNING_OF_LINE,
  FUNCNO_J_KILL_LINE,
  FUNCNO_J_YANK,
  FUNCNO_J_KILL_REGION,
  FUNCNO_J_KILL_RING_SAVE,
  FUNCNO_J_EXCHANGE_POINT_AND_MARK,
  FUNCNO_J_PREVIOUS_LINE,
  FUNCNO_J_NEXT_LINE,
  FUNCNO_J_TRANSPOSE_CHARS,
  FUNCNO_J_REDRAW,
  FUNCNO_J_PREFIX_CHAR,
  FUNCNO_J_SENDBACK_KEY,
  FUNCNO_J_KEYBOARD_QUIT,
  FUNCNO_CLOSE_SKKINPUT,
  FUNCNO_VC_TOGGLE_CHATMODE,
  FUNCNO_NOT_MODIFIED,
  FUNCNO_J_FORWARD_WORD,
  FUNCNO_J_BACKWARD_WORD,
  FUNCNO_J_UPCASE_WORD,
  FUNCNO_J_DOWNCASE_WORD,
  FUNCNO_J_CAPITALIZE_WORD,
  FUNCNO_VC_TOGGLE_EGGNL,
  FUNCNO_INVALID_CHAR,
} ;


/*
 * ʸϤλ(ʸǽ)бɽΥɽ빽¤Ρ
 */
struct skkinputTwoKeys {
  unsigned char *chara ;
  int  function_no ;
} ;

#ifdef skkconfig_c
/*
 * ̾β̾ϻΥޥåס
 *----
 * ȥʬϡȾϤλȶ̤Ȥ롣
 */
static int skkinput_skkmap[ 0x80 ] = {
  FUNCNO_J_SET_MARK_COMMAND,	/* C-@ */
  FUNCNO_J_BEGINNING_OF_LINE,	/* C-a */
  FUNCNO_J_BACKWARD_CHAR,	/* C-b */
  FUNCNO_J_PREFIX_CHAR,		/* C-c */
  FUNCNO_J_DELETE_CHAR,		/* C-d */
  FUNCNO_J_END_OF_LINE,		/* C-e */
  FUNCNO_J_FORWARD_CHAR,	/* C-f */
  FUNCNO_J_KEYBOARD_QUIT,	/* C-g */
  FUNCNO_J_DELETE_BACKWARD_CHAR, /* C-h */
  FUNCNO_J_TRY_COMPLETION,	/* C-i */
  FUNCNO_J_KANAINPUT_MODE_ON,	 /* C-j */
  FUNCNO_J_KILL_LINE,		/* C-k */
  FUNCNO_J_REDRAW,		/* C-l */
  FUNCNO_J_NEWLINE,		/* C-m */
  FUNCNO_J_NEXT_LINE,		/* C-n */
  FUNCNO_INVALID_CHAR,		/* C-o */
  FUNCNO_J_PREVIOUS_LINE,	/* C-p */
  FUNCNO_J_SENDBACK_KEY,	/* C-q */
  FUNCNO_INVALID_CHAR,		/* C-r */
  FUNCNO_INVALID_CHAR,		/* C-s */
  FUNCNO_J_TRANSPOSE_CHARS,	/* C-t */
  FUNCNO_INVALID_CHAR,		/* C-u */
  FUNCNO_INVALID_CHAR,		/* C-v */
  FUNCNO_J_KILL_REGION,		/* C-w */
  FUNCNO_J_PREFIX_CHAR,		/* C-x */
  FUNCNO_J_YANK,		/* C-y */
  FUNCNO_INVALID_CHAR,		/* C-z */
  FUNCNO_J_PREFIX_CHAR,		/* C-"[" */
  FUNCNO_INVALID_CHAR,		/* C-"\\" */
  FUNCNO_INVALID_CHAR,		/* C-"]" */
  FUNCNO_INVALID_CHAR,		/* C-"^" */
  FUNCNO_INVALID_CHAR,		/* C-"_" */
  FUNCNO_J_START_HENKAN,	/*   */
  FUNCNO_J_SELF_INSERT,		/* ! */
  FUNCNO_J_SELF_INSERT,		/* Double Quote */
  FUNCNO_J_SELF_INSERT,		/* # */
  FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT, /* $ */
  FUNCNO_J_SELF_INSERT,		/* % */
  FUNCNO_J_SELF_INSERT,		/* & */
  FUNCNO_J_SELF_INSERT,		/* ' */
  FUNCNO_J_SELF_INSERT,		/* ( */
  FUNCNO_J_SELF_INSERT,		/* ) */
  FUNCNO_J_SELF_INSERT,		/* * */
  FUNCNO_J_SELF_INSERT,		/* + */
  FUNCNO_J_INSERT_COMMA,	/* , */
  FUNCNO_J_SELF_INSERT,		/* - */
  FUNCNO_J_INSERT_PERIOD,	/* . */
  FUNCNO_J_ABBREV_INPUT,	/* / */
  FUNCNO_J_SELF_INSERT,		/* 0 */
  FUNCNO_J_SELF_INSERT,		/* 1 */
  FUNCNO_J_SELF_INSERT,		/* 2 */
  FUNCNO_J_SELF_INSERT,		/* 3 */
  FUNCNO_J_SELF_INSERT,		/* 4 */
  FUNCNO_J_SELF_INSERT,		/* 5 */
  FUNCNO_J_SELF_INSERT,		/* 6 */
  FUNCNO_J_SELF_INSERT,		/* 7 */
  FUNCNO_J_SELF_INSERT,		/* 8 */
  FUNCNO_J_SELF_INSERT,		/* 9 */
  FUNCNO_J_SELF_INSERT,		/* : */
  FUNCNO_J_SELF_INSERT,		/* ; */
  FUNCNO_J_SET_HENKAN_POINT,	/* < */
  FUNCNO_J_SELF_INSERT,		/* = */
  FUNCNO_J_SET_HENKAN_POINT,	/* > */
  FUNCNO_J_SET_HENKAN_POINT,	/* ? */
  FUNCNO_J_TODAY,		/* @ */
  FUNCNO_J_SET_HENKAN_POINT, 	/* A */
  FUNCNO_J_SET_HENKAN_POINT, 	/* B */
  FUNCNO_J_SET_HENKAN_POINT, 	/* C */
  FUNCNO_J_SET_HENKAN_POINT, 	/* D */
  FUNCNO_J_SET_HENKAN_POINT, 	/* E */
  FUNCNO_J_SET_HENKAN_POINT, 	/* F */
  FUNCNO_J_SET_HENKAN_POINT, 	/* G */
  FUNCNO_J_SET_HENKAN_POINT, 	/* H */
  FUNCNO_J_SET_HENKAN_POINT, 	/* I */
  FUNCNO_J_SET_HENKAN_POINT, 	/* J */
  FUNCNO_J_SET_HENKAN_POINT, 	/* K */
  FUNCNO_J_ZENKAKU_EIJI, 	/* L */
  FUNCNO_J_SET_HENKAN_POINT, 	/* M */
  FUNCNO_J_SET_HENKAN_POINT, 	/* N */
  FUNCNO_J_SET_HENKAN_POINT, 	/* O */
  FUNCNO_J_SET_HENKAN_POINT, 	/* P */
  FUNCNO_J_SET_HENKAN_POINT_SUBR, 	/* Q */
  FUNCNO_J_SET_HENKAN_POINT, 	/* R */
  FUNCNO_J_SET_HENKAN_POINT, 	/* S */
  FUNCNO_J_SET_HENKAN_POINT, 	/* T */
  FUNCNO_J_SET_HENKAN_POINT, 	/* U */
  FUNCNO_J_SET_HENKAN_POINT, 	/* V */
  FUNCNO_J_SET_HENKAN_POINT, 	/* W */
  FUNCNO_J_PURGE_FROM_JISYO, 	/* X */
  FUNCNO_J_SET_HENKAN_POINT, 	/* Y */
  FUNCNO_J_SET_HENKAN_POINT, 	/* Z */
  FUNCNO_J_SELF_INSERT,		/* [ */
  FUNCNO_J_INPUT_BY_CODE_OR_MENU,/* \\ */
  FUNCNO_J_SELF_INSERT,		/* ] */
  FUNCNO_J_SELF_INSERT,		/* ^ */
  FUNCNO_J_SELF_INSERT,		/* _ */
  FUNCNO_J_SELF_INSERT,		/* ` */
  FUNCNO_J_INSERT_A,		/* a */
  FUNCNO_J_KANA_INPUT,		/* b */
  FUNCNO_J_KANA_INPUT,		/* c */
  FUNCNO_J_KANA_INPUT,		/* d */
  FUNCNO_J_INSERT_E,		/* e */
  FUNCNO_J_KANA_INPUT,		/* f */
  FUNCNO_J_KANA_INPUT,		/* g */
  FUNCNO_J_KANA_INPUT,		/* h */
  FUNCNO_J_INSERT_I,		/* i */
  FUNCNO_J_KANA_INPUT,		/* j */
  FUNCNO_J_KANA_INPUT,		/* k */
  FUNCNO_J_MODE_OFF,		/* l */
  FUNCNO_J_KANA_INPUT,		/* m */
  FUNCNO_J_KANA_INPUT,		/* n */
  FUNCNO_J_INSERT_O,		/* o */
  FUNCNO_J_KANA_INPUT,		/* p */
  FUNCNO_J_TOGGLE_KANA,		/* q */
  FUNCNO_J_KANA_INPUT,		/* r */
  FUNCNO_J_KANA_INPUT,		/* s */
  FUNCNO_J_KANA_INPUT,		/* t */
  FUNCNO_J_INSERT_U,		/* u */
  FUNCNO_J_KANA_INPUT,		/* v */
  FUNCNO_J_KANA_INPUT,		/* w */
  FUNCNO_J_PREVIOUS_CANDIDATE,	/* x */
  FUNCNO_J_KANA_INPUT,		/* y */
  FUNCNO_J_KANA_INPUT,		/* z */
  FUNCNO_J_SELF_INSERT,		/* \{ */
  FUNCNO_J_SELF_INSERT,		/* \| */
  FUNCNO_J_SELF_INSERT,		/* \} */
  FUNCNO_J_SELF_INSERT,		/* ~ */
  FUNCNO_J_DELETE_CHAR,		/* 0x7f */
} ;


/*
 * abbrev mode λΥޥåס
 *----
 * ϴΩȥʬ⤳ΤѤ뤳ȡ
 */
static int skkinput_skkabbrevmap[ 0x80 ] = {
  FUNCNO_INVALID_CHAR,		/* C-@ */
  FUNCNO_J_BEGINNING_OF_LINE,	/* C-a */
  FUNCNO_J_BACKWARD_CHAR,	/* C-b */
  FUNCNO_J_PREFIX_CHAR,		/* C-c */
  FUNCNO_J_DELETE_CHAR,		/* C-d */
  FUNCNO_J_END_OF_LINE,		/* C-e */
  FUNCNO_J_FORWARD_CHAR,	/* C-f */
  FUNCNO_J_KEYBOARD_QUIT,	/* C-g */
  FUNCNO_J_DELETE_BACKWARD_CHAR, /* C-h */
  FUNCNO_J_TRY_COMPLETION,	/* C-i */
  FUNCNO_J_KANAINPUT_MODE_ON,	 /* C-j */
  FUNCNO_J_KILL_LINE,		/* C-k */
  FUNCNO_INVALID_CHAR,		/* C-l */
  FUNCNO_J_NEWLINE,		/* C-m */
  FUNCNO_J_NEXT_LINE,		/* C-n */
  FUNCNO_INVALID_CHAR,		/* C-o */
  FUNCNO_J_PREVIOUS_LINE,	/* C-p */
  FUNCNO_J_ZENKAKU_HENKAN,	/* C-q */
  FUNCNO_INVALID_CHAR,		/* C-r */
  FUNCNO_INVALID_CHAR,		/* C-s */
  FUNCNO_J_TRANSPOSE_CHARS,	/* C-t */
  FUNCNO_INVALID_CHAR,		/* C-u */
  FUNCNO_INVALID_CHAR,		/* C-v */
  FUNCNO_INVALID_CHAR,		/* C-w */
  FUNCNO_J_PREFIX_CHAR,		/* C-x */
  FUNCNO_J_YANK,		/* C-y */
  FUNCNO_INVALID_CHAR,		/* C-z */
  FUNCNO_INVALID_CHAR,		/* ? */
  FUNCNO_INVALID_CHAR,		/* ? */
  FUNCNO_INVALID_CHAR,		/* ? */
  FUNCNO_INVALID_CHAR,		/* ? */
  FUNCNO_INVALID_CHAR,		/* ? */
  FUNCNO_J_START_HENKAN,	/*   */
  FUNCNO_SELF_INSERT_CHARACTER, /* ! */
  FUNCNO_SELF_INSERT_CHARACTER, /* Double Quote */
  FUNCNO_SELF_INSERT_CHARACTER, /* # */
  FUNCNO_SELF_INSERT_CHARACTER, /* $ */
  FUNCNO_SELF_INSERT_CHARACTER, /* % */
  FUNCNO_SELF_INSERT_CHARACTER, /* & */
  FUNCNO_SELF_INSERT_CHARACTER, /* ' */
  FUNCNO_SELF_INSERT_CHARACTER, /* \( */
  FUNCNO_SELF_INSERT_CHARACTER, /* \) */
  FUNCNO_SELF_INSERT_CHARACTER, /* * */
  FUNCNO_SELF_INSERT_CHARACTER, /* + */
  FUNCNO_J_ABBREV_COMMA,	/* , */
  FUNCNO_SELF_INSERT_CHARACTER, /* - */
  FUNCNO_J_ABBREV_PERIOD,	/* . */
  FUNCNO_SELF_INSERT_CHARACTER, /* / */
  FUNCNO_SELF_INSERT_CHARACTER, /* 0 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 1 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 2 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 3 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 4 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 5 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 6 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 7 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 8 */
  FUNCNO_SELF_INSERT_CHARACTER, /* 9 */
  FUNCNO_SELF_INSERT_CHARACTER, /* : */
  FUNCNO_SELF_INSERT_CHARACTER, /* ; */
  FUNCNO_SELF_INSERT_CHARACTER, /* < */
  FUNCNO_SELF_INSERT_CHARACTER, /* = */
  FUNCNO_SELF_INSERT_CHARACTER, /* > */
  FUNCNO_SELF_INSERT_CHARACTER, /* ? */
  FUNCNO_SELF_INSERT_CHARACTER, /* @ */
  FUNCNO_SELF_INSERT_CHARACTER, /* A */
  FUNCNO_SELF_INSERT_CHARACTER, /* B */
  FUNCNO_SELF_INSERT_CHARACTER, /* C */
  FUNCNO_SELF_INSERT_CHARACTER, /* D */
  FUNCNO_SELF_INSERT_CHARACTER, /* E */
  FUNCNO_SELF_INSERT_CHARACTER, /* F */
  FUNCNO_SELF_INSERT_CHARACTER, /* G */
  FUNCNO_SELF_INSERT_CHARACTER, /* H */
  FUNCNO_SELF_INSERT_CHARACTER, /* I */
  FUNCNO_SELF_INSERT_CHARACTER, /* J */
  FUNCNO_SELF_INSERT_CHARACTER, /* K */
  FUNCNO_SELF_INSERT_CHARACTER, /* L */
  FUNCNO_SELF_INSERT_CHARACTER, /* M */
  FUNCNO_SELF_INSERT_CHARACTER, /* N */
  FUNCNO_SELF_INSERT_CHARACTER, /* O */
  FUNCNO_SELF_INSERT_CHARACTER, /* P */
  FUNCNO_SELF_INSERT_CHARACTER, /* Q */
  FUNCNO_SELF_INSERT_CHARACTER, /* R */
  FUNCNO_SELF_INSERT_CHARACTER, /* S */
  FUNCNO_SELF_INSERT_CHARACTER, /* T */
  FUNCNO_SELF_INSERT_CHARACTER, /* U */
  FUNCNO_SELF_INSERT_CHARACTER, /* V */
  FUNCNO_SELF_INSERT_CHARACTER, /* W */
  FUNCNO_SELF_INSERT_CHARACTER, /* X */
  FUNCNO_SELF_INSERT_CHARACTER, /* Y */
  FUNCNO_SELF_INSERT_CHARACTER, /* Z */
  FUNCNO_SELF_INSERT_CHARACTER, /* [ */
  FUNCNO_SELF_INSERT_CHARACTER, /* \\ */
  FUNCNO_SELF_INSERT_CHARACTER, /* ] */
  FUNCNO_SELF_INSERT_CHARACTER, /* ^ */
  FUNCNO_SELF_INSERT_CHARACTER, /* _ */
  FUNCNO_SELF_INSERT_CHARACTER, /* ` */
  FUNCNO_SELF_INSERT_CHARACTER, /* a */
  FUNCNO_SELF_INSERT_CHARACTER, /* b */
  FUNCNO_SELF_INSERT_CHARACTER, /* c */
  FUNCNO_SELF_INSERT_CHARACTER, /* d */
  FUNCNO_SELF_INSERT_CHARACTER, /* e */
  FUNCNO_SELF_INSERT_CHARACTER, /* f */
  FUNCNO_SELF_INSERT_CHARACTER, /* g */
  FUNCNO_SELF_INSERT_CHARACTER, /* h */
  FUNCNO_SELF_INSERT_CHARACTER, /* i */
  FUNCNO_SELF_INSERT_CHARACTER, /* j */
  FUNCNO_SELF_INSERT_CHARACTER, /* k */
  FUNCNO_SELF_INSERT_CHARACTER, /* l */
  FUNCNO_SELF_INSERT_CHARACTER, /* m */
  FUNCNO_SELF_INSERT_CHARACTER, /* n */
  FUNCNO_SELF_INSERT_CHARACTER, /* o */
  FUNCNO_SELF_INSERT_CHARACTER, /* p */
  FUNCNO_SELF_INSERT_CHARACTER, /* q */
  FUNCNO_SELF_INSERT_CHARACTER, /* r */
  FUNCNO_SELF_INSERT_CHARACTER, /* s */
  FUNCNO_SELF_INSERT_CHARACTER, /* t */
  FUNCNO_SELF_INSERT_CHARACTER, /* u */
  FUNCNO_SELF_INSERT_CHARACTER, /* v */
  FUNCNO_SELF_INSERT_CHARACTER, /* w */
  FUNCNO_SELF_INSERT_CHARACTER, /* x */
  FUNCNO_SELF_INSERT_CHARACTER, /* y */
  FUNCNO_SELF_INSERT_CHARACTER, /* z */
  FUNCNO_SELF_INSERT_CHARACTER, /* { */
  FUNCNO_SELF_INSERT_CHARACTER, /* | */
  FUNCNO_SELF_INSERT_CHARACTER, /* } */
  FUNCNO_SELF_INSERT_CHARACTER, /* ~ */
  FUNCNO_J_DELETE_CHAR,		/* 0x7f */
} ;

/*
 * ʣʸäƸäƤʸޤǤɡĤΥޥåס
 *----
 * 夫齤̤褦ˤɡĺܤߤ
 * Ǥ⡢󤸤ʤʤľˤǤ̤褦ˤϤʤäƤ롣
 * ϥȵǽΥڥˤƤ뤫顣
 *----
 * ϶̡
 * 虜虜 abbrev-mode ȶ̤̣򴶤ʤΤǡѥ
 */
static struct skkinputTwoKeys skkinput_twokeymap[] = {
  { "\030\003",	FUNCNO_CLOSE_SKKINPUT },		/* C-xC-c */
  { "\030\023",	FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO },	/* C-xC-s */
  { "\030\030", FUNCNO_J_EXCHANGE_POINT_AND_MARK },	/* C-xC-x */
  { "\030\021", FUNCNO_VC_TOGGLE_CHATMODE },		/* C-xC-q */
  { "\030\005", FUNCNO_VC_TOGGLE_EGGNL },		/* C-xC-e */
  { "\033w",	FUNCNO_J_KILL_RING_SAVE },		/* M-w */
  { "\033 ",	FUNCNO_J_SET_MARK_COMMAND },		/* M-  */
  { "\033~",	FUNCNO_NOT_MODIFIED },			/* M-~ */
  { "\033f",	FUNCNO_J_FORWARD_WORD },		/* M-f */
  { "\033b",	FUNCNO_J_BACKWARD_WORD },		/* M-b */
  { "\033c",	FUNCNO_J_CAPITALIZE_WORD },		/* M-c */
  { "\033u",	FUNCNO_J_UPCASE_WORD },			/* M-u */
  { "\033l",	FUNCNO_J_DOWNCASE_WORD },		/* M-l */
  { NULL,	FUNCNO_INVALID_CHAR },
} ;

#endif

#endif
