#include "MainFrm.h"
//#include "StatusFrm.h"
//#include "RemoteMntFrm.h"
//#include "InfoFrm.h"
//#include "cipherfrm.h"
//#include "UninstallFrm.h"

//#include <swwinlog.h>
//#include <shellapi.h>
#include <dirent.h>
#include <fcntl.h>
//#include <io.h>
#include <sys/stat.h>
//#include <dir.h>

TMainForm *MainForm;

#include "pix/null.xpm"
#include "pix/arrow2r.xpm"
#include "pix/bookshut.xpm"
#include "pix/bulbon.xpm"
#include "pix/fingerup.xpm"
#include "pix/bulblk.xpm"
#include "pix/upgrdlk.xpm"
#include "pix/sword.xpm"
#include "pix/globe.xpm"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>

#include <gtk/gtk.h>

extern "C" {
#include "callbacks.h"
//#include "interface.h"
//#include "support.h"
}
#ifndef O_BINARY
#define O_BINARY 0
#endif

	
VersionInfo::VersionInfo(const char *version) {
	char *buf = new char[ strlen(version) + 1 ];
	char *tok;
	major = minor = minor2 = minor3 = 0;
		
	strcpy(buf, version);
	tok = strtok(buf, ".");
	if (tok)
		major = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor2 = atoi(tok);
	tok = strtok(0, ".");
	if (tok)
		minor3 = atoi(tok);
	delete [] buf;
}


int VersionInfo::compare(const VersionInfo &vi) const {
	if (major == vi.major)
		if (minor == vi.minor)
			if (minor2 == vi.minor2)
				if (minor3 == vi.minor3)
					return 0;
				else return minor3 - vi.minor3;
			else	return minor2 - vi.minor2;
		else	return minor - vi.minor;
	else	return major - vi.major;
}


InstallSourceTab::InstallSourceTab(GtkWidget *Owner, const char *confEnt, const char *type) {
	char *buf = new char [ strlen(confEnt) + 1 ];
	
	strcpy(buf, confEnt);

	Caption = strtok(buf, "|");
	Source = strtok(0, "|");
	Directory = strtok(0, "|");
	delete [] buf;
	Type = type;
	mgr = 0;
}

InstallSourceTab::~InstallSourceTab() {
	if (mgr)
		delete mgr;
}
	
TMainForm::TMainForm(GtkWidget* Owner) {
	manager = new SWMgr();
	installConf = new SWConfig("./InstallMgr.conf");
	localMgr = 0;
	FormCreate(0);
}


TMainForm::~TMainForm()
{
	delete manager;
	delete installConf;
	if (localMgr)
		delete localMgr;
}


void TMainForm::FormCreate(GtkWidget *Sender) {

  accel_group = gtk_accel_group_new ();
  main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_window", main_window);
  gtk_window_set_default_size (GTK_WINDOW (main_window), 600, 450);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (main_window), vbox1);

  GtkWidget *handlebox3 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "handlebox3", handlebox3);
  gtk_widget_show (handlebox3);
  gtk_box_pack_start (GTK_BOX (vbox1), handlebox3, FALSE, FALSE, 0);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_ref (menubar1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "menubar1", menubar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar1);
  gtk_menu_bar_set_shadow_type (GTK_MENU_BAR (menubar1), GTK_SHADOW_NONE);
  gtk_container_add (GTK_CONTAINER (handlebox3), menubar1);

  file2 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (file2)->child),
                                   "_File");
  gtk_widget_add_accelerator (file2, "activate_item", accel_group,
                              tmp_key, GDK_MOD1_MASK, (enum GtkAccelFlags)0);
  gtk_widget_ref (file2);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "file2", file2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (file2);
  gtk_container_add (GTK_CONTAINER (menubar1), file2);

  file2_menu = gtk_menu_new ();
  gtk_widget_ref (file2_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "file2_menu", file2_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file2), file2_menu);
  file2_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (file2_menu));

  exit1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (exit1)->child),
                                   _("E_xit"));
  gtk_widget_add_accelerator (exit1, "activate_item", file2_menu_accels,
                              tmp_key, 0, (enum GtkAccelFlags)0);
  gtk_widget_ref (exit1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "exit1", exit1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (exit1);
  gtk_container_add (GTK_CONTAINER (file2_menu), exit1);


  options1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (options1)->child),
                                   _("_Options"));
  gtk_widget_add_accelerator (options1, "activate_item", accel_group,
                              tmp_key, GDK_MOD1_MASK, (enum GtkAccelFlags)0);
  gtk_widget_ref (options1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "options1", options1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (options1);
  gtk_container_add (GTK_CONTAINER (menubar1), options1);

  options1_menu = gtk_menu_new ();
  gtk_widget_ref (options1_menu);

  gtk_object_set_data_full (GTK_OBJECT (main_window), "options1_menu", options1_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (options1), options1_menu);
  options1_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (options1_menu));

  local_path1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (local_path1)->child),
                                   _("_Local Path..."));
  gtk_widget_add_accelerator (local_path1, "activate_item", options1_menu_accels,
                              tmp_key, 0, (enum GtkAccelFlags)0);
  gtk_widget_ref (local_path1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "local_path1", local_path1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (local_path1);
  gtk_container_add (GTK_CONTAINER (options1_menu), local_path1);

  manage_remote_sources1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (manage_remote_sources1)->child),
                                   _("_Manage Remote Sources..."));
  gtk_widget_add_accelerator (manage_remote_sources1, "activate_item", options1_menu_accels,
                              tmp_key, 0, (enum GtkAccelFlags)0);
  gtk_widget_ref (manage_remote_sources1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "manage_remote_sources1", manage_remote_sources1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (manage_remote_sources1);
  gtk_container_add (GTK_CONTAINER (options1_menu), manage_remote_sources1);

  banner_panel = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (banner_panel);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "banner_panel", banner_panel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (banner_panel);
  gtk_box_pack_start (GTK_BOX (vbox1), banner_panel, FALSE, FALSE, 0);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_ref (hpaned1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "hpaned1", hpaned1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpaned1);
  gtk_box_pack_start (GTK_BOX (vbox1), hpaned1, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (hpaned1), vbox2);

  toolbar2 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_ref (toolbar2);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "toolbar2", toolbar2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar2);
  gtk_box_pack_start (GTK_BOX (vbox2), toolbar2, FALSE, FALSE, 0);

  notebook1 = gtk_notebook_new ();
  gtk_widget_ref (notebook1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "notebook1", notebook1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (vbox2), notebook1, TRUE, TRUE, 0);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow3);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "scrolledwindow3", scrolledwindow3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow3);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow3);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "viewport1", viewport1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), viewport1);

	localTree = new TTreeView(viewport1);

  label1 = gtk_label_new (_("Local"));
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label1);

  toolbar3 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_widget_ref (toolbar3);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "toolbar3", toolbar3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar3);
  gtk_box_pack_start (GTK_BOX (vbox2), toolbar3, FALSE, FALSE, 0);

  InfoBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar3),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Info"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_widget_ref (InfoBtn);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "InfoBtn", InfoBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (InfoBtn);

  SelectBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar3),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Select"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_widget_ref (SelectBtn);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "SelectBtn", SelectBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SelectBtn);

  SelectAllBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar3),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Select All"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_widget_ref (SelectAllBtn);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "SelectAllBtn", SelectAllBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (SelectAllBtn);

/*
  tmp_toolbar_icon = gnome_stock_pixmap_widget (main_window, GNOME_STOCK_PIXMAP_ADD);
*/
  InstallBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar3),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Install"),
                                NULL, NULL,
                                /*tmp_toolbar_icon*/NULL, NULL, NULL);
  gtk_widget_ref (InstallBtn);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "InstallBtn", InstallBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (InstallBtn);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (hpaned1), vbox3);

  label2 = gtk_label_new (_("Installed"));
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox3), label2, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label2), 0.01, 0.5);

  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow4);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "scrolledwindow4", scrolledwindow4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow4);
  gtk_box_pack_start (GTK_BOX (vbox3), scrolledwindow4, TRUE, TRUE, 0);

  viewport2 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport2);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "viewport2", viewport2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), viewport2);

	installTree = new TTreeView(viewport2);




  toolbar4 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_widget_ref (toolbar4);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "toolbar4", toolbar4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar4);
  gtk_box_pack_start (GTK_BOX (vbox3), toolbar4, FALSE, FALSE, 0);

/*
  tmp_toolbar_icon = gnome_stock_pixmap_widget (main_window, GNOME_STOCK_PIXMAP_REMOVE);
*/
  RemoveBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Remove"),
                                NULL, NULL,
                                /*tmp_toolbar_icon*/NULL, NULL, NULL);
  gtk_widget_ref (RemoveBtn);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "RemoveBtn", RemoveBtn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (RemoveBtn);

  /*
  appbar1 = gtk_statusbar_new ();
  gtk_widget_ref (appbar1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "appbar1", appbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appbar1);
  gtk_box_pack_start (GTK_BOX (vbox1), appbar1, FALSE, FALSE, 0);
  */

  appbar1 = gtk_progress_bar_new ();
  gtk_widget_ref (appbar1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "appbar1", appbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appbar1);
  gtk_box_pack_start (GTK_BOX (vbox1), appbar1, FALSE, FALSE, 0);


  gtk_signal_connect (GTK_OBJECT (localTree->nativeControl), "button_press_event",
                      GTK_SIGNAL_FUNC (on_localTreeButtonPress),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (InfoBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_InfoBtn_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (SelectBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_SelectBtn_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (SelectAllBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_SelectAllBtn_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (InstallBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_InstallBtn_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (RemoveBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_RemoveBtn_clicked),
                      NULL);
	gtk_signal_connect(GTK_OBJECT(main_window),
					"destroy",
					GTK_SIGNAL_FUNC(gtk_main_quit),
					NULL);
  gtk_signal_connect (GTK_OBJECT (local_path1), "activate",
                      GTK_SIGNAL_FUNC (on_local_path1_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (exit1), "activate",
                      GTK_SIGNAL_FUNC (on_exit1_activate),
                      NULL);




	ImageList1 = new TCustomImageList(localTree);
	ImageList2 = new TCustomImageList(localTree);
	localTree->Images = ImageList1;
	localTree->StateImages = ImageList2;

	refreshPageControl();
	
//	if (SWLog::systemlog)
//		delete SWLog::systemlog;
//	SWLog::systemlog = new SWWinLog(this->Handle);		// set the system logger to our MSWindows specific SWLog class


}


void TMainForm::refreshPageControl()
{
	SectionMap::iterator sources;
	ConfigEntMap::iterator sourceBegin;
	ConfigEntMap::iterator sourceEnd;

/*
	while (PageControl1->PageCount > 1) {
		delete PageControl1->Pages[1];
	}
*/
	
	sources = installConf->Sections.find("Sources");

	if (sources != installConf->Sections.end()) {
		sourceBegin = sources->second.lower_bound("FTPSource");
		sourceEnd = sources->second.upper_bound("FTPSource");

		if (sourceBegin != sourceEnd) {
			while (sourceBegin != sourceEnd) {
//				addSource(new InstallSourceTab(this, sourceBegin->second.c_str(), "FTP"));
				sourceBegin++;
			}
		}
	}
}

/*

void TMainForm::addSource(InstallSourceTab *ist)
{
	TTabSheet *newtab = new TTabSheet(this);
	TTreeView *newtree = new TTreeView(this);
	TSpeedButton *newbutton = new TSpeedButton(this);
	TPanel *newpanel = new TPanel(this);
	char buf[512];
	SectionMap::iterator sit;
	
	newtab->Caption = ist->Caption.c_str();
	newtab->Hint = ist->Source.c_str();
	newtab->ShowHint = true;
	newtab->PageControl = PageControl1;
	ist->Parent = newtab;
	ist->tree = newtree;
	newpanel->Parent = newtab;
	newpanel->Align = alTop;
	newpanel->BevelOuter = bvNone;
	newpanel->BevelInner = bvNone;
	newpanel->Height = 25;
	newbutton->Parent = newpanel;
	newbutton->Caption = "Refresh from Remote Source";
	newbutton->Width = 175;
	newbutton->OnClick = RefreshRemoteSource;
	newbutton->Flat = true;
	newbutton->Glyph = SpeedButton2->Glyph;
	newtree->Parent = newtab;
	newtree->Align = alClient;
	newtree->ReadOnly = true;
	newtree->OnDblClick = localTreeDblClick;
	newtree->Images = ImageList1;
	newtree->StateImages = ImageList2;
	string parent = "./sources/" + ist->Source + "/file";
	createParent(parent.c_str());
	parent = "./sources/" + ist->Source;
	fillSourceTree(parent.c_str(), newtree);
}


*/
const char *TMainForm::getLocalDir()
{
	ConfigEntMap::iterator entry;

	entry = installConf->Sections["Sources"].find("LocalPath");
	if (entry == installConf->Sections["Sources"].end()) {
		installConf->Sections["Sources"].insert(ConfigEntMap::value_type("LocalPath", "d:/sword"));
		entry = installConf->Sections["Sources"].find("LocalPath");
	}
	return entry->second.c_str();
		
}


void TMainForm::setLocalDir(const char *idir)
{
	installConf->Sections["Sources"].erase("LocalPath"); installConf->Sections["Sources"].insert(ConfigEntMap::value_type("LocalPath", idir));
}


void file_ok_sel( GtkWidget *w, TMainForm *form ) {
	form->LocalPath1Click_ok(w);
}

void TMainForm::LocalPath1Click_ok(GtkWidget *Sender) {
	char *buf = new char [ strlen(gtk_file_selection_get_filename (GTK_FILE_SELECTION (localPathDlg))) + 1 ];
	
	strcpy(buf, gtk_file_selection_get_filename (GTK_FILE_SELECTION (localPathDlg)));
	int end = strlen(buf) - 1;
	while (end) {
		if ((buf[end] == '/') || (buf[end] == '\\'))
			break;
		end--;
	}
	buf[end+1] = 0;
	setLocalDir(buf);
	delete [] buf;
	
	installConf->Save();
	fillSourceTree(getLocalDir(), localTree);
	gtk_widget_destroy(GTK_WIDGET(localPathDlg));
}

//---------------------------------------------------------------------------
void TMainForm::LocalPath1Click(GtkWidget *Sender)
{
/*
	localPathDlg->Title = "Select a file in the directory to choose";
	localPathDlg->InitialDir = getLocalDir();
*/
		localPathDlg = gtk_file_selection_new( "Select a file in the directory to choose" );
		gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (localPathDlg)->ok_button),
		"clicked", (GtkSignalFunc) file_ok_sel, this );

		gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
		(localPathDlg)->cancel_button),
		"clicked", (GtkSignalFunc) gtk_widget_destroy,
		GTK_OBJECT (localPathDlg));

		/* Lets set the filename, as if this were a save dialog, and we are giving
		a default filename */
//		gtk_file_selection_set_filename (GTK_FILE_SELECTION(localPathDlg), 
//		"penguin.png");

		gtk_window_set_modal(GTK_WINDOW(localPathDlg), true);
		gtk_widget_show(localPathDlg);


}
//---------------------------------------------------------------------------

void TMainForm::fillInstallTree()
{
	ModMap::iterator mods;
	TTreeNode *node;
	string nodeName;
	
	installTree->Items->Clear();

	if (!manager->configPath)
		return;

	for (mods = manager->Modules.begin(); mods != manager->Modules.end(); mods++) {
		for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
			if (!strcmp(string(node->Text).c_str(), mods->second->Type())) {
				break;
			}
		}
		if (!node) {	// Add Section
			if (!strncmp(mods->second->Type(), "Bibl", 4))	// If Bibles, put first in list
				node = installTree->Items->AddChildFirst(0, mods->second->Type());
			else	node = installTree->Items->AddChild(0, mods->second->Type());
		}
		nodeName = "[";
		nodeName += mods->second->Name();
		nodeName += "] ";
		nodeName += mods->second->Description();
		node = installTree->Items->AddChildObject(node, nodeName.c_str(), mods->second->Name());
	}
	for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = installTree->Items->GetFirstNode();
//	if (node)
//		node->MakeVisible();
}


void TMainForm::fillSourceTree(const char *sourceConf, TTreeView *tree)
{
	ModMap::iterator mods;
	TTreeNode *node;
	SectionMap::iterator sections, targetSection;
	ConfigEntMap::iterator entry;
	string secName;
	const char * modDesc;
	string nodeName;
	string targetVersion;
	string sourceVersion;
	bool cipher;
	
	SWMgr *mgr;

//	if (tree == localTree) {
		if (localMgr)
			delete localMgr;
		mgr = localMgr = new SWMgr(sourceConf);
/*
	}
	else {
		InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->ActivePage->Controls[0];
		if (ist->mgr)
			delete ist->mgr;
		mgr = ist->mgr = new SWMgr(sourceConf);
	}
*/
	
	tree->Items->Clear();

	if (!mgr->configPath)
		return;

	for (sections = mgr->config->Sections.begin(); sections != mgr->config->Sections.end(); sections++) {
	
		cipher = false;
		
		if (!strcmp(sections->first.c_str(), "Globals"))	// skip [Globals]
			continue;
			
		mods = mgr->Modules.find(sections->first.c_str());
		if (mods != mgr->Modules.end())
			secName = mods->second->Type();
		else {
			secName = "Other";
		}

		string misc1 = ((entry = sections->second.find("Category")) != sections->second.end()) ? (*entry).second : (string)"";
          if (misc1.length() > 0)
             secName = misc1;

		entry = sections->second.find("Description");
		if (entry != sections->second.end())
			modDesc = entry->second.c_str();
		else modDesc = "";
		
		
		targetVersion = "0.0";
		sourceVersion = "1.0";
		
		entry = sections->second.find("CipherKey");
		if (entry != sections->second.end())
			cipher = true;
		
		entry = sections->second.find("Version");
		if (entry != sections->second.end())
			sourceVersion = entry->second.c_str();

		targetSection = manager->config->Sections.find(sections->first);
		if (targetSection != manager->config->Sections.end()) {
			targetVersion = "1.0";
			entry = targetSection->second.find("Version");
			if (entry != targetSection->second.end())
				targetVersion = entry->second;
		}

		if (VersionInfo(sourceVersion.c_str()) > VersionInfo(targetVersion.c_str())) {
			for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
				if (!strcmp(string(node->Text).c_str(), secName.c_str())) {
					break;
				}
			}

			if (!node) {	// Add Section
				if (!strncmp(secName.c_str(), "Bibl", 4))	// If Bibles, put first in list
					node = tree->Items->AddChildFirst(0, secName.c_str());
				else	node = tree->Items->AddChild(0, secName.c_str());
				node->ImageIndex = 0;
			}
			nodeName = "[" + sections->first + "] " + modDesc;
			node = tree->Items->AddChildObject(node, nodeName.c_str(), (void *) sections->first.c_str());
  gtk_signal_connect (GTK_OBJECT (node->nativeControl), "button_press_event",
                      GTK_SIGNAL_FUNC (on_localTreeButtonPress),
                      NULL);

			if (VersionInfo(targetVersion.c_str()) < VersionInfo("1.0")) {
				node->ImageIndex = 1;
//				node->SelectedIndex = 1;
			}
			else {
				node->ImageIndex = 2;
//				node->SelectedIndex = 2;
			}
			if (cipher) {
				node->ImageIndex += 2;
//				node->SelectedIndex += 2;
			}
			node->StateIndex = 0;
		}
	}
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = tree->Items->GetFirstNode();
//	if (node)
//		node->MakeVisible();
}


void TMainForm::Button5Click(GtkWidget *Sender)
{
	TTreeView *tree;
/*
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
*/
	tree = localTree;

	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (node->StateIndex == 1)
				node->StateIndex = 0;
			else	node->StateIndex = 1;
			tree->Repaint();
		}
	}
}
/*
//---------------------------------------------------------------------------

void TMainForm::localTreeDblClick(GtkWidget *Sender)
{
	Button5Click(Sender);
}
//---------------------------------------------------------------------------
*/

int TMainForm::selectAll(TTreeView *tree, bool sel)
{
	TTreeNode *node;
	TTreeNode *node2;
	int retCount = 0;
	
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
		for (node2 = node->getFirstChild(); node2; node2 = node2->getNextSibling()) {
			if (node2->StateIndex == 1) {
				if (!sel) {
					node2->StateIndex = 0; //node2->StateIndex;
					retCount++;
				}
			}
			else	{
				if (sel) {
					node2->StateIndex = 1;
					retCount++;
				}
			}
		}
	}
	return retCount;
}


void TMainForm::Button6Click(GtkWidget *Sender)	// SELECT ALL
{
	TTreeView *tree;
/*
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
*/
	tree = localTree;
	if (!selectAll(tree, true))
		selectAll(tree, false);
	tree->Repaint();
}
/*
//---------------------------------------------------------------------------

void TMainForm::Image1Click(GtkWidget *Sender)
{
	ShellExecute(this->Handle, "open", "http://www.crosswire.org", NULL, NULL, SW_SHOWNORMAL);
	
}
//---------------------------------------------------------------------------

*/

int TMainForm::removeModule(const char *modName)
{
	SectionMap::iterator module;
	ConfigEntMap::iterator fileBegin;
	ConfigEntMap::iterator fileEnd, entry;

	module = manager->config->Sections.find(modName);

	if (module != manager->config->Sections.end()) {
		entry = module->second.find("CipherKey");
		if (entry != module->second.end())
//			CipherForm->cipherEdit->Text = entry->second.c_str();
			
		fileBegin = module->second.lower_bound("File");
		fileEnd = module->second.upper_bound("File");

/*
		if (fileBegin != fileEnd) {	// remove each file
			while (fileBegin != fileEnd) {
				//remove file
				remove(fileBegin->second.c_str());
				fileBegin++;
			}
		}
		else {	//remove all files in DataPath directory
*/

			DIR *dir;
			struct dirent *ent;
			ConfigEntMap::iterator entry;
			string modDir;
			string modFile;

			entry = module->second.find("DataPath");
			if (entry != module->second.end()) {
				modDir = manager->prefixPath;
				if ((manager->prefixPath[strlen(manager->prefixPath)-1] != '\\') && (manager->prefixPath[strlen(manager->prefixPath)-1] != '/'))
					modDir += "/";

				modDir += entry->second.c_str();
				entry = module->second.find("ModDrv");
				if (entry != module->second.end()) {
					if (!strcmp(entry->second.c_str(), "RawLD")) {
						char *buf = new char [ strlen(modDir.c_str()) + 1 ];
	
						strcpy(buf, modDir.c_str());
						int end = strlen(buf) - 1;
						while (end) {
							if (buf[end] == '/')
								break;
							end--;
						}
						buf[end] = 0;
							modDir = buf;
							delete [] buf;
						}
					}

				if (dir = opendir(modDir.c_str())) {
					rewinddir(dir);
					while ((ent = readdir(dir))) {
						if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
							modFile = modDir;
							modFile += "/";
							modFile += ent->d_name;
							remove(modFile.c_str());
						}
					}
					closedir(dir);
				}
				if (dir = opendir(manager->configPath)) {	// find and remove .conf file
					rewinddir(dir);
					while ((ent = readdir(dir))) {
						if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
							modFile = manager->configPath;
							modFile += "/";
							modFile += ent->d_name;
							SWConfig *config = new SWConfig(modFile.c_str());
							if (config->Sections.find(modName) != config->Sections.end()) {
								delete config;
								remove(modFile.c_str());
							}
							else	delete config;
						}
					}
					closedir(dir);
				}
			}
//		}
		return 0;
	}
	return 1;
}


int TMainForm::createParent(const char *pName)
{
	char *buf = new char [ strlen(pName) + 1 ];
	int retCode;
	
	strcpy(buf, pName);
	int end = strlen(buf) - 1;
	while (end) {
		if (buf[end] == '/')
			break;
		end--;
	}
	buf[end] = 0;
	if (!strlen(buf))
		return -1;
		
	if ((retCode = mkdir(buf, 0755))) {
		createParent(buf);
		retCode = mkdir(buf, 0755);
	}
	delete [] buf;
	return retCode;
}
	

int TMainForm::createPathAndFile(const char *fName)
{
	int fd;
	
	fd = open(fName, O_CREAT|O_WRONLY|O_BINARY, 00644);
	if (fd < 1) {
		createParent(fName);
		fd = open(fName, O_CREAT|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE);
	}
	return fd;
}


int TMainForm::copyFileToCWD(const char *sourceDir, const char *fName)
{
	string sourcePath = sourceDir;
	sourcePath += fName;

	string dest;
	dest = manager->prefixPath;
	if ((manager->prefixPath[strlen(manager->prefixPath)-1] != '\\') && (manager->prefixPath[strlen(manager->prefixPath)-1] != '/'))
		dest += "/";
	dest +=fName;
	return copyFile(sourcePath.c_str(), dest.c_str());
}


int TMainForm::copyFile(const char *sourceFile, const char *targetFile)
{
	int sfd, dfd, len;
	char buf[4096];

	if ((sfd = open(sourceFile, O_RDONLY|O_BINARY)) < 1)
		return -1;
	if ((dfd = createPathAndFile(targetFile)) < 1)
		return -1;

	do {
		len = read(sfd, buf, 4096);
		write(dfd, buf, len);
	}
	while(len == 4096);	
	close(dfd);
	close(sfd);
	
	return 0;
}


int TMainForm::installModule(const char *modName, InstallSourceTab *ist)
{
	SectionMap::iterator module, section;
	ConfigEntMap::iterator fileBegin;
	ConfigEntMap::iterator fileEnd;
	ConfigEntMap::iterator entry;
	string sourceDir;
	string buffer;
	bool aborted = false;
	bool cipher = false;

	if (ist)
		sourceDir = "./sources/" + ist->Source;
	else	sourceDir = getLocalDir();
	
	SWMgr mgr(sourceDir.c_str());
	
	module = mgr.config->Sections.find(modName);

	if (module != mgr.config->Sections.end()) {
	
		entry = module->second.find("CipherKey");
		if (entry != module->second.end())
			cipher = true;
		
		fileEnd = module->second.upper_bound("File");
		fileBegin = module->second.lower_bound("File");

		if (fileBegin != fileEnd) {	// copy each file
			if (ist) {
				while (fileBegin != fileEnd) {	// ftp each file first
					buffer = sourceDir + "/" + fileBegin->second;
//					if (FTPCopy(ist, fileBegin->second.c_str(), buffer.c_str())) {
//						aborted = true;
//						break;	// user aborted
//					}
					fileBegin++;
				}
				fileBegin = module->second.lower_bound("File");
			}

			if (!aborted) {
				// DO THE INSTALL
				while (fileBegin != fileEnd) {
					copyFileToCWD(sourceDir.c_str(), fileBegin->second.c_str());
					fileBegin++;
				}
			}
			//---------------

			if (ist) {
				fileBegin = module->second.lower_bound("File");
				while (fileBegin != fileEnd) {	// delete each tmp ftp file
					buffer = sourceDir + "/" + fileBegin->second;
					remove(buffer.c_str());
					fileBegin++;
				}
			}
		}
		else {	//copy all files in DataPath directory
			DIR *dir;
			struct dirent *ent;
			ConfigEntMap::iterator entry;
			string modDir;
			string modFile;
			string sourceOrig = sourceDir;

			entry = module->second.find("DataPath");
			if (entry != module->second.end()) {
				modDir = entry->second.c_str();
				entry = module->second.find("ModDrv");
				if (entry != module->second.end()) {
					if (!strcmp(entry->second.c_str(), "RawLD")) {
						char *buf = new char [ strlen(modDir.c_str()) + 1 ];
	
						strcpy(buf, modDir.c_str());
						int end = strlen(buf) - 1;
						while (end) {
							if (buf[end] == '/')
								break;
							end--;
						}
						buf[end] = 0;
						modDir = buf;
						delete [] buf;
					}
				}

				if (ist) {
					buffer = sourceDir + "/" + modDir;
//					if (FTPCopy(ist, modDir.c_str(), buffer.c_str(), true)) {
//						aborted = true;	// user aborted
//					}
				}
				sourceDir += "/";
				sourceDir += modDir;
				if (!aborted) {
					if (dir = opendir(sourceDir.c_str())) {
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = modDir;
								modFile += "/";
								modFile += ent->d_name;
								copyFileToCWD(sourceOrig.c_str(), modFile.c_str());
							}
						}
						closedir(dir);
					}
				}
				if (ist) {		// delete tmp ftp files
					if (dir = opendir(sourceDir.c_str())) {
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = sourceOrig + "/" + modDir;
								modFile += "/";
								modFile += ent->d_name;
								remove(modFile.c_str());
							}
						}
						closedir(dir);
					}
				}
				sourceDir = sourceOrig;
				sourceDir += "/mods.d/";
				if (!aborted) {
					if (dir = opendir(sourceDir.c_str())) {	// find and copy .conf file
						rewinddir(dir);
						while ((ent = readdir(dir))) {
							if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
								modFile = sourceDir;
								modFile += ent->d_name;
								SWConfig *config = new SWConfig(modFile.c_str());
								if (config->Sections.find(modName) != config->Sections.end()) {
									delete config;
									string targetFile = manager->configPath; //"./mods.d/";
									targetFile += "/";
									targetFile += ent->d_name;
									copyFile(modFile.c_str(), targetFile.c_str());
									if (cipher) {
//										CipherForm->modName = modName;
//										CipherForm->confFile = targetFile;
//										CipherForm->ShowModal();
									}
								}
								else	delete config;
							}
						}
						closedir(dir);
					}
				}
			}
		}
		return (aborted) ? -1 : 0;
	}
	return 1;
}


void	TMainForm::fillAllSourceTrees()
{
	fillSourceTree(getLocalDir(), localTree);
/*
	for (int i = 1; i < PageControl1->PageCount; i++) {
		InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->Pages[i]->Controls[0];
		string parent = "./sources/" + ist->Source;
		fillSourceTree(parent.c_str(), ist->tree);
	}
*/
}


void TMainForm::Button4Click(GtkWidget *Sender)	// REMOVE MODULE
{
	TTreeNode *node = installTree->Selected;
	if (node) {
		if (node->Parent) {
			removeModule((const char *)(void *)node->Data);
			delete manager;
			manager = new SWMgr();
			fillInstallTree();
			fillAllSourceTrees();
		}
	}
}
//---------------------------------------------------------------------------

void TMainForm::Button2Click(GtkWidget *Sender)	// INSTALL
{
	TTreeNode *node;
	int count = 0;
	int abort = 0;
	//gtk temporary
	float position = 0;

/*
	class TWaitCursor {
	public:
	    TWaitCursor() : oldc(Screen->Cursor) { Screen->Cursor = crHourGlass; }
	    ~TWaitCursor()                       { Screen->Cursor = oldc; }
	private:
	    TCursor oldc;
	} wait; // show hourglass
*/

	TTreeView *tree;
/*
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
*/
	tree = localTree;

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1)
			count++;
	}	// do true progress bar

	if (!count) return;		// if nothing is selected, do nothing
		
//	progressBar->Max = count;
//	progressBar->Position = 0;
     gtk_progress_bar_update(GTK_PROGRESS_BAR(appbar1), 0);
     gtk_progress_set_show_text(GTK_PROGRESS(appbar1), 1);

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1) {	// if selected for install
//			CipherForm->cipherEdit->Text = "";
			if ((node->ImageIndex == 2) || (node->ImageIndex == 4)) {	// if this is an upgrade
				removeModule((const char *)(void *)node->Data);
			}
				// install module
//			statusBar->Caption = "Installing: " + node->Text + "...";
			string statusText = "Installing: " + string(node->Text) + "...";
			gtk_progress_set_format_string(GTK_PROGRESS(appbar1), statusText.c_str());
			
//			statusBar->Repaint();
			if (tree == localTree)
				abort = installModule((const char *)(void *)node->Data);
//			else	abort = installModule((const char *)(void *)node->Data, (InstallSourceTab *) PageControl1->ActivePage->Controls[0]);
			if (abort)
				break;
//			progressBar->Position++;
			position++;
			gtk_progress_bar_update(GTK_PROGRESS_BAR(appbar1), position/count);
			while (g_main_iteration(FALSE));	// force refresh
		}
	}
	delete manager;
	manager = new SWMgr();
	fillInstallTree();
	fillAllSourceTrees();
//	statusBar->Caption = "";
//	progressBar->Position = 0;
	gtk_progress_set_format_string(GTK_PROGRESS(appbar1), "");
	gtk_progress_bar_update(GTK_PROGRESS_BAR(appbar1), 0);
}


/*
int TMainForm::FTPCopy(InstallSourceTab *ist, const char *src, const char *dest, bool dirTransfer)
{
	StatusForm->ist = ist;
	StatusForm->src = src;
	StatusForm->dest = dest;
	StatusForm->dirTransfer = dirTransfer;
	
	Application->ProcessMessages();
	if (StatusForm->ShowModal() == mrCancel)
		return -1;
	else	return 0;
}


void TMainForm::RefreshRemoteSource(GtkWidget *Sender)
{
	InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->ActivePage->Controls[0];
	DIR *dir;
	struct dirent *ent;
	ConfigEntMap::iterator entry;
	string modDir;
	string modFile;
	string target = "./sources/";
	target += ist->Source.c_str();
	target += "/mods.d";

	if (dir = opendir(target.c_str())) {
		rewinddir(dir);
		while ((ent = readdir(dir))) {
			if ((strcmp(ent->d_name, ".")) && (strcmp(ent->d_name, ".."))) {
				modFile = target;
				modFile += "/";
				modFile += ent->d_name;
				remove(modFile.c_str());
			}
		}
		closedir(dir);
	}


	FTPCopy(ist, "mods.d", target.c_str(), true);

	target = "./sources/";
	target += ist->Source.c_str();

	fillSourceTree(target.c_str(), ist->tree);	
}



void TMainForm::SpeedButton1Click(GtkWidget *Sender)
{
	InfoForm->Caption = "W A R N I N G";
	InfoForm->info = "\\qc {\\b \\fs20 -=+* WARNING *+=- -=+* WARNING *+=-}\\par\\par\\pard ";
	InfoForm->info += "Although Install Manager provides a convenient way for installing and upgrading SWORD components, it also uses a systematic method for accessing sites which gives packet sniffers a target to lock into for singling out users. \\par\\par ";
	InfoForm->info += "\\b\\qc IF YOU LIVE IN A PERSECUTED COUNTRY AND DO NOT WISH TO RISK DETECTION, YOU SHOULD *NOT* USE INSTALL MANAGER'S REMOTE SOURCE FEATURES.";
	InfoForm->ShowModal();
	if (RemoteMntForm->ShowModal() == mrOk) {
		delete installConf;
		installConf = new SWConfig("./InstallMgr.conf");
	
		refreshPageControl();
	}
}

void TMainForm::SpeedButton5Click(GtkWidget *Sender)
{
	TTreeView *tree;
	InstallSourceTab *ist = 0;
	SectionMap::iterator module;
	ConfigEntMap::iterator entry, entryEnd;
	string sourceDir;

	if (PageControl1->ActivePage != PageControl1->Pages[0]) {
		ist = (InstallSourceTab *) PageControl1->ActivePage->Controls[0];
		tree = ist->tree;
	}
	else	tree = localTree;
		
	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (ist)
				sourceDir = "./sources/" + ist->Source;
			else	sourceDir = getLocalDir();
			SWMgr *mgr = new SWMgr(sourceDir.c_str());
	
			module = mgr->config->Sections.find((const char *)node->Data);

			if (module != mgr->config->Sections.end()) {
				string targetVersion = "0.0";
				string sourceVersion = "1.0";
				SectionMap::iterator targetSection;
					
				entry = module->second.find("Version");
				if (entry != module->second.end())
					sourceVersion = entry->second.c_str();

				targetSection = manager->config->Sections.find(module->first);
				if (targetSection != manager->config->Sections.end()) {
					targetVersion = "1.0";
					entry = targetSection->second.find("Version");
					if (entry != targetSection->second.end())
						targetVersion = entry->second;
				}
				if (VersionInfo(targetVersion.c_str()) < VersionInfo("1.0")) {
					InfoForm->info = "\\pard{\\b * Additional Module Available for Install. } \\par ";
				}
				else {
					InfoForm->info = "\\pard{\\b + Upgraded Module Available for Install.}\\par\\tab Current Version:  \\tab " + targetVersion + " \\par\\tab Upgrade Version:\\tab " + sourceVersion + " \\par ";
					bool changes = false;
					for (entry = module->second.begin(); entry != module->second.end(); entry++) {
						if (!strncmp(entry->first.c_str(), "History_", 8)) {
							if (VersionInfo(&entry->first.c_str()[8]) > VersionInfo(targetVersion.c_str())) {
								if (!changes) {
									changes = true;
									InfoForm->info += "\\par{\\b Changes: }\\par ";
								}
								InfoForm->info += "\\tab ";
								InfoForm->info += entry->second.c_str();
								InfoForm->info += "\\par ";
							}
						}
					}
				}

				entry = module->second.find("About");
				if (entry != module->second.end()) {
					InfoForm->info += "\\par{\\b About: } \\par\\par ";
					InfoForm->info += entry->second.c_str();
				}
				InfoForm->Caption = "Module Information";
				InfoForm->ShowModal();
			}
			delete mgr;
		}
	}
}
//---------------------------------------------------------------------------

void TMainForm::Exit1Click(GtkWidget *Sender)
{
	Close();	
}
//---------------------------------------------------------------------------

*/
void TMainForm::deleteAllModules() {

	SWMgr *mgr = new SWMgr();
	

	int count = mgr->Modules.size();

	if (!count)
		return;

//	UninstallForm->Show();
//	UninstallForm->ProgressBar1->Max = count;
//	UninstallForm->ProgressBar1->Position = 0;

	ModMap::iterator it;
	for (it = mgr->Modules.begin(); it != mgr->Modules.end(); it++) {
		string label = "Uninstalling: [";
		label += it->second->Name();
		label += "] ";
		label += it->second->Description();
//		UninstallForm->Label1->Caption = label.c_str();
//		UninstallForm->Label1->Repaint();
		removeModule(it->second->Name());
//		UninstallForm->ProgressBar1->Position = UninstallForm->ProgressBar1->Position + 1;
//		UninstallForm->ProgressBar1->Repaint();
	}
	delete mgr;
//	UninstallForm->Hide();
	return;
}

void TMainForm::FormShow(GtkWidget *Sender) {

/*
	for (int i=0;i<=ParamCount();i++) {
		if (LowerCase(ParamStr(i)) == "-uninstall") {
			deleteAllModules();
			Application->Terminate();
		}
	}
	
*/
	gtk_widget_show (main_window);

	localTree->StateImages->Add(null_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->StateImages->Add(arrow2r_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->Images->Add(bookshut_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->Images->Add(bulbon_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->Images->Add(fingerup_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->Images->Add(bulblk_xpm, GTK_WIDGET(localTree->nativeControl));
	localTree->Images->Add(upgrdlk_xpm, GTK_WIDGET(localTree->nativeControl));
	
	TCustomImageList *im = new TCustomImageList(localTree); // cheeze
	im->Add(sword_xpm, GTK_WIDGET(banner_panel));
	im->Add(globe_xpm, GTK_WIDGET(banner_panel));
	im->Add(arrow2r_xpm, GTK_WIDGET(banner_panel));

	pixmap1 = GTK_WIDGET(im->GetPixmap(0));
	gtk_widget_ref (pixmap1);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap1);
	gtk_box_pack_start (GTK_BOX (banner_panel), pixmap1, FALSE, FALSE, 0);

	label3 = gtk_label_new (_("Available     "));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "label3", label3,
					   (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), label3, NULL, NULL);

	tmp_toolbar_icon = GTK_WIDGET(im->GetPixmap(1));
	GlobeBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar2),
						  GTK_TOOLBAR_CHILD_BUTTON,
						  NULL,
						  _("Mng Rmt Srcs"),
						  NULL, NULL,
						  tmp_toolbar_icon, NULL, NULL);
	gtk_widget_ref (GlobeBtn);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "GlobeBtn", GlobeBtn,
					   (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (GlobeBtn);

	label5 = gtk_label_new (_("      "));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "label5", label5,
					   (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), label5, NULL, NULL);

	pixmap2 = GTK_WIDGET(im->GetPixmap(2));
	gtk_widget_ref (pixmap2);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "pixmap2", pixmap2,
					   (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap2);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), pixmap2, NULL, NULL);

	label4 = gtk_label_new (_("Selected for Install"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (main_window), "label4", label4,
					   (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), label4, NULL, NULL);

  gtk_signal_connect (GTK_OBJECT (pixmap1), "button_press_event",
                      GTK_SIGNAL_FUNC (on_pixmap1_button_press_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (GlobeBtn), "clicked",
                      GTK_SIGNAL_FUNC (on_GlobeBtn_clicked),
                      NULL);

	fillInstallTree();
	fillSourceTree(getLocalDir(), localTree);
}
//---------------------------------------------------------------------------

