#!/usr/bin/make -f
# Sample debian/rules that uses debhelper.
# GNU copyright 1997 to 1999 by Joey Hess.

TARGET=__TARGET__
PACKAGE=gcc-__TARGET__

DEB_BUILD_GNU_TYPE      := $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE       := $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)


CONFARGS = -v \
        --enable-languages=c \
        --prefix=/usr \
        --infodir=/usr/share/info \
        --mandir=/usr/share/man \
        --enable-shared \
        --with-gnu-as \
        --with-gnu-ld \
        --with-system-zlib \
        --enable-long-long \
        --enable-nls \
        --without-included-gettext \
        --disable-checking \
        --build=$(DEB_BUILD_GNU_TYPE) \
        --host=$(DEB_HOST_GNU_TYPE) \
        --target=$(TARGET)

patch_stamp=patch-stamp
srcdir=src
include /usr/src/toolchain/patches/gcc/rules.patch

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# This is the debhelper compatability version to use.
export DH_COMPAT=3

unpack: unpack-stamp
unpack-stamp:
	tar xjf /usr/src/toolchain/gcc.tar.bz2
	mv gcc-* src
	mkdir build

	touch unpack-stamp

configure: configure-stamp
configure-stamp: unpack-stamp patch-stamp
	dh_testdir
	# Add here commands to configure the package.
	cd build && env CC="gcc" ../src/configure $(CONFARGS) 
	touch configure-stamp

build: configure-stamp build-stamp
build-stamp:
	dh_testdir

	# Add here commands to compile the package.
	cd build && $(MAKE)
	#/usr/bin/docbook-to-man debian/$(PACKAGE).sgml > $(PACKAGE).1

	touch build-stamp

clean:
	dh_testdir
	dh_testroot
	rm -f build-stamp configure-stamp unpack-stamp

	# Add here commands to clean up after the build process.
	#-$(MAKE) clean
	rm -rf src build patch-stamp*

	dh_clean

install: build
	dh_testdir
	dh_testroot
	dh_clean -k
	dh_installdirs

	# Add here commands to install the package into debian/$(PACKAGE).
	cd build && $(MAKE) install \
            prefix=$(CURDIR)/debian/$(PACKAGE)/usr \
            infodir=$(CURDIR)/debian/$(PACKAGE)/usr/share/info \
            mandir=$(CURDIR)/debian/$(PACKAGE)/usr/share/man 
	mv debian/$(PACKAGE)/usr/share/man/man1/cpp.1 \
     debian/$(PACKAGE)/usr/share/man/man1/$(TARGET)-cpp.1
	cd debian/$(PACKAGE)/usr/ && \
     rm -rf bin/gcov bin/gccbug share/man/man1/gcov.1* \
            lib/libiberty.a share/info share/man/man7/gfdl.7* \
            share/man/man7/gpl.7* share/man/man7/fsf-funding.7*


# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do by default.

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
#	dh_installdebconf	
	dh_installdocs
#	dh_installexamples
#	dh_installmenu
#	dh_installlogrotate
#	dh_installemacsen
#	dh_installpam
#	dh_installmime
#	dh_installinit
#	dh_installcron
	dh_installman
	dh_installinfo
	dh_undocumented
	dh_installchangelogs 
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
#	dh_makeshlibs
	dh_installdeb
#	dh_perl
	dh_shlibdeps -Xlibgcc_s

	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install configure
