/***************************************
  $Header: /home/amb/wwwoffle/src/RCS/proto.h 1.12 2001/09/26 17:45:06 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.7.
  Information about the protocols that wwwoffle supports.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99,2001 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef PROTO_H
#define PROTO_H    /*+ To stop multiple inclusions. +*/

#include "misc.h"

/*+ A type to contain the information that is required for a particular protocol. +*/
typedef struct _Protocol
{
 int number;                    /*+ The protocol number. +*/
 char *name;                    /*+ The protocol name. +*/

 int defport;                   /*+ The default port number. +*/

 int proxyable;                 /*+ Set to true if any known proxies can understand this. +*/
 int postable;                  /*+ Set to true if the POST method works. +*/
 int putable;                   /*+ Set to true if the PUT method works. +*/

 char*(*open)(URL*);            /*+ A function to open a connection to a remote server. +*/
 char*(*request)(URL*,Header*,Body*); /*+ A function to make a request to the remote server. +*/
 int  (*readhead)(Header**);    /*+ A function to read the header from the remote server. +*/
 int  (*readbody)(char*,int);   /*+ A function to read the body data from the remote server. +*/
 int  (*close)(void);           /*+ A function to close the connection to the remote server. +*/
}
Protocol;

#define Protocol_HTTP    0      /*+ The http protocol. +*/
#define Protocol_FTP     1      /*+ The ftp protocol. +*/
#define Protocol_Finger  2      /*+ The finger protocol. +*/

/* In proto.c */

/*+ The list of protocols. +*/
extern Protocol Protocols[];

/*+ The number of protocols. +*/
extern int NProtocols;

/* In http.c */

char *HTTP_Open(URL *Url);
char *HTTP_Request(URL *Url,Header *request_head,Body *request_body);
int   HTTP_ReadHead(Header **reply_head);
int   HTTP_ReadBody(char *s,int n);
int   HTTP_Close(void);

/* In ftp.c */

char *FTP_Open(URL *Url);
char *FTP_Request(URL *Url,Header *request_head,Body *request_body);
int   FTP_ReadHead(Header **reply_head);
int   FTP_ReadBody(char *s,int n);
int   FTP_Close(void);

/* In finger.c */

char *Finger_Open(URL *Url);
char *Finger_Request(URL *Url,Header *request_head,Body *request_body);
int   Finger_ReadHead(Header **reply_head);
int   Finger_ReadBody(char *s,int n);
int   Finger_Close(void);

/* In ssl.c */

char *SSL_Open(URL *Url);
char *SSL_Request(int client,URL *Url,Header *request_head);
void  SSL_Transfer(int client);
int   SSL_Close(void);

#endif /* PROTO_H */
