<?php
//
// ZoneMinder web HU Hungarian language file, $Date: 2011-08-23 15:10:20 +0100 (Tue, 23 Aug 2011) $, $Revision: 3500 $
// Copyright (C) 2001-2008 Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Hungarian Translation by szimszon at oregpreshaz dot eu, robi
// version: 0.6 - 2009.06.21. - frissts 1.24.2-hz (robi)
// version: 0.5 - 2007.12.30. - frissts 1.23.1-hez (robi)
// version: 0.4 - 2007.12.30. - frissts 1.23.0-hoz (robi)
// version: 0.3 - 2006.04.27. - fordts befejezse, elrendezse elfrshez (robi)
// version: 0.2 - 2006.12.05. - par javitas
// version: 0.1 - 2006.11.27. - sok typoval es par leforditatlan resszel

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
// require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
header( "Content-Type: text/html; charset=iso8859-2" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
// setlocale( 'LC_ALL', 'en_GB' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'hu_HU' ); //All locale settings 4.3.0 and after
//setlocale( LC_CTYPE, 'hu_HU'); //Character class settings 4.3.0 and after
//setlocale( LC_TIME, 'hu_HU'); //Date and time formatting 4.3.0 and after

setlocale( LC_TIME, 'hu_HU' );
setlocale( LC_ALL, 'hu_HU' );

// Simple String Replacements
$SLANG = array(
    '24BitColour'          => '24 bites szn',
    '8BitGrey'             => '8 bit szrkernyalat',
    'Action'               => 'Mvelet',
    'Actual'               => 'Vals',
    'AddNewControl'        => 'j vezrls',
    'AddNewMonitor'        => 'j monitor',
    'AddNewUser'           => 'j felhasznl',
    'AddNewZone'           => 'j zna',
    'Alarm'                => 'Riad',
    'AlarmBrFrames'        => 'Riad<br/>kpek',
    'AlarmFrame'           => 'Riad kp',
    'AlarmFrameCount'      => 'Riad kpek szma',
    'AlarmLimits'          => 'Riasztsi hatrok',
    'AlarmMaximumFPS'      => 'Maximlis FPS riasztsnl',
    'AlarmPx'              => 'Riad kppont',
    'AlarmRGBUnset'        => 'Be kell lltani egy RGB sznt a riasztshoz',
    'Alert'                => 'Riaszts',
    'All'                  => 'Mind',
    'Apply'                => 'Alkalmaz',
    'ApplyingStateChange'  => 'llapot vlts...',
    'ArchArchived'         => 'Csak archivlt',
    'ArchUnarchived'       => 'Csak archivlatlan',
    'Archive'              => 'Archivls',
    'Archived'             => 'Archvum',
    'Area'                 => 'Terlet',
    'AreaUnits'            => 'Terlet (kppont / %)',
    'AttrAlarmFrames'      => 'Riad kpkockk',
    'AttrArchiveStatus'    => 'Archivlt llapot',
    'AttrAvgScore'         => 'tlagos rtk',
    'AttrCause'            => 'Okoz',
    'AttrDate'             => 'Dtum',
    'AttrDateTime'         => 'Dtum/Id',
    'AttrDiskBlocks'       => 'Lemez blokkok',
    'AttrDiskPercent'      => 'Lemez szzalk',
    'AttrDuration'         => 'Idtartam',
    'AttrFrames'           => 'Kpkockk',
    'AttrId'               => 'Azonost',
    'AttrMaxScore'         => 'Max. rtk',
    'AttrMonitorId'        => 'Monitor azon.',
    'AttrMonitorName'      => 'Monitor nv',
    'AttrName'             => 'Nv',
    'AttrNotes'            => 'Megjegyzs',
    'AttrSystemLoad'       => 'Rendszer terhels',
    'AttrTime'             => 'Id',
    'AttrTotalScore'       => 'ssz. rtk',
    'AttrWeekday'          => 'Htkznap',
    'Auto'                 => 'Auto',
    'AutoStopTimeout'      => 'Auto megllsi id tllps',
    'Available'            => 'Elrhet',
    'AvgBrScore'           => 'tlag<br/>rtk',
    'Background'           => 'Httr',
    'BackgroundFilter'     => 'Szr futtatsa a httrben',
    'BadAlarmFrameCount'   => 'Riad kpek szma 1 vagy nagyobb egsz szm legyen',
    'BadAlarmMaxFPS'       => 'A riad maximlis FPS szma pozitv szm legyen',
    'BadChannel'           => 'A csatorna szma 0 vagy nagyobb egsz szm legyen',
    'BadDevice'            => 'Az eszkz rtk vals legyen',
    'BadFPSReportInterval' => 'FPS informcis idkz puffer szmllja 0 vagy nagyobb egsz legyen',
    'BadFormat'            => 'A tpus 0 vagy nagyobb egsz szm legyen',
    'BadFrameSkip'         => 'Kpkocka eldobsok szma 0 vagy nagyobb egsz szm legyen',
    'BadHeight'            => 'A kpmagassg rvnyes rtk legyen kppontban',
    'BadHost'              => 'A hoszt vals IP cm vagy hosztnv legyen, http:// nlkl',
    'BadImageBufferCount'  => 'Kp puffer mrete legyen 10 vagy nagyobb szm',
    'BadLabelX'            => 'A cimke X koordintja legyen 0 vagy nagyobb egsz szm',
    'BadLabelY'            => 'A cimke Y koordintja legyen 0 vagy nagyobb egsz szm',
    'BadMaxFPS'            => 'A maximlis FPS nullnl nagyobb szm legyen',
    'BadNameChars'         => 'A nv csak alfanumerikus karaktereket, plusz-, kt-, s alhzsjelet tartalmazhat',
    'BadPalette'           => 'A palettnak egy helyes rtket kell megadni',
    'BadPath'              => 'A kp elrsi tvonala vals legyen',
    'BadPort'              => 'A portszm vals legyen',
    'BadPostEventCount'    => 'Az esemny utni kpek puffere 0 vagy nagyobb egsz szm legyen',
    'BadPreEventCount'     => 'Az esemny eltti kpek puffere 0 vagy nagyobb egsz szm legyen',
    'BadRefBlendPerc'      => 'A referencia kpkeverk-szzalk pozitv egsz szm legyen',
    'BadSectionLength'     => 'Egy egysg hossza 30 vagy hosszabb legyen',
    'BadSignalCheckColour' => 'A jel ellenrzsi szn egy rvnyes RGP kd kell legyen',
    'BadStreamReplayBuffer'=> 'Folyam visszajtsz puffer 0 vagy nagyobb egsz szm legyen',
    'BadWarmupCount'       => 'Bemelegt kpek szma 0 vagy nagyobb egsz szm legyen',
    'BadWebColour'         => 'A web szn rvnyes web szn kd legyen',
    'BadWidth'             => 'A kpszlessg rvnyes rtk legyen kppontban',
    'Bandwidth'            => 'svszlessgre',
    'BlobPx'               => 'Blob kppont',
    'BlobSizes'            => 'Blob mrete',
    'Blobs'                => 'Blob-ok',
    'Brightness'           => 'Fnyer',
    'Buffers'              => 'Pufferek',
    'CanAutoFocus'         => 'Auto fkusz van',
    'CanAutoGain'          => 'Auto gain van',
    'CanAutoIris'          => 'Auto risz van',
    'CanAutoWhite'         => 'Van autmata fehr egyensly',
    'CanAutoZoom'          => 'Auto zoom van',
    'CanFocus'             => 'Tud fkuszlni',
    'CanFocusAbs'          => 'Tud abszolt fkuszt',
    'CanFocusCon'          => 'Tud folyamatos fkuszt',
    'CanFocusRel'          => 'Tud relatv fkuszt',
    'CanGain'              => 'Tud ersteni',
    'CanGainAbs'           => 'Tud abszolt erstst',
    'CanGainCon'           => 'Tud folyamatos erstst',
    'CanGainRel'           => 'Tud relatv erstst',
    'CanIris'              => 'Tud riszt vltoztatni',
    'CanIrisAbs'           => 'Tud abszolut riszt',
    'CanIrisCon'           => 'Folyamatosan tud riszt vltoztatni',
    'CanIrisRel'           => 'Relatven tud riszt vltoztatni',
    'CanMove'              => 'Tud mozogni',
    'CanMoveAbs'           => 'Tud abszolult mozgst',
    'CanMoveCon'           => 'Folyamatosan tud mozogni',
    'CanMoveDiag'          => 'Diagonlban tud mozogni',
    'CanMoveMap'           => 'tvonalon tud mozogni',
    'CanMoveRel'           => 'Relatven tud mozogni',
    'CanPan'               => 'Tud jobb-bal mozgst' ,
    'CanReset'             => 'Tud alaphelyzetbe jnni',
    'CanSetPresets'        => 'Tud menteni profilokat',
    'CanSleep'             => 'Tud phihen zemmdot',
    'CanTilt'              => 'Tud fel-le mozgst',
    'CanWake'              => 'Tud felledni',
    'CanWhite'             => 'Tud fehr egyenslyt',
    'CanWhiteAbs'          => 'Tud abszolut fehr egyenslyt',
    'CanWhiteBal'          => 'Tud fehr egyenslyt',
    'CanWhiteCon'          => 'Tud folyamatos fehr egyenslyt',
    'CanWhiteRel'          => 'Tud relatv fehr egyenslyt',
    'CanZoom'              => 'Tud zoom-olni',
    'CanZoomAbs'           => 'Tud abszolut zoom-ot',
    'CanZoomCon'           => 'Tud folyamatos zoom-ot',
    'CanZoomRel'           => 'Tud relatv zoom-ot',
    'Cancel'               => 'Mgsem',
    'CancelForcedAlarm'    => 'Kzi riaszts lelltsa',
    'CaptureHeight'        => 'Kpmagassg',
    'CaptureMethod'        => 'Digitalizls mdszere',
    'CapturePalette'       => 'Digitalizls szn-palettja',
    'CaptureWidth'         => 'Kpszlessg',
    'Cause'                => 'Okoz',
    'CheckMethod'          => 'A riaszts figyelsnek mdja',
    'ChooseDetectedCamera' => 'Vlasszon rzkelt kamert',
    'ChooseFilter'         => 'Vlassz szrt',
    'ChooseLogFormat'      => 'Choose a log format',    // Added - 2011-06-17
    'ChooseLogSelection'   => 'Choose a log selection', // Added - 2011-06-17
    'ChoosePreset'         => 'Vlassz profilt',
    'Clear'                => 'Clear',                  // Added - 2011-06-16
    'Close'                => 'Bezr',
    'Colour'               => 'Szn',
    'Command'              => 'Parancs',
    'Component'            => 'Component',              // Added - 2011-06-16
    'Config'               => 'Bellts',
    'ConfiguredFor'        => 'Belltva',
    'ConfirmDeleteEvents'  => 'Biztos benne, hogy trli a kivlasztott esemnyeket?',
    'ConfirmPassword'      => 'Jelsz megersts',
    'ConjAnd'              => 's',
    'ConjOr'               => 'vagy',
    'Console'              => 'Konzol',
    'ContactAdmin'         => 'Krem vegye fel a kapcsolatot a rendszergazdval a rszletekrt.',
    'Continue'             => 'Folytats',
    'Contrast'             => 'Kontraszt',
    'Control'              => 'Vezrls',
    'ControlAddress'       => 'Vezrlsi jogok',
    'ControlCap'           => 'Vezrlsi lehetsg',
    'ControlCaps'          => 'Vezrlsi lehetsgek',
    'ControlDevice'        => 'Vezrl eszkz',
    'ControlType'          => 'Vezrls tpusa',
    'Controllable'         => 'Vezrelhet',
    'Cycle'                => 'Krbekapcsols',
    'CycleWatch'           => 'Krbekapcsols',
    'DateTime'             => 'Date/Time',              // Added - 2011-06-16
    'Day'                  => 'Napon',
    'Debug'                => 'Nyomon<br>kvets',
    'DefaultRate'          => 'Alaprtelmezett sebessg',
    'DefaultScale'         => 'Alaprtelmezett mret',
    'DefaultView'          => 'Alaprtelmezett nzet',
    'Delete'               => 'Trl',
    'DeleteAndNext'        => 'Trl &amp;<br>kvetkez',
    'DeleteAndPrev'        => 'Trl &amp;<br>elz',
    'DeleteSavedFilter'    => 'Mentett szr trlse',
    'Description'          => 'Lers',
    'DetectedCameras'      => 'rzkelt kamerk',
    'Device'               => 'Eszkz',
    'DeviceChannel'        => 'Eszkz csatornja',
    'DeviceFormat'         => 'Eszkz formtuma',
    'DeviceNumber'         => 'Eszkz szm',
    'DevicePath'           => 'Eszkz elrsi tvonala',
    'Devices'              => 'Eszkzk',
    'Dimensions'           => 'Dimenzik',
    'DisableAlarms'        => 'Riaszts tiltsa',
    'Disk'                 => 'Trhely',
    'Display'               => 'Megjelens',
    'Displaying'           => 'Displaying',             // Added - 2011-06-16
    'Donate'               => 'Krem tmogasson',
    'DonateAlready'        => 'Nem, n mr tmogattam',
    'DonateEnticement'     => 'n mr j ideje hasznlja a ZoneMindert remlhetleg hasznos kiegsztsnek tartja hza vagy munkahelye biztostsban. Br ZoneMinder szabad, nylt forrskd, s az is marad; a fejlesztse pnzbe kerl. Ha tmogatni szeretn a jvbeni fejlesztseket s az j funkcikat krem tmogasson. A tmogats teljesen nkntes, de nagyon megbecslt s annyival tud tmogatni amennyivel kvn.<br><br>Ha tmogatni szertne krem vlasszon az albbi lehetsgekbl vagy ltogassa meg a http://www.zoneminder.com/donate.html oldalt.<br><br>Ksznm, hogy hasznlja a ZoneMinder-t s ne felejtse el megltogatni a frumokat a ZoneMinder.com oldalon tmogatsrt s tletekrt, hogy tudja mg jobban hasznlni a ZoneMinder-t.',
    'DonateRemindDay'      => 'Nem most, figyelmeztess 1 nap mlva',
    'DonateRemindHour'     => 'Nem most, figyelmeztess 1 ra mlva',
    'DonateRemindMonth'    => 'Nem most, figyelmeztess 1 hnap mlva',
    'DonateRemindNever'    => 'Nem akarom tmogatni, ne is emlkeztess',
    'DonateRemindWeek'     => 'Nem most, figyelmeztess 1 ht mlva',
    'DonateYes'            => 'Igen, most szeretnm tmogatni',
    'Download'             => 'Letlt',
    'DuplicateMonitorName' => 'Monitor nevnek dupliklsa',
    'Duration'             => 'Idtartam',
    'Edit'                 => 'Szerkeszt',
    'Email'                => 'Email',
    'EnableAlarms'         => 'Riaszts feloldsa',
    'Enabled'              => 'Engedlyezve',
    'EnterNewFilterName'   => 'rd be az j szr nevt',
    'Error'                => 'Hiba',
    'ErrorBrackets'        => 'Hiba, ellenrizd, hogy ugyanannyi nyit s zr zrjel van',
    'ErrorValidValue'      => 'Hiba, ellenrizd, hogy minden belltsnak rvnyes rtke van',
    'Etc'                  => 'stb',
    'Event'                => 'Esemny',
    'EventFilter'          => 'Esemny szr',
    'EventId'              => 'Esemny azonost',
    'EventName'            => 'Esemny nv',
    'EventPrefix'          => 'Esemny eltag',
    'Events'               => 'Esemnyek',
    'Exclude'              => 'Kizr',
    'Execute'              => 'Futtat',
    'Export'               => 'Exportl',
    'ExportDetails'        => 'Esemny adatainak exportlsa',
    'ExportFailed'         => 'Hibs exportls',
    'ExportFormat'         => 'Exportlt fjl formtuma',
    'ExportFormatTar'      => 'TAR',
    'ExportFormatZip'      => 'ZIP',
    'ExportFrames'         => 'Kpek adatainak exportlsa',
    'ExportImageFiles'     => 'Kpek exportlsa',
    'ExportLog'            => 'Export Log',             // Added - 2011-06-17
    'ExportMiscFiles'      => 'Egyb fjlok exportlsa (ha vannak)',
    'ExportOptions'        => 'Exportls belltsai',
    'ExportSucceeded'      => 'Az exportls sikerlt',
    'ExportVideoFiles'     => 'Vide fjlok exportlsa (ha vannak)',
    'Exporting'            => 'Exportls...',
    'FPS'                  => 'fps',
    'FPSReportInterval'    => 'FPS megjelents idkze',
    'FTP'                  => 'FTP',
    'Far'                  => 'Tvol',
    'FastForward'          => 'Elre tekers',
    'Feed'                 => 'Folyam',
    'Ffmpeg'               => 'Ffmpeg',
    'File'                 => 'Fjl',
    'FilterArchiveEvents'  => 'Minden tallat archivlsa',
    'FilterDeleteEvents'   => 'Minden tallat trlse',
    'FilterEmailEvents'    => 'Minden tallat adatainak elkldse E-mailben',
    'FilterExecuteEvents'  => 'Parancs futtatsa minden tallaton',
    'FilterMessageEvents'  => 'Minden tallat adatainak zense',
    'FilterPx'             => 'Szrt kpkockk',
    'FilterUnset'          => 'Meg kell adnod a szr szlessgt s magassgt',
    'FilterUploadEvents'   => 'Minden tallat feltltse',
    'FilterVideoEvents'    => 'Vide ksztse minden tallatrl',
    'Filters'              => 'Szrk',
    'First'                => 'Els',
    'FlippedHori'          => 'Vzszintes tkrzs',
    'FlippedVert'          => 'Fggleges tkrzs',
    'Focus'                => 'Fkusz',
    'ForceAlarm'           => 'Kzi riaszts',
    'Format'               => 'Formtum',
    'Frame'                => 'Kpkocka',
    'FrameId'              => 'Kpkocka azonost',
    'FrameRate'            => 'FPS',
    'FrameSkip'            => 'Kpkocka kihagys',
    'Frames'               => 'Kpkocka',
    'Func'                 => 'Funk.',
    'Function'             => 'Funkci',
    'Gain'                 => 'Ersts',
    'General'              => 'ltalnos',
    'GenerateVideo'        => 'Vide kszts',
    'GeneratingVideo'      => 'Vide ksztse...',
    'GoToZoneMinder'       => 'Ltogats a ZoneMinder.com-ra',
    'Grey'                 => 'Szrke',
    'Group'                => 'Csoport',
    'Groups'               => 'Csoportok',
    'HasFocusSpeed'        => 'Van fkusz sebessg',
    'HasGainSpeed'         => 'Van ersts sebessg',
    'HasHomePreset'        => 'Van kedvenc profilja',
    'HasIrisSpeed'         => 'Van risz sebessg',
    'HasPanSpeed'          => 'Van jobb-bal sebessg',
    'HasPresets'           => 'Vannak profiljai',
    'HasTiltSpeed'         => 'Van le-fel sebessg',
    'HasTurboPan'          => 'Van turb jobb-bal',
    'HasTurboTilt'         => 'Van turb le-fel',
    'HasWhiteSpeed'        => 'Van fehr egyensly sebessg',
    'HasZoomSpeed'         => 'Van zoom sebessg',
    'High'                 => 'Magas',
    'HighBW'               => 'Magas<br>svsz.',
    'Home'                 => 'Home',
    'Hour'                 => 'rban',
    'Hue'                  => 'Sznrnyalat',
    'Id'                   => 'Az.',
    'Idle'                 => 'Nyugalom',
    'Ignore'               => 'Figyelmen kvl hagy',
    'Image'                => 'Kp',
    'ImageBufferSize'      => 'Kppuffer mrete (kpkockk)',
    'Images'               => 'Kp',
    'In'                   => 'In',
    'Include'              => 'Begyaz',
    'Inverted'             => 'Invertlva',
    'Iris'                 => 'risz',
    'KeyString'            => 'Kulcs karaktersor',
    'Label'                => 'Cimke',
    'Language'             => 'Nyelv',
    'Last'                 => 'Utols',
    'Layout'               => 'Elrendezs',
    'Level'                => 'Level',                  // Added - 2011-06-16
    'LimitResultsPost'     => 'tallatig korltoz', // This is used at the end of the phrase 'Limit to first N results only'
    'LimitResultsPre'      => 'Az els', // This is used at the beginning of the phrase 'Limit to first N results only'
    'Line'                 => 'Line',                   // Added - 2011-06-16
    'LinkedMonitors'       => 'sszefgg monitorok',
    'List'                 => 'Lista',
    'Load'                 => 'Terhels',
    'Local'                => 'Helyi',
    'Log'                  => 'Log',                    // Added - 2011-06-16
    'LoggedInAs'           => 'Bejelentkezve mint',
    'Logging'              => 'Logging',                // Added - 2011-06-16
    'LoggingIn'            => 'Bejelentkezs folyamatban',
    'Login'                => 'Bejelentkezs',
    'Logout'               => 'Kilps',
    'Logs'                 => 'Logs',                   // Added - 2011-06-17
    'Low'                  => 'Alacsony',
    'LowBW'                => 'Alacsony<br>svsz.',
    'Main'                 => 'F',
    'Man'                  => 'Man',
    'Manual'               => 'Kziknyv',
    'Mark'                 => 'Jells',
    'Max'                  => 'Max.',
    'MaxBandwidth'         => 'Max. svszlessg',
    'MaxBrScore'           => 'Max.<br/>rtk',
    'MaxFocusRange'        => 'Max. fkusz tartomny',
    'MaxFocusSpeed'        => 'Max. fkusz sebessg',
    'MaxFocusStep'         => 'Max. fkusz lps',
    'MaxGainRange'         => 'Max Gain Range',
    'MaxGainSpeed'         => 'Max Gain Speed',
    'MaxGainStep'          => 'Max Gain Step',
    'MaxIrisRange'         => 'Max. risz tartomny',
    'MaxIrisSpeed'         => 'Max. risz sebessg',
    'MaxIrisStep'          => 'Max. risz lps',
    'MaxPanRange'          => 'Max. jobb-bal tartomny',
    'MaxPanSpeed'          => 'Max. jobb-bal sebessg',
    'MaxPanStep'           => 'Max. jobb-bal lps',
    'MaxTiltRange'         => 'Max. fel-le tartomny',
    'MaxTiltSpeed'         => 'Max. fel-le sebessg',
    'MaxTiltStep'          => 'Max. fel-le lps',
    'MaxWhiteRange'        => 'Max. fehr egyensly tartomny',
    'MaxWhiteSpeed'        => 'Max. fehr egyensly sebessg',
    'MaxWhiteStep'         => 'Max. fehr egyensly lps',
    'MaxZoomRange'         => 'Max. zoom tartomny',
    'MaxZoomSpeed'         => 'Max. zoom sebessg',
    'MaxZoomStep'          => 'Max. zoom lps',
    'MaximumFPS'           => 'Maximum FPS',
    'Medium'               => 'Kzepes',
    'MediumBW'             => 'Kzepes<br>svsz.',
    'Message'              => 'Message',                // Added - 2011-06-16
    'MinAlarmAreaLtMax'    => 'A minimum riasztott terletnek kisebbnek kell lennie mint a maximumnak',
    'MinAlarmAreaUnset'    => 'Meg kell adnod a minimum riasztott kppontok szmt',
    'MinBlobAreaLtMax'     => 'A minimum blob terletnek kisebbnek kell lennie mint a maximumnak',
    'MinBlobAreaUnset'     => 'Meg kell adnod a minimum blob kppontok szmt',
    'MinBlobLtMinFilter'   => 'A minimum blob terletnek kisebbnek vagy egyenlnek kell lennie a megszrt terlettel',
    'MinBlobsLtMax'        => 'A minimum bloboknak kisebbeknek kell lennik, mint a maximum',
    'MinBlobsUnset'        => 'Meg kell adnod a blobok szmt',
    'MinFilterAreaLtMax'   => 'A minimum megszrt terletnek kisebbnek kell lennie mint a maximum',
    'MinFilterAreaUnset'   => 'Meg kell adnod a megszrt terlet kppontjainak szmt',
    'MinFilterLtMinAlarm'  => 'A megszrt terletnek kisebbnek vagy ugyanakkornak kell lennie mint a riasztott terlet',
    'MinFocusRange'        => 'Min. fkusz terlet',
    'MinFocusSpeed'        => 'Min. fkusz sebessg',
    'MinFocusStep'         => 'Min. fkusz lps',
    'MinGainRange'         => 'Min Gain Range',
    'MinGainSpeed'         => 'Min Gain Speed',
    'MinGainStep'          => 'Min Gain Step',
    'MinIrisRange'         => 'Min. risz terlet',
    'MinIrisSpeed'         => 'Min. risz sebessg',
    'MinIrisStep'          => 'Min. risz lps',
    'MinPanRange'          => 'Min. jobb-bal tartomny',
    'MinPanSpeed'          => 'Min. jobb-bal sebessg',
    'MinPanStep'           => 'Min. jobb-bal lps',
    'MinPixelThresLtMax'   => 'A kppont minimum eltrsi kszbnek kisebbnek kell lennie, mint a maximum',
    'MinPixelThresUnset'   => 'Meg kell adnod a kppont minimum eltrsi kszbt',
    'MinTiltRange'         => 'Min. fel-le tartomny',
    'MinTiltSpeed'         => 'Min. fel-le sebessg',
    'MinTiltStep'          => 'Min. fel-le lps',
    'MinWhiteRange'        => 'Min. fehr egyensly terlet',
    'MinWhiteSpeed'        => 'Min. fehr egyensly sebessg',
    'MinWhiteStep'         => 'Min. fehr egyensly lps',
    'MinZoomRange'         => 'Min. zoom terlet',
    'MinZoomSpeed'         => 'Min. zoom sebessg',
    'MinZoomStep'          => 'Min. zoom lps',
    'Misc'                 => 'Egyb',
    'Monitor'              => 'Monitor',
    'MonitorIds'           => 'Monitor&nbsp;azonostk',
    'MonitorPreset'        => 'Elre belltott monitorprofilok',
    'MonitorPresetIntro'   => 'Vlassz egy, az elre meghatrozott<br> rtkprofilt az albbiak kzl.<br><br>Vedd figyelembe, hogy ez fellrhatja <br>az ltalad mr belltott rtkeket.<br><br>',
    'MonitorProbe'         => 'Monitor szlels',
    'MonitorProbeIntro'    => 'Az albbi listban tallhatk az automatikusan rzkelt analg s hlzati kamerkat, illetve azt, hogy kzlk melyik van hasznlatban, vagy kivlaszthat.<br/><br/>Vlasszon egyet az albbi listbl.<br/><br/>Figyelem! Nem biztos, hogy minden kamert lehet automatikusan rzkelni. Az itt kivlasztott kamara adatai fellrhatjk azokat, amelyeket mr ehhez a monitorhoz belltott.<br/><br/>',
    'Monitors'             => 'Monitorok',
    'Montage'              => 'Tbbkamers nzet',
    'Month'                => 'Hnapban',
    'More'                 => 'More',                   // Added - 2011-06-16
    'Move'                 => 'Mozgs',
    'MustBeGe'             => 'nagyobbnak vagy egyenlnek kell lennie',
    'MustBeLe'             => 'kisebbnek vagy egyenlnek kell lennie',
    'MustConfirmPassword'  => 'Meg kell erstened a jelszt',
    'MustSupplyPassword'   => 'Meg kell adnod a jelszt',
    'MustSupplyUsername'   => 'Meg kell adnod felhasznli nevet',
    'Name'                 => 'Nv',
    'Near'                 => 'Kzel',
    'Network'              => 'Hlzat',
    'New'                  => 'Uj',
    'NewGroup'             => 'j csoport',
    'NewLabel'             => 'j cimke',
    'NewPassword'          => 'j jelsz',
    'NewState'             => 'j llapot neve',
    'NewUser'              => 'j felhasznl',
    'Next'                 => 'Kvetkez',
    'No'                   => 'Nem',
    'NoDetectedCameras'    => 'Nincsenek rzkelt kamerk',
    'NoFramesRecorded'     => 'Nincs felvett kpkocka ehhez az esemnyhez',
    'NoGroup'              => 'Nincs csoport',
    'NoSavedFilters'       => 'Nincs mentett szr',
    'NoStatisticsRecorded' => 'Nincs mentett statisztika ehhez az esemnyhez/kpkockhoz',
    'None'                 => 'Nincs kivlasztva',
    'NoneAvailable'        => 'Nem elrhet',
    'Normal'               => 'Norml',
    'Notes'                => 'Megjegyzsek',
    'NumPresets'           => 'Profilok szma',
    'Off'                  => 'Ki',
    'On'                   => 'Be',
    'OpEq'                 => 'egyenl',
    'OpGt'                 => 'nagyobb mint',
    'OpGtEq'               => 'nagyobb van egyenl',
    'OpIn'                 => 'belltva',
    'OpLt'                 => 'kisebb mint',
    'OpLtEq'               => 'kisebb vagy egyenl',
    'OpMatches'            => 'tallatok',
    'OpNe'                 => 'nem egyenl',
    'OpNotIn'              => 'nincs belltva',
    'OpNotMatches'         => 'nincs tallat',
    'Open'                 => 'Megnyits',
    'OptionHelp'           => 'Belltsi segtsg',
    'OptionRestartWarning' => 'Ez a bellts nem jut teljesen rvnyre\namg a rendszer fut. Ha megtettl minden\nbelltst, indtsd jra a ZoneMinder szolgltatst.',
    'Options'              => 'Belltsok',
    'OrEnterNewName'       => 'vagy adj meg j nevet',
    'Order'                => 'Sorrend',
    'Orientation'          => 'Orientci',
    'Out'                  => 'Kifel',
    'OverwriteExisting'    => 'Meglv fellrsa',
    'Paged'                => 'Lapozva',
    'Pan'                  => 'Jobb-bal mozgs',
    'PanLeft'              => 'Mozgs balra',
    'PanRight'             => 'Mozgs jobbra',
    'PanTilt'              => 'Mozgat',
    'Parameter'            => 'Paramter',
    'Password'             => 'Jelsz',
    'PasswordsDifferent'   => 'Az j s a megerstett jelsz klnbzik!',
    'Paths'                => 'tvonalak',
    'Pause'                => 'Sznet',
    'Phone'                => 'Telefonon betrcszva',
    'PhoneBW'              => 'Betrcsz<br>svsz.',
    'Pid'                  => 'PID',                    // Added - 2011-06-16
    'PixelDiff'            => 'Kppont eltrs',
    'Pixels'               => 'kppont',
    'Play'                 => 'Lejtszs',
    'PlayAll'              => 'Mind lejtszsa',
    'PleaseWait'           => 'Krlek vrj...',
    'Point'                => 'Pont',
    'PostEventImageBuffer' => 'Esemny utni kppuffer',
    'PreEventImageBuffer'  => 'Esemny eltti kppuffer',
    'PreserveAspect'       => 'Kparny megtartsa',
    'Preset'               => 'Elre belltott profil',
    'Presets'              => 'Elre belltott profilok',
    'Prev'                 => 'Elz',
    'Probe'                => 'rzkels',
    'Protocol'             => 'Protocol',
    'Rate'                 => 'FPS',
    'Real'                 => 'Vals',
    'Record'               => 'Felvtel',
    'RefImageBlendPct'     => 'Vltozs a referenciakptl %-ban',
    'Refresh'              => 'Frisst',
    'Remote'               => 'Hlzati',
    'RemoteHostName'       => 'Hlzati IP cm/hosztnv',
    'RemoteHostPath'       => 'A kp elrsi tvonala',
    'RemoteHostPort'       => 'Hlzati portszm',
    'RemoteHostSubPath'    => 'A kp elrsi al-tvonala',
    'RemoteImageColours'   => 'A kp szne',
    'RemoteMethod'         => 'Hlzati metdus',
    'RemoteProtocol'       => 'Hlzati protokoll',
    'Rename'               => 'tnevezs',
    'Replay'               => 'Visszajtszs',
    'ReplayAll'            => 'Minden esemnyt',
    'ReplayGapless'        => 'Folyamatos esemnyeket',
    'ReplaySingle'         => 'Egyni esemny',
    'Reset'                => 'Alaprtkre llt',
    'ResetEventCounts'     => 'Esemny szmll nullzsa',
    'Restart'              => 'A szolgltats jraindtsa',
    'Restarting'           => 'jraindts',
    'RestrictedCameraIds'  => 'Korltozott kamerk azonosti',
    'RestrictedMonitors'   => 'Korltozott kamerk',
    'ReturnDelay'          => 'Visszarkezs ksleltetse',
    'ReturnLocation'       => 'Visszarkezs helye',
    'Rewind'               => 'Visszatekers',
    'RotateLeft'           => 'Balra forgats',
    'RotateRight'          => 'Jobbra forgats',
    'RunLocalUpdate'       => 'Please run zmupdate.pl to update', // Added - 2011-05-25
    'RunMode'              => 'Futsi md',
    'RunState'             => 'A ZoneMinder llapota',
    'Running'              => 'les',
    'Save'                 => 'Ments',
    'SaveAs'               => 'Ments mint',
    'SaveFilter'           => 'Szr mentse',
    'Scale'                => 'Mret',
    'Score'                => 'Pontszm',
    'Secs'                 => 'mp.',
    'Sectionlength'        => 'Rsz hossz',
    'Select'               => 'Kivlaszts',
    'SelectFormat'         => 'Select Format',          // Added - 2011-06-17
    'SelectLog'            => 'Select Log',             // Added - 2011-06-17
    'SelectMonitors'       => 'Monitorok kivlasztsa',
    'SelfIntersecting'     => 'A sokszg szlei nem keresztezdhetnek',
    'Set'                  => 'Bellt',
    'SetNewBandwidth'      => 'j svszlessg bellts',
    'SetPreset'            => 'Alaprtelmezett belltsa',
    'Settings'             => 'Belltsok',
    'ShowFilterWindow'     => 'Szrablak megjelents',
    'ShowTimeline'         => 'Idvonal megjelents',
    'SignalCheckColour'    => 'Szn a jel kimaradsakor',
    'Size'                 => 'Fjlmret',
    'SkinDescription'      => 'Change the default skin for this computer', // Added - 2011-01-30
    'Sleep'                => 'Alvs',
    'SortAsc'              => 'Nvekv',
    'SortBy'               => 'Sorbarendezs:',
    'SortDesc'             => 'Cskken',
    'Source'               => 'Forrs',
    'SourceColours'        => 'A kp szne',
    'SourcePath'           => 'A kp elrsi tvonala',
    'SourceType'           => 'Kp-forrs tpusa',
    'Speed'                => 'Sebessg',
    'SpeedHigh'            => 'Nagy sebssg',
    'SpeedLow'             => 'Alacsony sebessg',
    'SpeedMedium'          => 'Kzepes sebessg',
    'SpeedTurbo'           => 'Turb sebessg',
    'Start'                => 'Indt',
    'State'                => 'llapot',
    'Stats'                => 'Statisztikk',
    'Status'               => 'Sttusz',
    'Step'                 => 'Ugrs',
    'StepBack'             => 'Visszalps',
    'StepForward'          => 'Elrelps',
    'StepLarge'            => 'Nagy ugrs',
    'StepMedium'           => 'Kzepes ugrs',
    'StepNone'             => 'Nincs ugrs',
    'StepSmall'            => 'Kis ugrs',
    'Stills'               => 'llkpek',
    'Stop'                 => 'A szolgltats lelltsa',
    'Stopped'              => 'Lelltva',
    'Stream'               => 'l folyam',
    'StreamReplayBuffer'   => 'Folyam visszajtsz kppuffer',
    'Submit'               => 'Elkld',
    'System'               => 'Rendszer',
    'SystemLog'            => 'System Log',             // Added - 2011-06-16
    'Tele'                 => 'Tv',
    'Thumbnail'            => 'Elnzet',
    'Tilt'                 => 'Fel-le mozgs',
    'Time'                 => 'Idpont',
    'TimeDelta'            => 'Id vltozs',
    'TimeStamp'            => 'Idblyeg',
    'Timeline'             => 'Idvonal',
    'Timestamp'            => 'Idblyeg',
    'TimestampLabelFormat' => 'Idblyeg formtum',
    'TimestampLabelX'      => 'Elhelyezs X pozici',
    'TimestampLabelY'      => 'Elhelyezs Y pozici',
    'Today'                => 'Ma',
    'Tools'                => 'Eszkzk',
    'Total'                => 'Total',                  // Added - 2011-06-16
    'TotalBrScore'         => 'ssz.<br/>pontszm',
    'TrackDelay'           => 'Ksleltets kvetse',
    'TrackMotion'          => 'Mozgs kvetse',
    'Triggers'             => 'Elidzk',
    'TurboPanSpeed'        => 'Turb jobb-bal sebessg',
    'TurboTiltSpeed'       => 'Turbo fel-le sebessg',
    'Type'                 => 'Tpus',
    'Unarchive'            => 'Archvumbl ki',
    'Undefined'            => 'Nincs megadva',
    'Units'                => 'Egysg',
    'Unknown'              => 'Ismeretlen',
    'Update'               => 'Frissts',
    'UpdateAvailable'      => 'Elrhet ZoneMinder frissts.',
    'UpdateNotNecessary'   => 'Nem szksges a frissts.',
    'Updated'              => 'Updated',                // Added - 2011-06-16
    'Upload'               => 'Upload',                 // Added - 2011-08-23
    'UseFilter'            => 'Szrt hasznl',
    'UseFilterExprsPost'   => '&nbsp;szr&nbsp;kifejezs hasznlata', // This is used at the end of the phrase 'use N filter expressions'
    'UseFilterExprsPre'    => '&nbsp;', // This is used at the beginning of the phrase 'use N filter expressions'
    'User'                 => 'Felhasznl',
    'Username'             => 'Felhasznlnv',
    'Users'                => 'Felhasznlk',
    'Value'                => 'rtk',
    'Version'              => 'Verzi',
    'VersionIgnore'        => 'Ennek a verzinak a figyelmen kvl hagysa',
    'VersionRemindDay'     => '1 nap mlva emlkeztess',
    'VersionRemindHour'    => '1 ra mlva emlkeztess',
    'VersionRemindNever'   => 'Ne emlkeztess az j verzirl',
    'VersionRemindWeek'    => '1 ht mlva emlkeztess',
    'Video'                => 'Vide',
    'VideoFormat'          => 'Vide formtum',
    'VideoGenFailed'       => 'Hiba a vide ksztsekor!',
    'VideoGenFiles'        => 'Ltez videk',
    'VideoGenNoFiles'      => 'Nem tallhatk videk',
    'VideoGenParms'        => 'Vide ksztsi paramterek',
    'VideoGenSucceeded'    => 'A vide elkszlt!',
    'VideoSize'            => 'Kp mrete',
    'View'                 => 'Megtekint',
    'ViewAll'              => 'Az sszes listzsa',
    'ViewEvent'            => 'Esemnyek nzet',
    'ViewPaged'            => 'Oldal nzet',
    'Wake'                 => 'breszt',
    'WarmupFrames'         => 'Bemelegt kpkockk',
    'Watch'                => 'Figyel',
    'Web'                  => 'Web',
    'WebColour'            => 'Szn az idvonal ablakban',
    'Week'                 => 'Hten',
    'White'                => 'Fehr',
    'WhiteBalance'         => 'Fehr egyensly',
    'Wide'                 => 'Szles',
    'X'                    => 'X',
    'X10'                  => 'X10',
    'X10ActivationString'  => 'X10 lest karaktersor',
    'X10InputAlarmString'  => 'X10 bemeneti riad karaktersor',
    'X10OutputAlarmString' => 'X10 kimeneti riad karaktersor',
    'Y'                    => 'Y',
    'Yes'                  => 'Igen',
    'YouNoPerms'           => 'Nincs jogod az erforrs elrshez.',
    'Zone'                 => 'Zna:',
    'ZoneAlarmColour'      => 'Riad sznezs (R/G/B)',
    'ZoneArea'             => 'Zna lefedettsge',
    'ZoneFilterSize'       => 'Szrt szlessg/magassg<br>(kppont)',
    'ZoneMinMaxAlarmArea'  => 'Min/Max riad terlet',
    'ZoneMinMaxBlobArea'   => 'Min/Max Blob terlet',
    'ZoneMinMaxBlobs'      => 'Min/Max Blobok',
    'ZoneMinMaxFiltArea'   => 'Min/Max szrt terlet',
    'ZoneMinMaxPixelThres' => 'Min/Max kppont eltrsi<br>kszb (0-255)',
    'ZoneMinderLog'        => 'ZoneMinder Log',         // Added - 2011-06-17
    'ZoneOverloadFrames'   => 'Tlterhels esetn<br>ennyi kpkocka hagyhat ki',
    'Zones'                => 'Znk',
    'Zoom'                 => 'Zoom',
    'ZoomIn'               => 'Zoom be',
    'ZoomOut'              => 'Zoom ki',
);

// Complex replacements with formatting and/or placements, must be passed through sprintf
$CLANG = array(
    'CurrentLogin'         => 'Jelenleg belpve mint \'%1$s\'',
    'EventCount'           => '%1$s %2$s', // For example '37 Events' (from Vlang below)
    'LastEvents'           => 'Utols %1$s %2$s', // For example 'Last 37 Events' (from Vlang below)
    'LatestRelease'        => 'Az utols kiads v%1$s, ami neked van v%2$s.',
    'MonitorCount'         => '%1$s %2$s', // For example '4 Monitors' (from Vlang below)
    'MonitorFunction'      => 'Megfigyels funkci: %1$s',
    'RunningRecentVer'     => 'A legfrissebb ZoneMinder verzit hasznlod, v%s.',
    'VersionMismatch'      => 'Version mismatch, system is version %1$s, database is %2$s.', // Added - 2011-05-25
);

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$VLANG = array(
    'Event'                => array( 0=>'Esemny', 1=>'Esemny', 2=>'Esemny' ),
    'Monitor'              => array( 0=>'Monitor', 1=>'Monitor', 2=>'Monitor' ),
);

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $langVarArray, $count )
{
    krsort( $langVarArray );
    foreach ( $langVarArray as $key=>$value )
    {
        if ( abs($count) >= $key )
        {
            return( $value );
        }
    }
    die( 'Error, unable to correlate variable language string' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $langVarArray, $count )
// {
//  $secondlastdigit = substr( $count, -2, 1 );
//  $lastdigit = substr( $count, -1, 1 );
//  // or
//  // $secondlastdigit = ($count/10)%10;
//  // $lastdigit = $count%10;
// 
//  // Get rid of the special cases first, the teens
//  if ( $secondlastdigit == 1 && $lastdigit != 0 )
//  {
//      return( $langVarArray[1] );
//  }
//  switch ( $lastdigit )
//  {
//      case 0 :
//      case 5 :
//      case 6 :
//      case 7 :
//      case 8 :
//      case 9 :
//      {
//          return( $langVarArray[1] );
//          break;
//      }
//      case 1 :
//      {
//          return( $langVarArray[2] );
//          break;
//      }
//      case 2 :
//      case 3 :
//      case 4 :
//      {
//          return( $langVarArray[3] );
//          break;
//      }
//  }
//  die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form show below where the array key represents the option name minus the initial ZM_
// So for example, to override the help text for ZM_LANG_DEFAULT do
$OLANG = array(
//    'LANG_DEFAULT' => array(
//        'Prompt' => "This is a new prompt for this option",
//        'Help' => "This is some new help for this option which will be displayed in the popup window when the ? is clicked"
//    ),
);

?>
