/*  
 * Copyright (C) 2004 Tony Sin(x) '76 <tony@becrux.com>
 *  All rights reserved.
 *
 */

/*
 *			 GNU GENERAL PUBLIC LICENSE
 *			    Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
  #ifndef __main_config_h__
    #define __main_config_h__
    #include "../config.h"
  #endif

  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <unistd.h>
  #include <sys/types.h>
  #include <sys/stat.h>
  #include <sys/socket.h>
  #include <sys/un.h>
#endif

#include "courier.h"

cCourierClient::cCourierClient()
{
  struct sockaddr_un socket_addr;
  char old_sock_file[128], new_sock_file[128];

  sprintf(old_sock_file,"%s/.clamcour",COURIER_FILTER_PATH);
  sprintf(new_sock_file,"%s/clamcour",COURIER_FILTER_PATH);
  unlink(old_sock_file);
  unlink(new_sock_file);

  socket_addr.sun_family = AF_UNIX;
  strcpy(socket_addr.sun_path,old_sock_file);

  Sock = socket(PF_UNIX,SOCK_STREAM,0);
  bind(Sock,(struct sockaddr *) &socket_addr,sizeof(socket_addr.sun_family)+strlen(socket_addr.sun_path));

  chmod(old_sock_file,0666);
  rename(old_sock_file,new_sock_file);
  
  listen(Sock,5);
}

cCourierClient::~cCourierClient()
{
  close(Sock);
}

int cCourierClient::WaitForMail()
{
  return accept(Sock,NULL,NULL);
}
