// Written by James A. Pattie (james@pcxperience.com) Xperience, Inc. (www.pcxperience.com)
// Additions by Aecio F. Neto (afn@harvest.com.br) - Harvest Consultoria (http://www.harvest.com.br)
// Additions by Nerijus Baliunas (nerijus@users.sourceforge.net)
// Additions by mad@madness.at

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "VirusScanner.hpp"

extern OptionContainer o;

VirusScanner::VirusScanner ():tempFileName (NULL), tempFileFD (0), avEngine (NULL), scanIt (true)
{
}

VirusScanner::~VirusScanner ()
{
  resetScanner ();

  if (avEngine)
    {
      delete avEngine;
    }
}

void
VirusScanner::resetScanner ()
{
  timeout = 20;
  trickle_pos = 0;
  file_length = 0;
  infected = VirusEngine::AV_CLEAN;

  if (tempFileName)
    {
      unlink (tempFileName);
    }

  if (tempFileFD)
    {
      close (tempFileFD);
      tempFileFD = 0;
    }

  delete[]tempFileName;
  tempFileName = NULL;
}

int
VirusScanner::loadScanner ()
{
  // create temp dir
  if (mkdir (o.download_dir.c_str (), TEMPDIR_MASK) == -1)
    {
      if (errno != EEXIST)
        {
          syslog (LOG_ERR, "Error: %s", "cannot create temporary folder.");
          return -1;
        }
    }

  switch (o.virus_engine)
    {
#ifdef __CLAMAV
    case 1:                    // ClamScan
      avEngine = new ClamEngine ();
      break;
#endif

#ifdef __CLAMDSCAN
    case 3:                    // ClamDScan
      avEngine = new ClamDEngine ();
      break;
#endif

#ifdef __KAV
    case 2:                    // Kaspersky
      avEngine = new KAVEngine ();
      break;
#endif

#ifdef __TROPHIE
    case 4:                    // Trophie (Trendmicro)
      avEngine = new TrophieEngine ();
      break;
#endif

#ifdef __SOPHIE
    case 5:                    // Sophie (Sophos)
      avEngine = new SophieEngine ();
      break;
#endif

#ifdef __KAV5
    case 6:                    // Kaspersky v5 (aveserver)
      avEngine = new KAV5Engine ();
      break;
#endif

#ifdef __ICAP
    case 7:                    // ICAPScan
      avEngine = new ICAPEngine ();
      break;
#endif

    default:                   // oops, dunno about that engine
      std::cerr << "Unknown AV Engine; check your configuration" << std::endl;
      exit (10);
    }

  return avEngine->loadEngine ();
}

int
VirusScanner::unloadScanner ()
{
  if (avEngine)
    {
      avEngine->unloadEngine ();
      delete avEngine;
      avEngine = NULL;
    }

  return 0;
}

int
VirusScanner::reloadScanner ()
{
  int rc = -1;

  if (avEngine)
    {
      rc = avEngine->reloadEngine ();
    }

  return rc;
}

void
VirusScanner::handleScanning (Socket * proxysock, Socket * peerconn, String url, int docsize, int contentLength, string username, string clientip, int filtergroup, string location, int reporting_level, HTTPHeader * _docheader, bool dlmgr, int scantype)
{

  int rc = 0;
  bool scanFile = true;

  scanIt = true;

  if (scantype == 0)
    {
      // scantype 0 indicates that a temporary file has to be created and
      // its content will be retrieved by this class
      createTempFile ();
    }

  TrickleHandler *th = new TrickleHandler (MAX_BUF, SIZE, tempFileFD, _docheader, dlmgr);

  // here we download and trickle data
  // setup trickle handler
  th->prepareTrickle (*proxysock, *peerconn, contentLength, trickle_pos);

  while (true)
    {
      rc = th->doReceive (*proxysock, *peerconn);

      if (rc > 0)
        {
          scanFile = th->doTrickle (*peerconn);

          if (!scanFile)
            {
              scanIt = false;
            }
          if (!scanIt)
            {
              close (tempFileFD);
              unlink (tempFileName);
            }
        }
      // socket closed by client
      else if (rc == -2)
        {
          // clean things up and exit
          unlink (tempFileName);
          close (tempFileFD);
        
          tempFileName = NULL;
          
          delete th;
          return;
        }
      else
        break;
    }
  
  // store trickle_pos for possible later reuse
  trickle_pos = th->getTricklePos ();
  th->commitTrickle ();

  // When using download manager
  // update progress bar info after download is complete
  if (dlmgr)
    {
      th->doTrickle (*peerconn);
    }

  if (scanIt)
    {
      // scantype indicates that a temporary file already exists and
      // its content has a FD in this class
      scan (proxysock, peerconn, url, username, clientip, filtergroup, location, reporting_level, _docheader, dlmgr, scantype);
    }
  else
    {
      th->doReadAll (*peerconn, trickle_pos);
      unlink (tempFileName);
    }

  if (tempFileFD)
    {
      close (tempFileFD);
    }

  tempFileName = NULL;
    
  delete th;
}

void
VirusScanner::createTempFile (void)
throw (exception)
{

  tempFileName = new char[256];
  strcpy (tempFileName, o.download_dir.c_str ());
  strcat (tempFileName, "tfXXXXXX");

  if ((tempFileFD = mkstemp (tempFileName)) < 0)
    {
#ifdef DGDEBUG
      std::cout << "VirusScanner could not create temp file " << tempFileName << std::endl;
#endif

      // maybe the directory has been deleted?
      // (recreate it and retry)
      if (mkdir (o.download_dir.c_str (), TEMPDIR_MASK) == -1)
        {
          if (errno != EEXIST)
            {
              syslog (LOG_ERR, "Error: %s", "cannot recreate dgav temporary directory.");

              throw runtime_error (string ("Error re-creating dgav temporary directory: ") + strerror (errno));
            }
        }

      // and retry
      strcpy (tempFileName, o.download_dir.c_str ());
      strcat (tempFileName, "/tfXXXXXX");

      if ((tempFileFD = mkstemp (tempFileName)) < 0)
        {
          syslog (LOG_ERR, "Error: %s", "cannot create dgav temporary file.");

          throw runtime_error (string ("Error creating dgav temporary file: ") + strerror (errno));
        }
#ifdef DGDEBUG
      else
        {
      std::cout << "TEMPFILENAME: " << tempFileName << std::endl;
	}
#endif	
    }
#ifdef DGDEBUG
    else
      {
        std::cout << "TEMPFILENAME: " << tempFileName << std::endl;
      }
#endif	

  // Defines append mode to temp file
  // This provides that new writes *always* at the end of file which
  // saves moving file pointer to end before writing.
  if (fcntl (tempFileFD, F_SETFL, O_APPEND) < 0)
    {
      unlink (tempFileName);
      syslog (LOG_ERR, "Error: %s", "cannot define append mode to dgav temporary file.");

      throw runtime_error (string ("Error defining append mode to dgav temporary file: ") + strerror (errno));
    }

#ifdef __WITH_GRP_ACCESS_TEMP
  if ((fchmod (tempFileFD, S_IRWXU | S_IRGRP)) < 0)
    {
      unlink (tempFileName);
      syslog (LOG_ERR, "Error: %s", "cannot define access to dgav temporary file.");
      throw runtime_error (string ("Error defining access to dgav temporary file: ") + strerror (errno));
    }
#endif
}

void
VirusScanner::createTempFile (const char *_buffer, const int _len)
{

  try
  {
    // create new temp file
    createTempFile ();
    // append data to it
    FileBuffer fb (tempFileFD);
    fb.doAppend (_buffer, _len);
  } catch (exception & e)
  {
    // make sure we don't leave temp file back
    unlink (tempFileName);
  }
}

bool
VirusScanner::out (Socket * sock, char *block, int size)
throw ()
{

  // exceptions on timeout or error
  (*sock).readyForOutput (timeout);
  // need exception or something for a bad write
  if (!(*sock).writeToSocket (block, size, 0, timeout))
    {
#ifdef DGDEBUG
      std::cout << "Error sending data to socket" << std::endl;
#endif
      return false;
    }                           // write the data block out to the stream

  return true;
}

void
VirusScanner::scan (Socket * proxysock, Socket * peerconn, String url, string username, string clientip, int filtergroup, string location, int reporting_level, HTTPHeader * _docheader, bool dlmgr, int scantype)
{

  String Html;
  TrickleHandler *th = new TrickleHandler (MAX_BUF, SIZE, tempFileFD, _docheader, dlmgr);
  file_length = th->getFileLength ();
#ifdef DGDEBUG
  std::cout << "Scanning file: '" << tempFileName << "' for user '" << username << "'..." << std::endl;
#endif
  if (dlmgr)
    {
#ifdef DGDEBUG
      std::cout << "*** Adding final text to dlmgr" << std::endl;
#endif
      Html = "<script language='javascript'>";
      Html += "document.getElementById('operation').value='Scanning file...';";
      Html += "document.getElementById('stats').value='Download complete';</script>\r\n";
      Html += "<noscript>Download finished</noscript>\r\n";
      Html += "<!--force flush -->\r\n";
      peerconn->readyForOutput (timeout);
      peerconn->writeString (Html.toCharArray ());
    }

  // check wether we need to do fork()'ed scanning or not
  if (file_length < o.fork_scan_length)
    {
      // simple file scan
      if (file_length > 0)
        {
#ifdef DGDEBUG
          std::cout << "Starting file scanning..." << std::endl;
          system ("date");
#endif
          infected = avEngine->scanFile (tempFileName);
        }
      else
        {
#ifdef DGDEBUG
          std::cout << "Scanning skipped since file_length is zero..." << std::endl;
#endif
        }
    }
  else
    {
      // fork() child & scan/trickle
#ifdef DGDEBUG
      std::cout << "Starting fork()'ed file scanning..." << std::endl;
      system ("date");
#endif
      int mypipe[2], child_pid = 0;
      pipe (mypipe);
      if ((child_pid = fork ()) > 0)
        {
          // parent
          // setup continue-trickle (Neg1Trickle)
          th->prepareTrickle (*proxysock, *peerconn, trickle_pos);
          int pipeFD = 0, child_info = 0;
          close (mypipe[1]);
          pipeFD = mypipe[0];
#ifdef DGDEBUG
          std::cout << "parent reading pipe" << std::endl;
#endif
          char c = 0;
          int rc = 0;
          fd_set fds;
          struct timeval tv;
          string vname;
          // set our fd to non-blocking
          fcntl (pipeFD, F_SETFL, O_NONBLOCK);
          while (true)
            {
              FD_ZERO (&fds);
              FD_SET (pipeFD, &fds);
              // trickle interval
              tv.tv_sec = tv.tv_usec = 3;
              rc = select (pipeFD + 1, &fds, NULL, NULL, &tv);
              if (rc < 0)
                {
#ifdef DGDEBUG
                  std::cout << "select returned -1 -> something is went wrong" << std::endl;
#endif
                  exit (10);
                }

              if (FD_ISSET (pipeFD, &fds))
                {
                  int md = 0;
                  // ok there is data for us
                  while ((read (pipeFD, &c, 1) > 0))
                    {
                      if (md == 0)
                        {
                          switch (c)
                            {
                            case '1':  // ok
                              infected = VirusEngine::AV_CLEAN;
                              break;
                            case '2':  // virus
                              infected = VirusEngine::AV_VIRUS;
                              break;
                            default:   // fail
                              infected = VirusEngine::AV_FAIL;
                            }
                        }
                      if (md > 2)
                        {
                          if (c != '\n')
                            {
                              vname += c;
                            }
                          else
                            {
                              break;
                            }
                        }
                      md++;
                    }

                  avEngine->setVirusName (vname.c_str ());
                  break;
                }
              else
                {
#ifdef DGDEBUG
                  std::cout << "parent trickle data" << std::endl;
#endif
                  th->doTrickle (*peerconn);
                }
            }
          close (pipeFD);
#ifdef DGDEBUG
          std::cout << "parent waiting" << std::endl;
#endif
          wait (&child_info);   /* wait for child */
#ifdef DGDEBUG
          std::cout << "parent done" << std::endl;
#endif
          // update trickle_pos
          trickle_pos = th->getTricklePos ();
        }
      else
        {
          // child
          int pipeFD = 0;
          close (mypipe[0]);
          pipeFD = mypipe[1];
#ifdef DGDEBUG
          std::cout << "child starts av scan" << std::endl;
          // enable this sleep in order to test the parent trickle stuff ...
          // sleep(15);
#endif
          infected = avEngine->scanFile (tempFileName);
#ifdef DGDEBUG
          std::cout << "child scan done" << std::endl;
          std::cout << "child infected=" << infected << std::endl;
#endif
          switch (infected)
            {
            case VirusEngine::AV_VIRUS:
              write (pipeFD, "2\n", 2);
              write (pipeFD, avEngine->getVirusName (), strlen (avEngine->getVirusName ()));
              write (pipeFD, "\n", 1);
              break;
            case VirusEngine::AV_CLEAN:
              write (pipeFD, "1\n", 2);
              break;
            default:
              // fail
              write (pipeFD, "0\n", 2);
              write (pipeFD, avEngine->getErrString (), strlen (avEngine->getErrString ()));
              write (pipeFD, "\n", 1);
            }
          close (pipeFD);
#ifdef DGDEBUG
          std::cout << "child done" << std::endl;
#endif
          _exit (0);
        }
    }

#ifdef DGDEBUG
  system ("date");
  std::cout << "End of file scanning" << std::endl;
  std::cout << "VirusScanner - isInfected = " << infected << std::endl;
#endif
  if (infected == VirusEngine::AV_CLEAN)
    {
      if (dlmgr)
        {
          Html = "<script language='javascript'>";
          Html += "document.getElementById('operation').value='Scan complete';";
          Html += "document.getElementById('stats').value='Download complete';</script>\r\n";
          Html += "<noscript>File download and scan finished</noscript>\r\n";
          Html += "<!--force flush -->\r\n";
          Html += "<br><center><font face=Arial size=3 color=black><b>";
          Html += "Click on the link below to download your clean file:<br><a href=\"";
          Html += url;
          Html += "&cleanpath==";
          Html += tempFileName;
          Html += "\">";
          Html += url.toCharArray ();
          Html += "</a></b></font></center>\r\n</form></body></html>";
          peerconn->writeString (Html.toCharArray ());
        }
      else
        {
#ifdef DGDEBUG
          std::cout << "sending data from trickle_pos = '" << trickle_pos << "', length = '" << file_length << std::endl;
#endif
          th->doReadAll (*peerconn, trickle_pos);
          unlink (tempFileName);
        }
    }
  else if (infected == VirusEngine::AV_VIRUS)
    {
#ifdef DGDEBUG
      std::cout << "VirusScanner - VirusName = " << avEngine->getVirusName () << std::endl;
#endif
      // send the browser an error html document stating that the file was infected with virus.
      // Added feature to use dansguardian.pl
      try
      {
        // sending HTTP header first
        if (dlmgr)
          {
            Html = "<script language='javascript'>";
            Html += "document.getElementById('header').style.display='none';</script>\r\n";
            Html += "</a></b></font></center>\r\n</form></div></body></html>";
            peerconn->writeString (Html.toCharArray ());
          }
        else
          {
            peerconn->writeString ("HTTP/1.0 200 OK\nContent-Type: text/html\n\n");
          }

        if (reporting_level == 3)
          {
            String msg;
            msg = "Virus ";
            msg += avEngine->getVirusName ();
            msg += " found";
            o.html_template.display (peerconn, url.toCharArray (), msg, o.language_list.getTranslation (1100), username.c_str (), clientip.c_str (), String (filtergroup + 1), "");
          }
        else
          {
            Html = "<html><head><script language=JavaScript>location.href=\"";
            Html += location.c_str ();
            Html += "?USER==";
            Html += username.c_str ();
            Html += "::REASON==Virus%20'";
            Html += avEngine->getVirusName ();
            Html += "'%20found::URL==";
            Html += url;
            Html += "\"</script></head></html>";
            peerconn->writeString (Html.toCharArray ());
          }

        if (o.notify)
          {
#ifdef DGDEBUG
            std::cout << "Sending email..." << std::endl;
#endif
            sendmail (username, url, clientip);
          }
      }
      catch (exception & e)
      {
#ifdef DGDEBUG
        std::cout << "Error notifying virus found by dgav." << std::endl;
        std::cout << e.what () << std::endl;
#endif
        syslog (LOG_ERR, "Error: %s", "cannot notify virus found by dgav.");
        syslog (LOG_ERR, "%s", e.what ());
      }

#ifdef DGDEBUG
      std::cout << "VirusName: " << avEngine->getVirusName () << std::endl;
#endif
      unlink (tempFileName);
    }
  else
    {
      Html = "<html><head><title>DansGuardian - Antivirus Error</title></head>";
      Html += "<body><center><h1>DansGuardian Antivirus Patch - Error during scanning</h1>";
      Html += "Error message: '";
      Html += avEngine->getErrString ();
      Html += "'</center></body></html>";
      try
      {
        peerconn->writeString (Html.toCharArray ());
      }
      catch (exception & e)
      {
#ifdef DGDEBUG
        std::cout << "Error scanning dgav temporary file " << tempFileName << std::endl;
        std::cout << e.what () << std::endl;
#endif
        syslog (LOG_ERR, "Error: scanning dgav temporary file '%s'.", tempFileName);
        syslog (LOG_ERR, "%s", e.what ());
      }
    }

  if (!dlmgr)
    {
      unlink (tempFileName);
    }
}

void
VirusScanner::sendFile (Socket * peerconn, HTTPHeader * _docheader, char *tempFileName)
{

  TrickleHandler *th = new TrickleHandler (MAX_BUF, SIZE, 0, _docheader, 1);
  // send the remaining data to client
  if ((tempFileFD = th->doOpen (tempFileName)) > 0)
    {
      th->doReadAll (*peerconn, 0);
      unlink (tempFileName);
    }

  delete th;
}

void
VirusScanner::sendmail (string username, String url, string clientip)
{
  smtp_session_t session;
  smtp_message_t message;
  smtp_recipient_t recipient;
  char *host = (char *) o.email_server.c_str ();
  string from = "\"DansGuardian Anti-Virus\" <dgvirus@";
  from += o.email_domain;
  from += ">";
  string return_path = "dgvirus@";
  return_path += o.email_domain;
  char *subject = "Virus Found by DansGuardian Anti-Virus";
  // we must delete everything until '\' and including '\' for NTLM usernames,
  // so that domain\user@domain.com becomes user@domain.com:
  string::size_type pos = username.find ("\\", 0);
  if (pos != string::npos)
    {
      username.erase (0, pos + 1);
    }

  session = smtp_create_session ();
  message = smtp_add_message (session);
  // Set the host running the SMTP server.  LibESMTP has a default port
  // number of 587, however this is not widely deployed so the port
  // is specified as 25 along with the default MTA host.
  smtp_set_server (session, host);
  // Set the reverse path for the mail envelope.  (NULL is ok)
  smtp_set_reverse_path (message, return_path.c_str ());
  // RFC 2822 doesn't require recipient headers but a To: header would
  // be nice to have if not present.
  smtp_set_header (message, "To", NULL, NULL);
  // Set the Subject: header.  For no reason, we want the supplied subject
  // to override any subject line in the message headers.
  if (subject != NULL)
    {
      smtp_set_header (message, "Subject", subject);
      smtp_set_header_option (message, "Subject", Hdr_OVERRIDE, 1);
    }

  string str = "MIME-Version: 1.0\r\n";
  str += "Content-Type: text/plain; charset=iso-8859-1\r\n";
  str += "Content-Transfer-Encoding: 7bit\r\n";
  str += "From: ";
  str += from;
  str += "\r\n\r\n";
  str += "Virus        : ";
  str += avEngine->getVirusName ();
  str += "\r\n";
  str += "User         : ";
  str += username;
  str += "\r\nURL          : ";
  str += url.toCharArray ();
  str += "\r\nUser IP      : ";
  str += clientip;
  smtp_set_message_str (message, (char *) str.c_str ());
  if (o.notify > 1)
    {
      recipient = smtp_add_recipient (message, o.postmaster.c_str ());
    }

  if (o.notify != 2)
    {
      if (username != "-")
        {
          recipient = smtp_add_recipient (message, (username + "@" + o.email_domain).c_str ());
        }
    }

  // Initiate a connection to the SMTP server and transfer the message.
  if (!smtp_start_session (session))
    {
      char buf[128];
      syslog (LOG_ERR, "SMTP server problem: %s", smtp_strerror (smtp_errno (), buf, sizeof buf));
    }

  smtp_destroy_session (session);
}

void
VirusScanner::cleanUp (void)
{
  int rc = 0;
  int i = 0;
  char *fileName = new char[256];
  struct dirent **dirlist;
  struct stat filestat;
  time_t rightnow;
  // Grab all files in the temporary download dir
  if ((rc = scandir (o.download_dir.c_str (), &dirlist, NULL, NULL)) > 0)
    {
      // Check for each file,...
      for (i = 0; i < rc; i++)
        {
          // ...unless it is '.' and '..' pointers,...
          if ((strcmp (dirlist[i]->d_name, ".") != 0) && 
              (strcmp (dirlist[i]->d_name, "..") != 0) &&
              (strlen(dirlist[i]->d_name) < 256))
            {
              // ...if its last modified time...
              strcpy (fileName, o.download_dir.c_str ());
              strcat (fileName, dirlist[i]->d_name);
              stat (fileName, &filestat);
              time (&rightnow);
              // ... was 1 hour ago.
              if ((rightnow - filestat.st_mtime) > TEMPDELAY)
                {
                  // Delete file left behind by download manager

#ifdef DGDEBUG
                  std::cout << "*** Unlinking file: " << fileName << std::endl;
#endif
                  unlink (fileName);
                }
            }
        }

      free (dirlist);
    }
}
