/* _unix.h  94.12.17
 * Copyright 1983-1993  Albert Davis
 * Special stuff for all unix systems
 */
/* constants related to memory size, word size, etc */
#define SEGSIZ		9000000
#define	BUFLEN		256
#define BIGBUFLEN	2048
#define MAXWIDTH	512
#define PROBECOUNT	500
#define MAXEVENTCOUNT	2000
#define SAVEITERATIONS	2
#define SAVEBACKTIME	4
#define DCNEST		4
#define RECURSE		8
#define LABELEN		8
#define MAXHANDLE	((int)((CHAR_BIT*sizeof(int))-1))

/* file names, etc. */
#define BEGINDIR	""
#define DIRSEP		"/"
#define	ENDDIR		"/"
#define PATHSEP		':'
#define SYSTEMSTARTFILE	"acs.rc"
#define SYSTEMSTARTPATH	getenv("PATH")
#define USERSTARTFILE	".acsrc"
#define	USERSTARTPATH	getenv("HOME")
#define EDITFILE   	"/tmp/EXXXXXX"
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define HELPFILE    	"acs.hlp"
#define HELPPATH	getenv("PATH")

/* standard collection of includes */
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

/* non-standard collection of includes */
#if defined(NEXT)
#   include <libc.h>
#   include <memory.h>
#   include <unistd.h>
#elif defined(OS2)  ||  defined(__FreeBSD__)
#   include <memory.h>
#   include <unistd.h>
#   include <sys/file.h>
#   include <sys/time.h>
#   include <sys/resource.h>
#else		/* assume for anything else */
#   include <memory.h>
#   include <unistd.h>
#   include <values.h>
#   include <sys/file.h>
#   include <sys/time.h>
#   include <sys/resource.h>
#endif

/* stuff not preperly defined in the supplied header files. */
#if defined(NEXT)
   #if !defined(__cplusplus)
      #define getcwd(a,b)	getwd(a)
   #else
      extern "C" char *getcwd(char *,size_t);
   #endif
#elif defined(__FreeBSD__)
   #define MAXDOUBLE       1.79769313486231570E+308
#elif defined(__386BSD__)
   char *getenv(const char*);
   char *mktemp(char*);
   #define MAXDOUBLE       1.797693134862315E+308
#elif defined(OS2)
   #define MAXDOUBLE       1.797693134862315E+308
   double os2_floor(double);
   #define floor(a) os2_floor(a)
#elif defined(RS6000)
   #undef GOOD
   #define const
   char *mktemp(char*);
   int  getrusage(int,struct rusage*);
#elif defined(SUN)
   int  _filbuf();
   int  system(const char*);
   int  vsprintf();
   #if !defined(__cplusplus)
      int  getrusage(int,struct rusage*);
      char *mktemp(char*);
   #else
      extern "C" int  getrusage(int,struct rusage*);
      extern "C" char *mktemp(char*);
   #endif
#elif defined(HPPA)
   #include <sys/syscall.h>
   #define getrusage(a, b)  syscall(SYS_GETRUSAGE, a, b)
   char *mktemp(char*);
#endif
