/* declare  94.12.09
 * Copyright 1983-1992   Albert Davis
 * declarations for type checking
 */
#ifndef AC_H
#define ac_t void
#endif
#ifndef BRANCH_H
#define branch_t void
#define functions_t void
#define generic_t void
#define node_t int
#endif
#ifndef DC_H
#define dc_t void
#endif
#ifndef PROBH_H
#define probe_t void
#define xprobe_t void
#endif
#ifndef TR_H
#define transient_t void
#define fourier_t void
#endif

/* compiler */	void	  initialize_io(void);
		void	  setup_traps(void);
		void	  shell(void);
/* ac       */  void	  cmd_ac(const char*,int*);
/* ac_fill  */  void	  ac_fill_rl(branch_t*);
/* ac_fix   */	complex_t acfix(branch_t*);
/* ac_load  */	void	  acloadsource(const branch_t*);
		void	  acloadpassive(const branch_t*);
	        void      acloadpassivereal(const branch_t*);
	        void      acloadpassiveimaginary(const branch_t*);
	        void      acloadactive(const branch_t*);
		void	  acloadactivereverse(const branch_t*);
		void	  acloadmutual(const branch_t*);
/* ac_setup */	void	  ac_setup(const char*,int*,ac_t*);
/* ac_z     */	complex_t acz(node_t,node_t,complex_t);
/* allocate */	void	  allocate(int);
/* argparse */	int	  argparse(const char*,int*,int,...);
/* array    */	double	  *re(int,int);
		double	  *im(int,int);
/* branch   */	branch_t  *firstbranch_dev(void);
		branch_t  *firstbranch_all(void);
		branch_t  *nextbranch_dev(const branch_t*);
		branch_t  *nextbranch_all(const branch_t*);
		branch_t  *lastbranch_dev(void);
		branch_t  *lastbranch_all(void);
		branch_t  *insertbranch(branch_t*);
		int	  deletebranch(branch_t**);
/* cmath    */	complex_t cxadd(double,double,double,double);
		complex_t cxsub(double,double,double,double);
		complex_t cxmul(double,double,double,double);
		complex_t cxdiv(double,double,double,double);
		complex_t cxflip(double,double);
		complex_t cadd(complex_t,complex_t);
		complex_t csub(complex_t,complex_t);
		complex_t cmul(complex_t,complex_t);
		complex_t ccmul(complex_t,complex_t);
		complex_t cdiv(complex_t,complex_t);
		complex_t cflip(complex_t);
/* crtset   */	void	  cmd_crtset(const char*,int*);
		int	  testcrt(void);
		struct graph *initcrt(void);
/* ctostr   */	char	  *ctostr(const char*,int*,char*,int,const char*);
/* ctof     */	double	  ctof(const char*,int*);
		double	  x10(int);
/* ctoi     */	int	  ctoi(const char*,int*);
		unsigned  ctou(const char*,int*);
		int	  ctoo(const char*,int*);
		int	  ctox(const char*,int*);
/* dc       */	void	  cmd_dc(const char*,int*);
		void	  cmd_op(const char*,int*);
/* dc_setup */	void	  dc_finish(void);
		void	  op_setup(const char*,int*,dc_t*);
		void	  dc_setup(const char*,int*,dc_t*);
/* dc_sweep */	void	  dc_sweep(dc_t*);
/* dealloc  */	void	  dealloc(int);
/* delete   */	void	  cmd_clear(void);
		void	  cmd_delete(const char*,int*);
/* dev	    */	branch_t* create_branch(const functions_t*);
		branch_t* create_std(const functions_t*);
		branch_t* copy_branch(const branch_t*);
		branch_t* copy_std(const branch_t*);
		void	parse_branch(branch_t*,const char*,int*);
		void	  parse_std(branch_t*,const char*,int*);
		void	    parselabel(branch_t*,const char*,int*);
		void	      parselabel_raw(char*,const char*,int*);
		void	print_branch(const branch_t*,int,int);
		void	  print_std(const branch_t*,int,int);
		char*	    printlabel(const branch_t*,int);
		void	expand_branch(branch_t*);
		void	  expandgeneric(branch_t*,const branch_t*);
		double	probe_branch(const branch_t*,const char*);
		double	  probe_std(const branch_t*,const char*);
		double	  tr_probe_std(const branch_t*,const char*);
		double	  ac_probe_std(const branch_t*,const char*);
		xprobe_t  xprobe_std(const branch_t*,const char*);
		int	dotr_branch(branch_t*);
		void	untr_branch(branch_t*);
		void	doac_branch(branch_t*);
		double	tr_review_branch(branch_t*);
/* d_*      */	/* not declared here, no global functions */
/* d_subckt */	void	  cmd_ends(const char*,int*);
		void      expandsubckt(branch_t*,const char*);
/* error    */	void	  stubmess(void);
		void	  syntax_check(const char*,int*,int);
		void	  syntax_msg(const char*,int*,int);
		void	  error(int,const char*,...);
		void	  cmd_pause(const char*,int*);
		void	  cmd_comment(const char*,int*);
/* expr     */	void	  parseexpr(branch_t*,const char*,int*);
		void	  printexpr(const branch_t*,int);
/* fanout   */	void	  cmd_fanout(const char*,int*);
/* fft      */	void	  fft(complex_t*,int,int);
/* file     */	void	  cmd_log(const char*,int*);
		void	  cmd_file(const char*,int*);
		char	  *getcmd(const char*,char*,int);
/* findbr   */	branch_t  *findbranch(const char*,int*,branch_t*,branch_t*);
	 	branch_t  *findbranch_samescope(const char*,branch_t*);
	  const branch_t  *findbranch_sametype(const char*,const branch_t*);
		int	  wmatch(const char*,const char*);
/* findfile */	char	  *findfile(const char*, const char*, int);
/* fourier  */	void	  foinit(long);
		void	  fonext(void);
		void	  fosave(double);
		void	  foout(double,double,double);
/* ftos     */	char	  *ftos(double,const char*,int,int);
/* generat  */	double	  gen(void);
		void	  cmd_generator(const char*,int*);
/* getckt   */	void	  cmd_build(const char*,int*);
		void	  cmd_get(const char*,int*);
		void	  cmd_merge(const char*,int*);
		void	  cmd_run(const char*,int*);
/* getlines */	char	  *getlines(char*,int,FILE*);
/* help     */	void	  cmd_help(const char*,int*);
/* insert   */	void	  cmd_insert(const char*,int*);
/* ipow     */	double	  ipow(double,int);
/* isfloat  */	int	  isfloat(int);
/* isterm   */	int	  isterm(int,const char*);
/* itos     */	char	  *itos(int,char*,int,int);
/* line     */	void	  initgraph(struct graph*);
 		void	  stext(int,int,const char*,int);
		void	  setpixel(int,int,int);
		void	  box(int,int,int,int,int);
		void	  line(int,int,int,int,int);
/* list     */	void	  cmd_list(const char*,int*);
		void	  cmd_save(const char*,int*);
/* main     */	int	  main(int,const char*[]);
		void	  cmdproc(const char*);
/* match    */	int	  pmatch(const char*,int*,const char*);
		int	  match(const char*,const char*);
		void	  setmatch(const char*,int*);
		int	  rematch(const char*);
/* modify   */	void	  cmd_modify(const char*,int*);
		void	  cmd_restore(void);
		void	  cmd_fault(const char*,int*);
		void	  cmd_unfault(void);
/* nodes    */	int	  newnode_subckt(void);
		int	  newnode_model(void);
		int	  parsenodes(branch_t*,const char*,int*);
		void	  printnodes(const branch_t*,int);
/* nodeset  */	void	  cmd_ic(const char*,int*);
		void	  cmd_nodeset(const char*,int*);
/* options  */	void	  cmd_options(const char*,int*);
/* outset   */	void	  initio(int,FILE*);
		void	  decipher(char*);
		void	  outreset(void);
		int	  outset(const char*,int*,const char*,const char*);
/* outtext  */	void	  mtab(int,int);
		void	  mprintf(int,const char*,...);
		void	  mputs(const char*,int);
		void	  mputc(int,int);
/* plot     */	void	  plottr(double);
		int	  plopen(int,double,double,int);
		void	  plclose(void);
		void	  plclear(void);
		void	  pllocate(void);
/* plot*    */	/* not declared here */
/* polar    */	complex_t polartocomplex(polar_t);
		polar_t	  complextopolar(complex_t);
		double	  real(double,double);
		double	  imag(double,double);
		double	  phase(double,double);
		double	  db(double);
/* prob_nod */	double	  probe_node(probe_t);
/* probe    */	void	  cmd_alarm(const char*,int*);
		void	  cmd_plot(const char*,int*);
		void	  cmd_print(const char*,int*);
/* probe2   */	char	  *probename(probe_t);
/* probe3   */	int	  count_probes(const probe_t*);
/* qfree    */	void	  qfree(void**);
/* quit     */	void	  cmd_quit(const char*,int*);
/* skiparg  */	void	  skiparg(const char*,int*);
/* skipbl   */	void	  skipbl(const char*,int*);
		int	  skipcom(const char*,int*);
		int	  skiplparen(const char*,int*);
		int	  skiprparen(const char*,int*);
		int	  skipequal(const char*,int*);
/* solve    */	void	  solve(void);
/* status   */	void	  cmd_status(void);
/* stubs    */	void	  cmd_alter(const char*,int*);
		void	  cmd_disto(const char*,int*);
		void	  cmd_model(const char*,int*);
		void	  cmd_noise(const char*,int*);
		void	  cmd_sens(const char*,int*);
		void	  cmd_subckt(const char*,int*);
		void	  cmd_temp(const char*,int*);
		void	  cmd_tf(const char*,int*);
/* sweep    */	void	  cmd_sweep(const char*,int*);
/* syscall  */	void	  cmd_edit(const char*,int*);
		void	  cmd_system(const char*,int*);
		void	  cmd_chdir(const char*,int*);
#ifdef STATUS_H
/* time_it  */	void	  time_fullreset(struct time_s*);
		void	  time_reset(struct time_s*);
		void	  time_zstart(struct time_s*);
		void	  time_start(struct time_s*);
		void	  time_stop(struct time_s*);
		void	  time_check(struct time_s*);
#endif
/* title    */	void	  cmd_title(const char*,int*);
/* tr       */	void	  cmd_tr(const char*,int*);
		void	  cmd_fourier(const char*,int*);
/* tr_adv   */	void	  trsetup(branch_t*);
/* tr_clear */	void	  trkeep(void);
		void	  trestor(void);
		void	  cmd_mark(void);
		void	  cmd_unmark(void);
/* tr_conck */	int	  conv_check(const branch_t*);
/* tr_fill  */	int	  tr_fill(void);
		int	  tr_fill_rl(branch_t*);
		int	  tr_fill_ll(branch_t**);
		void	  tr_unfill_rl(branch_t*);
/* tr_load  */	void	  trloadsource(branch_t*);
		void	  trloadpassive(branch_t*);
		void	  trloadactive(branch_t*);
		void	  trloadactivereverse(branch_t*);
		void	  trloadmutual(branch_t*);
		void	  unloadsource(branch_t*);
		void	  unloadpassive(branch_t*);
		void	  unloadactive(branch_t*);
		void	  unloadactivereverse(branch_t*);
		void	  unloadmutual(branch_t*);
/* tr_fix   */	void	  trfix1(branch_t*);
		void	  trfix0(branch_t*);
/* tr_out   */	void	  dc_out(const dc_t*);
		void	  tr_out(const transient_t*);
		void	  tr_head(double,double,int,const char*);
		void	  tr_print(double);
		void	  tr_alarm(void);
/* tr_probe */	double	  trprobe(probe_t);
/* tr_reviw */	void	  tr_review(transient_t*);
		double	  tr_review_rl(branch_t*);
		double	  tr_review_ll(branch_t**);
/* tr_setup */	void	  tr_setup(const char*,int*,transient_t*);
		void	  fo_setup(const char*,int*,fourier_t*);
/* tr_solve */	int	  tr_solve(int,int);
/* tr_sweep */	void	  tr_sweep(transient_t*);
		void	  new_event(double);
/* tr_volts */	double	  dc_volts(const node_t*,const node_t*);
		double	  tr_volts(const node_t*,const node_t*);
		double	  tr_volts_limited(const node_t*,const node_t*);
		double	  tr_volts_t1(const node_t*,const node_t*);
		double	  logicval(const node_t*);
/* tr_z     */	double	  trz(node_t,node_t,double);
/* trim     */	char	  *trim(char*);
/* utos     */	char	  *utos(unsigned,char*,int);
/* xopen    */	void	  xclose(FILE**);
		FILE	  *xopen(const char*,int*,const char*,const char*);
/* xsolve   */	void	  xsolve(void);
		void	  xlu(void);
#ifndef AC_H
#undef ac_t
#endif
#ifndef BRANCH_H
#undef branch_t
#undef functions_t
#undef generic_t
#undef node_t
#endif
#ifndef DC_H
#undef dc_t
#endif
#ifndef PROBH_H
#undef probe_t
#endif
#ifndef TR_H
#undef transient_t
#undef fourier_t
#endif
