/* insert.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * insert command
 * insert new nodes
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "mode.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_insert(const char*, int*);
/*--------------------------------------------------------------------------*/
extern const struct status stats;
/*--------------------------------------------------------------------------*/
void cmd_insert(const char *cmd, int *cnt)
{
 int nod;		/* first node number to insert			*/
 int ncnt;		/* how many nodes to insert			*/
 branch_t *brh;		/* branch pointer, for loop			*/
 branch_t *stop;	/* stop loop					*/

 dealloc(YES);
 nod = ctoi(cmd,cnt);			/* get args..			*/
 if (nod <= 0)
    error(bERROR, "insert which node?\n");
 if (nod > stats.total_nodes)
    error(bERROR, "%u nodes\n", stats.total_nodes);

 ncnt = ctoi(cmd,cnt);
 if (ncnt <= 0)
    ncnt = 1;

 stop = brh = firstbranch_dev();
 do {
    int ii;
    for (ii = 0;  brh->n[ii].e != INVALIDNODE;  ii++){
       if (brh->n[ii].e >= nod)		/* move them up			*/
	  brh->n[ii].e += ncnt;
    }
 } while (brh = nextbranch_dev(brh),  brh != stop);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
