/* nodestat.h  93.09.17
 * Copyright 1983-1992   Albert Davis
 * simulation status at each node
 */
 
#define	qBAD	 (0)
#define qGOOD	 (opt.transits)

struct nodestat {
    const struct lmod *family;	/* logic family */
    int 	diter;		/* iteration of last update - digital */
    int 	aiter;		/* iteration of last update - analog */
    double	finaltime;	/* time logic transition attains final state */
    double	lastchange;	/* time of last change */
    double	dt;		/* time diff, for conversion */
    unsigned	lv0:1,		/* old, current value */
		lv1:1,		/* new, future value */
		ls0:1,		/* old, current strength */
		ls1:1,		/* new, future strength */

		nodemode:2,	/* simulation mode */
		quality:4,	/* quality of digital mode */

		isanalog:1,	/* analog info exists */
		needslu:1;	/* changed.  LU decomposition needed */
    int		needsanalog;	/* analog info requested (count/flag) */
    const char*	failuremode;
};

struct nodestuff {
    double	*i;		/* dc-tran current (i) vector		*/
    double	*v0;		/* dc-tran voltage, new			*/
    double	*vt1;		/* dc-tran voltage, 1 time ago		*/
    double	*fw;		/* dc-tran fwd sub intermediate values	*/
    double	*vdc;		/* saved dc voltages			*/
    double	*acx;		/* ac real part				*/
    double	*acy;		/* ac imaginary part			*/
    int		*nm;		/* node map (external to internal)	*/
    int		*basnode;	/* lowest node connected to this node	*/
};
