/* Copyright (c) 1994 by Sanjay Ghemawat */
#include <stdio.h>
#include <string.h>

#include "collect.h"
#include "ical.h"
#include "cal_tcl.h"
#include "item_tcl.h"

#include "arrays.h"
#include "calfile.h"
#include "calendar.h"
#include "dateset.h"
#include "item.h"

implementArray(ItemList,Item_Tcl*)
implementArray(Occurrences,Occurrence)

void collect_items(ItemList& list) {
    Calendar_Tcl* cal = calendar_instance;
    Calendar* mainCalendar = cal->main->GetCalendar();

    list.clear();
    for (int i = 0; i <= cal->includes->size(); i++) {
	Calendar* calendar = ((i >= cal->includes->size())
			      ? mainCalendar
			      : cal->includes->slot(i)->GetCalendar()
			      );

	for (int j = 0; j < calendar->Size(); j++) {
	    Item_Tcl* item = Item_Tcl::find(calendar->Get(j));
	    if (item == 0) continue;

	    // Ignore hidden items
	    if (mainCalendar->Hidden(item->value()->GetUid())) continue;

	    list.append(item);
	}
    }
}

void collect_occurrences(Occurrences& list, Date s, Date f, int e) {
    ItemList items;
    collect_items(items);

    list.clear();
    for (int i = 0; i < items.size(); i++) {
	Item_Tcl* item = items[i];

	Date d = s - 1;
	Date limit = f;
	if (e) limit += item->value()->GetRemindStart();

	while (item->value()->next(d, d) && (d <= limit)) {
	    Occurrence o;
	    o.item = item;
	    o.date = d;
	    list.append(o);
	}
    }
}

static int occurs_before(Occurrence const& x, Occurrence const& y) {
    if (x.date < y.date) return 1;
    if (x.date > y.date) return 0;

    Appointment* xa = x.item->value()->AsAppointment();
    Appointment* ya = y.item->value()->AsAppointment();

    int xs = (xa == 0) ? -1 : xa->GetStart();
    int ys = (ya == 0) ? -1 : ya->GetStart();

    return (xs < ys);
}

void sort_occurrences(Occurrences& list) {
    int i = 0;
    while (i < list.size()) {
	/* Find min element in list[i..] */
	int minIndex = i;

	for (int j = i+1; j < list.size(); j++) {
	    if (occurs_before(list[j], list[minIndex])) {
		minIndex = j;
	    }
	}

	Occurrence temp;
	temp = list[i];
	list[i] = list[minIndex];
	list[minIndex] = temp;

	i++;
    }
}

void trigger(Tcl_Interp* tcl, char const* ttype, char const* id) {
    charArray buffer;
    char const* cmd = "trigger fire ";

    buffer.concat(cmd, strlen(cmd));
    buffer.concat(ttype, strlen(ttype));

    if (id != 0) {
	buffer.append(' ');
	buffer.concat(id, strlen(id));
    }

    buffer.append('\0');

    if (Tcl_Eval(tcl, buffer.as_pointer()) == TCL_ERROR)
	fprintf(stderr, "ical: trigger error: %s\n", tcl->result);

    buffer.clear();
}
