#!/bin/sh
#
# this shell script produces the debian source package
# it requires that that the debian source be in $PACKAGE
# and that the original pre-debian source be in $PACKAGE.orig
# it assumes that this script is run from inside $PACKAGE
#
DIR=`pwd`
PACKAGE=`basename $DIR`
#
# check for the original package
#
if [ ! -d ../$PACKAGE.orig ]
then
    echo ERROR:  $PACKAGE.orig not found
    exit 1
fi
#
# archive the original source package
# we want the tarfile to extract it into $PACKAGE
#
cd ..                                        # get up to the parent directory
mv $PACKAGE $PACKAGE.temp.$$                 # rename the debian package
mv $PACKAGE.orig $PACKAGE                    # rename the original package
tar --create --file $PACKAGE.tar $PACKAGE    # make the tar file
mv $PACKAGE $PACKAGE.orig                    # rename the original package
mv $PACKAGE.temp.$$ $PACKAGE                 # rename the debian package
gzip -9 --force $PACKAGE.tar                 # compress the tar file
cd $PACKAGE                                  # back down to the debian directory
#
# make and gzip the diff file
#
# NOTE -- to apply the diffs
#         1.  place the original sources in $PACKAGE
#         2.  place the the patch file in the parent directory
#         3.  invoke "patch -d <patch_file" from the parent directory
#
cd ..                                        # up to the parent directory
diff --context --recursive -P $PACKAGE.orig $PACKAGE >$PACKAGE.diff
gzip -9 --force $PACKAGE.diff                # compress the diff
cd $DIR                                      # back down to the debian directory
#
# we're done
#
exit 0

