/*
 * fsm.h - Finite state machine control.
 *
 * Copyright (c) 1994, 1995 Eric Schenk.
 * All rights reserved. Please see the file LICENSE which should be
 * distributed with this software for terms of use.
 */

/* States for the control DFA */

#define STATE_DOWN 0
#define STATE_CONNECT 1
#define STATE_STOP_DIAL 2
#define STATE_KILL_DIAL 3
#define STATE_START_LINK 4
#define STATE_STOP_LINK 5
#define STATE_KILL_LINK 6
#define STATE_UP 7
#define STATE_DISCONNECT 8
#define STATE_CLOSE 9
#define STATE_RETRY 10
#define STATE_ERROR 11

/* prototypes for control DFA actions */

#ifdef 0
void open_modem __ARGS((void));
void close_modem __ARGS((void));
void redial __ARGS((void));
void int_dial __ARGS((void));
void kill_dial __ARGS((void));
void finish_dial __ARGS((void));
void fork_pppd __ARGS((void));
void down __ARGS((void));
void int_pppd __ARGS((void));
void kill_pppd __ARGS((void));
void idle_filter_init __ARGS((void));
void link_died __ARGS((void));
void link_down __ARGS((void));
void terminal_error __ARGS((void));
void disconnect __ARGS((void));
void decrement_retry __ARGS((void));
#endif
