#!/bin/sh
#
# Start or stop named
#
# Robert Leslie <rob@mars.org>

test -x /usr/sbin/named || exit 0

case "$1" in
    start)
	echo -n "Starting domain name service: named"
	start-stop-daemon --start --quiet --exec /usr/sbin/named
	echo "."	
    ;;

    stop)
	echo -n "Stopping domain name service: named"
	start-stop-daemon --stop --quiet  \
	    --pidfile /var/run/named.pid --exec /usr/sbin/named
	echo "."	
    ;;

    restart)
        $0 stop
        $0 start
    ;;
    
    reload)
	echo -n "Reloading named configuration..."
	start-stop-daemon --stop --signal 1 --quiet  \
	    --pidfile /var/run/named.pid --exec /usr/sbin/named
	echo "done." 
    ;;

    force-reload)
        $0 restart
    ;;

    *)
	echo "Usage: /etc/init.d/bind {start|stop|reload|restart|force-reload}" >&2
	exit 1
    ;;
esac

exit 0
