/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef XFERJOB_H
#define XFERJOB_H

#include "Job.h"
#include "ArgV.h"
#include "xmalloc.h"
#include "Filter.h"

#define percent(offset,size) ((offset)>(size)?100: \
				 int(float(offset)*100/(size)))

class XferJob : public SessionJob
{
protected:
   char	 *op;

   char	 *curr;

   static const int buffer_size=0x1000;
   char	 buffer[buffer_size];
   int	 in_buffer;

   int	 file_count;
   int	 failed;

   time_t start_time;
   time_t end_time;

   long	 offset;
   long	 size;

   float xfer_rate;

   bool	 got_eof;
   bool	 print_run_status;
   bool	 need_seek;
   bool	 line_buf;

   XferJob(FileAccess *f);
   ~XferJob();

   void NextFile(char *f);

   int	 TryRead(FileAccess *s);
   int	 TryWrite(FDStream *f);

public:
   long	 bytes_transferred;

   int	 Done() { return curr==0; }
   int	 ExitCode() { return failed; }

   void	 ShowRunStatus(StatusLine *);
   void	 PrintStatus(int);
   void	 SayFinal();
};

#endif /* XFERJOB_H */
