/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is named mutt_menu.h so it doesn't collide with ncurses menu.h
 */

#include "keymap.h"
#include "mutt_regex.h"

typedef struct menu_t
{
  char *title;   /* the title of this menu */
  char *help;    /* quickref for the current menu */
  void *data;    /* extra data for the current menu */
  short current; /* current entry */
  short redraw;
  short menu;    /* menu definition for keymap entries. */
  short max;     /* the number of entries in the menu */
  short offset;  /* which screen row to start the index */
  short pagelen; /* number of entries per screen */
  
  /* callback to generate an index line for the requested element */
  void (*make_entry) (char *, size_t, struct menu_t *, int);
  
  /* how to search the menu */
  int (*search) (struct menu_t *, regex_t *re, int n);

  /* the following are used only by mutt_menuLoop() */
  short top;		/* entry that is the top of the current page */
  short oldcurrent;	/* for driver use only. */
  char *searchBuf;	/* last search pattern */
  int searchDir;	/* direction of search */
} MUTTMENU;

void menu_jump (MUTTMENU *);
void menu_redraw_full (MUTTMENU *);
void menu_redraw_index (MUTTMENU *);
void menu_redraw_motion (MUTTMENU *);
void menu_redraw_current (MUTTMENU *);
void menu_first_entry (MUTTMENU *);
void menu_last_entry (MUTTMENU *);
void menu_top_page (MUTTMENU *);
void menu_bottom_page (MUTTMENU *);
void menu_middle_page (MUTTMENU *);
void menu_next_page (MUTTMENU *);
void menu_prev_page (MUTTMENU *);
void menu_next_line (MUTTMENU *);
void menu_prev_line (MUTTMENU *);

MUTTMENU *mutt_new_menu (void);
void mutt_menuDestroy (MUTTMENU **);
int mutt_menuLoop (MUTTMENU *);

/* used in both the index and pager index to make an entry. */
void index_make_entry (char *, size_t, struct menu_t *, int);
