/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Generic configuration and standard header file includes.
 * $Id: conf.h,v 1.17 1997/12/29 20:21:57 flood Exp $
 */

#ifndef __CONF_H
#define __CONF_H

#include "config.h"
/* This is no longer used, autoconf provides us with a top level
 * config.h
 */
/* #include "platform.h" */
#include "options.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <pwd.h>
#include <grp.h>

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val)>>8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif

#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr(),*strrchr();
# ifndef HAVE_MEMCPY
#  define memcpy(d,s,n) bcopy((s),(d),(n))
#  define memmove(d,s,n) bcopy((s),(d),(n))
# endif
#endif

#ifdef HAVE_BSTRING_H
# include <bstring.h>
#endif

#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif

#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif

#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#ifdef HAVE_NETINET_TCP_H
# include <netinet/tcp.h>
#endif

#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif

#if (defined(HAVE_SHADOW_H) && defined(USESHADOW))
# include <shadow.h>
#endif

#ifndef TM_IN_SYS_TIME
# include <time.h>
#endif

#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#endif

#ifdef HAVE_FNMATCH
# include <fnmatch.h>
#endif

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) ((dirent)->d_namlen)
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif

#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#ifdef HAVE_CTYPE_H
# include <ctype.h>
#endif

#ifdef HAVE_FNMATCH_H
# include <fnmatch.h>
#endif

#ifdef HAVE_UTMP_H
# include <utmp.h>
#endif

/* Solaris 2.5 needs sys/termios.h for TIOCNOTTY.  Due to complications
 * with termio.h/termios.h, prefer to include termios.h.  If not found,
 * then try termio.h
 */

#ifdef HAVE_SYS_TERMIOS_H
# include <sys/termios.h>
#else
# ifdef HAVE_SYS_TERMIO_H
#  include <sys/termio.h>
# endif /* HAVE_SYS_TERMIO_H */
#endif /* HAVE_SYS_TERMIOS_H */

/* Solaris 2.5 seems to already have a typedef for 'timer_t', so
 * #define timer_t to something else as a workaround.
 */

#ifdef HAVE_TIMER_T
# define timer_t p_timer_t
#endif

/* See if we have bcopy, if not define them to use the memcpy functions */

#ifndef HAVE_BCOPY
# define bcopy(s,d,n)	memcpy((s),(d),(n))
# define bzero(d,n)	memset((d),0,(n))
#endif

/* We use setuid/setgid if not setreuid/setregid */

#ifndef HAVE_SETREUID
# define setreuid(ruid,euid)		setuid(ruid)
#endif

#ifndef HAVE_SETREGID
# define setregid(rgid,egid)		setgid(rgid)
#endif

/* If we are BSD, make minor adjustments */

#if defined(BSD) && !defined(O_APPEND)
# define O_APPEND	F_APPEND
#endif

#ifndef O_NONBLOCK
#define	O_NONBLOCK	O_NDELAY
#endif

#ifndef O_NDELAY
#define	O_NDELAY	O_NONBLOCK
#endif

/********************************************************************
 * This is NOT the user configurable section.  Look in options.h
 * for tunable parameters.
 ********************************************************************/

#define VERSION			"1.0.0"

#ifndef __PROFTPD_SUPPORT_LIBRARY

/* This section is only needed for modules and the core source files,
 * not for the support library.
 */

/* Generic typedefs */

typedef struct in_addr in_addr_t;

#include "pool.h"
#include "proftpd.h"
#include "support.h"
#include "sets.h"
#include "dirtree.h"
#include "io.h"
#include "modules.h"
#include "timers.h"
#include "inet.h"
#include "ident.h"
#include "ftp.h"
#include "log.h"
#include "libsupp.h"

#ifdef NEED_PERSISTANT_PASSWD

void p_setpwent();
void p_endpwent();
void p_setgrent();
void p_endgrent();
struct passwd *p_getpwent();
struct group *p_getgrent();
struct passwd *p_getpwnam(const char *);
struct passwd *p_getpwuid(uid_t);
struct group *p_getgrnam(const char *);
struct group *p_getgrgid(gid_t);

#define setpwent	p_setpwent
#define endpwent	p_endpwent
#define setgrent	p_setgrent
#define endgrent	p_endgrent
#define getpwent	p_getpwent
#define getgrent	p_getgrent
#define getpwnam	p_getpwnam
#define getpwuid	p_getpwuid
#define getgrnam	p_getgrnam
#define getgrgid	p_getgrgid

#else /* NEED_PERSISTANT_PASSWD */

# ifdef HAVE_SETPASSENT
#  define setpwent()	setpassent(1)
# endif /* HAVE_SETPASSENT */

#endif /* NEED_PERSISTANT_PASSWD */

#endif /* __PROFTPD_SUPPORT_LIBRARY */

#endif /* __CONF_H */
