/****************************************************************************
** $Id: qt_x11.cpp,v 2.2 1997/06/08 10:51:55 warwick Exp $
**
** Implementation of Qt calls to X11
**
** Created : 970529
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.33.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#include "qwidget.h"
#define	 GC GC_QQQ
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

RCSTAG("$Id: qt_x11.cpp,v 2.2 1997/06/08 10:51:55 warwick Exp $");


/*
  Internal Qt functions to create X windows.  We have put them in
  separate functions to allow the programmer to override them by custom
  versions.
*/

Window qt_XCreateWindow( const QWidget*, Display *display, Window parent,
			 int x, int y, uint w, uint h,
			 int borderwidth, int depth,
			 uint windowclass, Visual *visual,
			 ulong valuemask, XSetWindowAttributes *attributes )
{
    return XCreateWindow( display, parent, x, y, w, h, borderwidth, depth,
			  windowclass, visual, valuemask, attributes );
}


Window qt_XCreateSimpleWindow( const QWidget*, Display *display, Window parent,
			       int x, int y, uint w, uint h, int borderwidth,
			       ulong border, ulong background )
{
    return XCreateSimpleWindow( display, parent, x, y, w, h, borderwidth,
				border, background );
}


void qt_XDestroyWindow( const QWidget*, Display *display, Window window )
{
    XDestroyWindow( display, window );
}
