/* $Id: interface.h,v 1.8 1997/03/24 01:44:28 dps Exp $ */
/* Interface for output code */

#ifndef __w6cvt_iface_h__
#define __w6cvt_iface_h__
#include <stdio.h>
#include <time.h>

typedef enum
{
    T_DOC=0,				/* Document */
    T_PARAGRAPH,			/* Paragraph */
    T_TABLE, T_FIELD, T_ROW,		/* Tables */
    T_SPEC,           			/* Embed messages */
    T_OTHER,				/* Stuff we can not cope with */
    NFUNCS
} token;

typedef struct
{	
    unsigned char win;
    const char *ascii;
} cmap;

#include "reader.h"		        /* Need token for this file.... */

#ifndef __EXCLUDE_READER_CLASSES
typedef struct
{
    void (*start)(const tok_seq::tok *, const struct docfmt *, FILE *, void *);
    void (*end)(const tok_seq::tok *, const struct docfmt *, FILE *, void *);
} funcs;

typedef struct docfmt
{
    int maxline;		/* Maximum line length */
    const char *foldchar;	/* Newline for folding line */
    void *(*new_state)(void);	/* Make new state */
    void (*free_state)(void *);	/* Free state */
    funcs f[NFUNCS];		/* Document output fucntions */
    char *(*date)(time_t);	/* Set by front end */
} docfmt;

#endif /* __EXLCUDE_READER_CLASSES */

#ifndef N
#define N(a) (sizeof(a)/sizeof(a[0]))
#endif

#endif /* __w6cvt_iface_h__ */




