.\" $Id: isdnlog.man,v 1.1 1997/09/04 11:34:17 aj Exp $
.\" CHECKIN $Date: 1997/09/04 11:34:17 $
.TH isdnlog 8 "@MANDATE@" "ISDN 4 Linux @I4LVERSION@" "Linux System Administration"
.PD 0
.SH NAME
isdnlog \- isdn log system (and more)

.SH "RESTRICTION"
Isdnlog only works with the HiSax isdn driver. Other cards with their
own driver are not supported. Additionally you need to enable d-channel logging 
(you can use "hisaxctrl <DriverId> 1 4" to do that, e.g. "hisaxctrl
line0 1 4"). Isdnlog can only log outgoing calls that
originate from
your isdn card, and incoming calls. To get information about outgoing
calls from other isdn devices (e.g. telephones), you need a second Teles
isdn card, with crossed lines. Such a card is not usable for communicating,
but can log
outgoing calls from any device (see dual option below).

.SH "DESCRIPTION"
Isdnlog gets information from your isdn card, decodes this
information, and can do anything with it, such as logging, starting
programs, and more. All options to isdnlog can be given as command line
flags, or you can specify a file with options (recommended). 

.SH "GENERAL OPTIONS"

.TP
.B \-V
show version information and exit.

.TP
.B \-fFILE
read options from the config file FILE. The first line should be 
"[options]". You may use blank lines and comments (starting with a #).
All config files for isdnlog have the format described in isdn.conf(5).
Debug options must be given on the command line, they cannot be stored in a
file.

.TP
.B /dev/DEVICE
isdnlog will read from this device and from /dev/isdninfo. You should
give /dev/isdnctrl0 for the first isdn card (or /dev/isdnctrl2 for the
second).

Isdnlog has a replay mode for debugging, where you can simulate previous
recorded events. In that case use "-" instead of a device.

.TP
.B \-r
Replay a debug file (e.g. /tmp/isdnctrl0) to find bugs. With this flag
you should give a filename with the debug information instead of a device.
It will also work with files not created by isdnlog (e.g. 
"cat /dev/isdnctrl0").

.TP
.B \-n	newline={yes|no}
Display throughput messages on the same line (only useful with logging to
stderr or a console device).

.TP
.B \-Wx	width="value"
Limit all messages to X characters per line.

.TP
.B \-Ax	amt="value"
Set digits necessary to get an outside line, when connected through a PABX.
You can
give several codes padded with a ":" (e.g. -A0:80:81:82).

.TP
.B \-2x	dual="value"
Enable dual mode. You need this if you have a second isdn card attached with
crossed lines so it can listen to what other isdn devices like telephones
are doing. With x=2 you can increase the debug output - every single
digit will be displayed.

.SH "DEBUG MODULE"

.TP
.B \-vX	log=X
Isdnlog can copy all information to /tmp/DEVICE (e.g. /tmp/isdnctrl0 if
you started isdnlog with /dev/isdnctrl0). Choose what debugging you want
from the following list, add the corresponding numbers together and use
that for X:

.RS
.TP
1
copy all "HEX:" lines from the hisax isdn device driver.
.TP
2
copy /dev/isdnctrl output (or whatever device you specified).
.TP
4
copy /dev/isdninfo output 
.TP
8
copy transfer values ("ibyte","obyte").

.in -7
Isdnlog will close and reopen this file after a "kill -HUP".
.RE

.TP
.B \-s	flush={yes|no}
Isdnlog will flush the debug file /tmp/DEVICE (e.g. /tmp/isdnctrl0) after
each write access.

.TP
.B \-P	pipe={yes|no}
Copy the debug information to stdout. This way you can run isdnlog as the
source of a pipe like "isdnlog -P /dev/isdnctrl0 |prog ... ".

.TP
.B \-D	daemon={yes|no}
Start isdnlog as daemon: it will fork into the background, and use syslog
as the default logging method (if you did not specify -m).

.TP
.B \-T
Trace mode: isdnlog will wait for a key after processing a line from
/dev/isdnctrl0 (or whatever device you specified).

.TP
.B \-b
If you are using a bilingual network terminator (NT), you must give this
flag, or isdnlog will show the own MSN's incorrectly.

.SH "NUMBER REWRITE MODULE"

You can define aliases for telephone numbers (see callerid.conf(5) and
isdn.conf(5) for more information). Isdnlog will compare all numbers to
the list of aliases, and when a match is found, the alias is displayed
instead of the number.

.SH "LOG MODULE"
Isdnlog can log information via syslog, to stdout, and send information
to x11 clients. Calculate a code from these numbers by adding them, and
activate logging with -s, -m or -x. You can use normal numbers or hex
numbers. Default is stderr mode -m, unless daemon mode is enabled; then it's
syslog mode -l.

.TP
0x1
Errors

.TP
0x2
Warnings

.TP
0x4
Notice

.TP
0x8
Log messages to /tmp/DEVICE (e.g. /tmp/isdnctrl0 if isdnlog is started
with /dev/isdnctrl0)

.TP
0x10
Show telephone numbers immediately.

.TP
0x20
Show charge int and telephone costs with every charge signal
(in Germany, and perhaps other countries, you have to pay to get these signals).

.TP
0x40
Show connect messages.

.TP
0x80
Show hang up messages.

.TP
0x100
Show cause message on hang up.

.TP
0x200
Show time messages.

.TP
0x400
Show throughput in bytes (every -wX seconds).

.TP
0x800
Show state of B-channels.

.TP
0x1000
Show service indicator.
.br
You should log at least 0x7 (errors, warnings, notice) messages.

.TP
0x2000
Log estimated time till next charge signal.

.TP
.B \-mX	stdout="value"
Log to stderr.

.TP
.B \-OX	outfile="path"
Log to file X instead of stderr. Isdnlog will close this device when it
gets a signal -SIGHUP (-1). Only valid with -m option.

.TP
.B \-C X	console="path"
Log to console X instead of stderr. You can use -O and -C together,
so that isdnlog copies output to both. Specify a full pathname.
Beware: you
.ul
must
put a space between -C and X !

.TP
.B \-M	monitor={yes|no}
With this flag, isdnlog will generate output for monitor programs like
imon, imontty or isdnmon. You must also give -m with 0x800 enabled.

.TP
.B \-lX	syslog="value"
Log to syslog. X is the log code. You can log to syslog and to stdout at
the same time.

.TP
.B \-xX	xisdn="value"
Pass information to x11 client. X is the log code. You can pass
information to x11 clients and log to syslog and/or stdout at the same
time.

.TP
.B \-cX	calls="value"
Only with -xX : save the last X calls and pass this information to an
x11 client. Default value is 100.

.TP
.B \-LX	xlog="value"
Only with -xX : save the last X messages and pass this information to an
x11 client. Default value is 500.

.TP
.B \-wX	thruput="value"
If you enabled throughput logging (0x400), isdnlog will log the throughput
every X seconds.

.SH "TIME MODULE"

.TP
.B \-tX	time={0|1|2}
Isdnlog will set your local system time to the time transmitted by your
isdn service provider: -t1 = once, -t2 = every time. 

.SH "CHARGEHUP MODULE"

.TP
.B \-hX	hangup="value"
The isdn kernel system has a chargehup system, so it will hang up a few
seconds before the next charge signal. If you don't get a charge
signal from your phone company, isdnlog can emulate it. 

On every outgoing connection, isdnlog will calculate the charge
time from day of week, time of day and the distance zone of the
connection. So you need to list the system in isdn.conf with a ZONE=
line.

The kernel needs to know how long the charge time is, and how many
seconds before the next charge signal it should hang up. You have to set
the second parameter with X in the form number:number (hang up seconds
before next charge signal for charge times greater than or equal to 20
seconds : for charge times of less than 20 seconds).

With this information, isdnlog will call "isdnctrl chargeint <device>
<charge time>" and "isdnctrl huptimeout <device> <seconds before charge
signal>" (it actually communicates directly with isdn, without calling
isdnctrl, but this would have the same effect).

You should run isdnlog with -t1 or better with -t2, so isdnlog sets the
local time in sync with telephone switching office.

.SH "START MODULE"

isdnlog can react on any event and start programs. This feature is
disabled unless you activate it with:

.TP
.B \-S	start={yes|no}
active "START" feature. Please read isdnlog.options(5) for more
information.

.SH "CONNECTION LOG MODULE"

isdnlog will log all connections in /var/log/isdn.log. isdnrep can parse
this file and calculate costs.

.SH "SEVERAL ISDN CARDS"
If you have more than one isdn card, you need to run one isdnlog for
each card. And every process must have a different name, so you should
create a symbolic link isdnlog1 -> isdnlog, and start isdnlog1 for the
second card.

.SH "UNLOADING KERNEL MODULES"
You cannot unload isdn kernel modules while an isdn device is in use,
e.g. a PPP interface is defined or isdnlog is running. Look at
/var/run for a file isdnlog.DEVICE.pid with the process id of isdnlog,
and kill that. After that you should be able to unload your isdn kernel modules.

.SH "FILES"
.TP
.B /dev/DEVICE
isdnlog requires a device as a parameter to read from (e.g.
/dev/isdnctrl0 for the 1st isdn card).

.TP
.B /tmp/DEVICE
isdnlog can copy everything it reads to this file as debug information
(e.g. /tmp/isdnctrl0 if you started isdnlog with /dev/isdnctrl0).

.TP
.B /var/run/isdnlog.DEVICE.pid
isdnlog creates this file with its process id. Useful to see if
isdnlog is running.

.TP
.B /var/lock/LCK..DEVICE
isdnlog creates a lock file for the device, so no other processes will
access that device.

.TP
.B /etc/isdn/isdn.conf
isdnlog config file. Options to isdnlog can be given on the command line, can
be stored in this file in [options] (with command line option 
-f/etc/isdn/isdn.conf), or in a different config file, but isdnlog will
look at this file for sections [global] [variables] [isdnlog].

.SH EXAMPLE

I start isdnlog with "isdnlog -f/etc/isdn/isdn.conf /dev/isdnctrl0".
This file contains a [options] section:

.nf
[options]
#newline=no     # show all throughput messages in one line.
#width=80       # limit log messages to 80 characters per line
#amt=0:80:81    # digits to get a line through your PABX
log=15          # maximum debug mode
flush=no        # flush logfile after every write
pipe=no         # pipe log messages to stderr
daemon=yes      # run isdnlog as daemon
stdout=0x3fff   # stderr logging level
outfile=/var/log/isdn/log               # log to file
#console=       # log to a console
monitor=yes     # emulate output for  imon/imontty/...
syslog=0x3fff   # syslog logging level
#xisdn=0x07ff   # x11 output level
#calls=         # store call information for x11 client
#xlog=          # store messages for x11 client
#thruput=       # if throughput logging is enabled: log every X seconds
#time=          # set time: 0 = never; 1 = once; 2 = every time
#hangup=        # simulate charge signals
start=yes       # enable starting programs   

.SH SEE ALSO
.B isdnconf(5) isdnlog.options(5) isdn.conf(5) callerid.conf(5)
.B isdn.log(5) isdnrep(8)

.SH AUTHOR
This manual page was written by Andreas Jellinghaus <aj@debian.org>,
for Debian GNU/Linux and isdn4linux.
