/*
 * pvf.h
 *
 * Contains the constants and function prototypes for the pvf tools
 */

#ifdef MAIN
char *pvf_h = "$Id: pvf.h,v 1.2 1997/02/20 06:51:46 marc Exp $";
#endif

#include "wav.h"

/*
 * Constants
 */

/*
 * Blocksize for reading voice files into memory
 */

#define BLOCK_SIZE 0x10000

/*
 * Decimal point shift for fixed-point arithmetic
 */

#define SHIFT 12
#define ONE   (1 << SHIFT)

/*
 * Structure for handling pvf files
 */

typedef struct
     {
     int ascii;
     int channels;
     int speed;
     int nbits;
     int (*read_pvf_data) (FILE *fd_in);
     void (*write_pvf_data) (FILE *fd_out, int data);
     } pvf_header;

/*
 * Structure for handling bit read and write operations
 */

typedef struct
     {
     int data;
     int nleft;
     } state_t;

extern rmd_header init_rmd_header;
extern pvf_header init_pvf_header;
extern state_t init_state;
extern int bitmask[17];

/*
 * Functions
 */

extern unsigned char linear2ulaw (int sample);
extern int ulaw2linear (unsigned char ulawbyte);

extern int read_rmd_header (FILE *fd_in, rmd_header *header_in);
extern int write_rmd_header (FILE *fd_out, rmd_header *header_out);

extern int read_pvf_header (FILE *fd_in, pvf_header *header_in);
extern int write_pvf_header (FILE *fd_out, pvf_header *header_out);

extern int read_bits (FILE *fd_in, state_t *state, int nbits);
extern void write_bits (FILE *fd_out, state_t *state, int nbits, int data);
extern int read_bits_reverse (FILE *fd_in, state_t *state, int nbits);
extern void write_bits_reverse (FILE *fd_out, state_t *state, int nbits,
 int data);

extern int pvftorockwell (FILE *fd_in, FILE *fd_out, int nbits,
 pvf_header *header_in);
extern int rockwelltopvf (FILE *fd_in, FILE *fd_out, int nbits,
 pvf_header *header_out);

extern int pvftozyxel (FILE *fd_in, FILE *fd_out, int nbits,
 pvf_header *header_in);
extern int zyxeltopvf (FILE *fd_in, FILE *fd_out, int nbits,
 pvf_header *header_out);

extern int pvftovoc (FILE *fd_in, FILE *fd_out, pvf_header *header_in);
extern int voctopvf (FILE *fd_in, FILE *fd_out, pvf_header *header_out);

extern int pvftolin (FILE *fd_in, FILE *fd_out, pvf_header *header_in,
 int is_signed, int bits16, int intel);
extern int lintopvf (FILE *fd_in, FILE *fd_out, pvf_header *header_out,
 int is_signed, int bits16, int intel);

extern int pvftobasic (FILE *fd_in, FILE *fd_out, pvf_header *header_in);
extern int basictopvf (FILE *fd_in, FILE *fd_out, pvf_header *header_out);

#define SND_FORMAT_MULAW_8    1
#define SND_FORMAT_LINEAR_8   2
#define SND_FORMAT_LINEAR_16  3

extern int pvftoau (FILE *fd_in, FILE *fd_out, pvf_header *header_in,
 int dataFormat);
extern int autopvf (FILE *fd_in, FILE *fd_out, pvf_header *header_out);

extern int pvftowav (FILE *fd_in, FILE *fd_out, pvf_header *header_in);
extern int wavtopvf (FILE *fd_in, FILE *fd_out, pvf_header *header_out);

extern int pvffft (FILE *fd_in, pvf_header *header_in, int skip,
 int sample_size, double threshold, int vgetty_pid, int display);
