/* Ask the server who to email about a given piece in GNATS.
   Copyright (C) 1994, 1995 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

#define BY_PR		1
#define BY_CATEGORY	2
#define BY_SUBMITTER	3

/* The name this program was run with.  */
char *program_name;

/* The name of the GNATS server.  */
char *name;

/* If 1, send information as we make the query.  */
int debug = 0;

struct option long_options[] =
{
  {"pr", 1, NULL, 'p'},
  {"submitter", 1, NULL, 's'},
  {"category", 1, NULL, 'c'},
  {"debug", 0, NULL, 'D'},
  {"version", 0, NULL, 'V'},
};

void usage (), version ();

void
do_lookup (type, arg)
     int type;
     char *arg;
{
  char *cmd;

  switch (type)
    {
    case BY_PR:
      cmd = "MLPR";
      break;
    case BY_CATEGORY:
      cmd = "MLCT";
      break;
    case BY_SUBMITTER:
      cmd = "MLSU";
      break;
    default:
      fprintf (stderr, "%s: unknown choice for doing a lookup\n",
	       program_name);
      exit (1);
    }

  if (debug)
    fprintf (stderr, "%s: writing `%s %s'\n", program_name,
	     cmd, arg);
  fprintf (serv_write, "%s %s\r\n", cmd, arg);
  get_reply ();
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  int optc;
  char *arg = NULL;
  int lookups = 0, lookup_type = 0;

  program_name = basename (argv[0]);
  if (argc == 1)
    usage (1);

  name = gnats_server;

  while ((optc = getopt_long (argc, argv, "p:c:s:VD",
			      long_options, (int *) 0)) != EOF)
    {
      switch (optc)
	{
	case 'p':
	  lookup_type = BY_PR;
	  lookups++;
	  arg = optarg;
	  break;

	case 'c':
	  lookup_type = BY_CATEGORY;
	  lookups++;
	  arg = optarg;
	  break;

	case 's':
	  lookup_type = BY_SUBMITTER;
	  lookups++;
	  arg = optarg;
	  break;

	case 'V':
	  version ();
	  exit (0);
	  break;

	case 'D':
	  debug = 1;
	  break;

	default:
	  usage ();
	}
    }

  if (lookups > 1)
    {
      fprintf (stderr, "%s: only one item may be looked up at a time\n",
	       program_name);
      exit (3);
    }

  if (! arg)
    usage ();

  client_init ();

  do_lookup (lookup_type, arg);

  client_exit ();

  exit (0);
}

void
usage ()
{
  fprintf (stderr, "\
Usage: %s [-V] [-p pr] [-s submitter] [-c category] [--version]\n\
       [--pr=PR] [--submitter=submitter] [--category=cagetory]\n",
	   program_name);
  exit (1);
}

void
version ()
{
  printf ("pr-mail %s\n", version_string);
}

