#!/bin/sh
# Delete a category from GNATS.
# Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=xGNATS_ROOTx
GNATS_SITE=xGNATS_SITEx
DATADIR=xDATADIRx

if [ $# -eq 0 ]; then
  echo "usage: $0 category [category...]"
  exit 1
fi

# Newer config information?
[ -f ${GNATS_ROOT}/gnats-adm/config ] && . ${GNATS_ROOT}/gnats-adm/config

if [ ! -d $DATADIR/gnats/dist ]; then
  echo "$0: No directory $DATADIR/gnats/dist!"
  exit 1
fi

if [ ! -d $DATADIR/gnats ]; then
  echo "$0: $DATADIR/gnats/$GNATS_SITE doesn't exist"
  exit 1
fi

for i in $*; do

    c=`grep "^$i:" $GNATS_ROOT/gnats-adm/categories`
    if [ "$c" != "" ]; then
      echo "$0: category $i is still in the categories file, please remove it."
      continue
    fi
    if [ ! -d $GNATS_ROOT/$i ]; then
      echo "$0: no directory for category $i"
      continue
    fi
    if [ "`ls $GNATS_ROOT/$i/* 2>/dev/null`" != "" ]; then
      echo "$0: bug reports are still in $i, remove them or recategorize them."
      continue
    fi
    echo Trying to delete $i...
    # Can't test return value of rmdir on old SunOSes...rrgh
    rmdir $GNATS_ROOT/$i 2>/dev/null
    if [ -d $GNATS_ROOT/$i ] ; then
      echo "$0: could not remove $GNATS_ROOT/$i"
      continue
    fi
    sed -e "/^$i$/d" $DATADIR/gnats/dist/categories > $DATADIR/gnats/dist/categories.tmp
    mv -f $DATADIR/gnats/dist/categories.tmp $DATADIR/gnats/dist/categories
    sed -e "/^$i$/d" $DATADIR/gnats/$GNATS_SITE > $DATADIR/gnats/$GNATS_SITE.tmp
    mv -f $DATADIR/gnats/$GNATS_SITE.tmp $DATADIR/gnats/$GNATS_SITE

done

exit 0
