/*
 * xdm - display manager daemon
 *
 * $XConsortium: Login.h,v 1.8 89/07/25 17:58:57 keith Exp $
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Keith Packard, MIT X Consortium
 * Modified by Pierre Ficheux (pierre@lectra.fr):
 *
 * $Id: Login.h,v 1.2 1994/09/04 22:27:07 pierre Exp $
 */

/*
* $XConsortium: Login.h,v 1.8 89/07/25 17:58:57 keith Exp $
*/

#ifndef _XtLogin_h
#define _XtLogin_h

/***********************************************************************
 *
 * Login Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		pixel		White
 border		     BorderColor	pixel		Black
 borderWidth	     BorderWidth	int		1
 foreground	     Foreground		Pixel		Black
 height		     Height		int		120
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 width		     Width		int		120
 x		     Position		int		0
 y		     Position		int		0

*/

# define XtNgreeting		"greeting"
# define XtNunsecureGreeting	"unsecureGreeting"
# define XtNnamePrompt		"namePrompt"
# define XtNpasswdPrompt	"passwdPrompt"
# define XtNfail		"fail"
# define XtNnotifyDone		"notifyDone"
# define XtNpromptColor		"promptColor"
# define XtNgreetColor		"greetColor"
# define XtNfailColor		"failColor"
# define XtNpromptFont		"promptFont"
# define XtNgreetFont		"greetFont"
# define XtNfailFont		"failFont"
# define XtNfailTimeout		"failTimeout"
# define XtNsessionArgument	"sessionArgument"
# define XtNsecureSession	"secureSession"
# define XtNallowAccess		"allowAccess"

/*
 * Resources added by Pierre:
 * 
 * Name		    Description		Type			Default 
 *
 * displayLogo	displays the logo ?		Boolean		True	
 * displayUsers	displays users list ?		Boolean		True
 * useDefaultPixmap use default.xpm if none ?	Boolean		False
 * userWidth	width of user			Dimension	90
 * userHeight	height of user			Dimension	90
 * nbColumns	# of users / columns		int		6
 * nbLines	# of users / line		int		2
 * userColor	user name color			pixel		XtDefaultForeground
 * userFont	user name font			XFontStruct*	"6x13"
 *
 */

#define  XtNdisplayLogo		"displayLogo"
#define  XtNdisplayUsers	"displayUsers"
#define  XtNuserWidth		"userWidth"
#define  XtNuserHeight		"userHeight"
#define  XtNnbColumns		"nbColumns"
#define  XtNnbLines		"nbLines"
#define  XtNuserColor		"userColor"
#define  XtNuserFont		"userFont"
#define  XtNuseDefaultPixmap	"useDefaultPixmap"

# define XtCGreeting		"Greeting"
# define XtCNamePrompt		"NamePrompt"
# define XtCPasswdPrompt	"PasswdPrompt"
# define XtCFail		"Fail"
# define XtCFailTimeout		"FailTimeout"
# define XtCSessionArgument	"SessionArgument"
# define XtCSecureSession	"SecureSession"
# define XtCAllowAccess		"AllowAccess"
#define  XtCDisplayLogo		"DisplayLogo"
#define  XtCDisplayUsers	"DisplayUsers"
#define  XtCUserWidth		"UserWidth"
#define  XtCUserHeight		"UserHeight"
#define  XtCNbColumns		"NbColumns"
#define  XtCNbLines		"NbLines"
#define  XtCUseDefaultPixmap	"UseDefaultPixmap"

/* notifyDone interface definition */

#define NAME_LEN	32

typedef struct _LoginData { 
	char	name[NAME_LEN], passwd[NAME_LEN];
} LoginData;

# define NOTIFY_OK	0
# define NOTIFY_ABORT	1
# define NOTIFY_RESTART	2
# define NOTIFY_ABORT_DISPLAY	3

typedef struct _LoginRec *LoginWidget;  /* completely defined in LoginPrivate.h */
typedef struct _LoginClassRec *LoginWidgetClass;    /* completely defined in LoginPrivate.h */

extern WidgetClass loginWidgetClass;

#endif /* _XtLogin_h */
/* DON'T ADD STUFF AFTER THIS #endif */
