/*    c_commands.h
 *
 *    Copyright (c) 1994-1996, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#ifndef __COMMANDS_H__
#define __COMMANDS_H__

typedef enum {
    ErFAIL = 0,
    ErOK = 1
} ExResult;

typedef enum {
    ExNop,
    ExFail,
    
    ExMoveDown,
    ExMoveUp,
    ExMoveLeft,
    ExMoveRight,
    ExMovePrev,
    ExMoveNext,
    ExMoveWordLeft,
    ExMoveWordRight,
    ExMoveWordPrev,
    ExMoveWordNext,
    ExMoveWordEndLeft,
    ExMoveWordEndRight,
    ExMoveWordEndPrev,
    ExMoveWordEndNext,
    ExMoveLineStart,
    ExMoveLineEnd,
    ExMovePageStart,
    ExMovePageEnd,
    ExMovePageUp,
    ExMovePageDown,
    ExMoveFileStart,
    ExMoveFileEnd,
    ExMovePageLeft,
    ExMovePageRight,
    ExMoveBlockStart,
    ExMoveBlockEnd,
    ExMoveFirstNonWhite,
    ExMoveLastNonWhite,
    ExMovePrevEqualIndent,
    ExMoveNextEqualIndent,
    ExMovePrevTab,
    ExMoveNextTab,
    ExMoveTabStart,
    ExMoveTabEnd,
    ExMoveLineTop,
    ExMoveLineCenter,
    ExMoveLineBottom,
    ExScrollLeft,
    ExScrollRight,
    ExScrollDown,
    ExScrollUp,
    ExMoveFoldTop,
    ExMoveFoldPrev,
    ExMoveFoldNext,
    
    ExKillLine,
    ExKillChar, 
    ExKillCharPrev,
    ExKillWord, 
    ExKillWordPrev,
    ExKillToLineStart,
    ExKillToLineEnd,
    ExKillBlock,
    ExKillBlockOrChar,
    ExKillBlockOrCharPrev,
    ExBackSpace,
    ExDelete,

    ExCharCaseUp,
    ExCharCaseDown,
    ExCharCaseToggle,
    ExCharTrans,
    ExLineCaseUp,
    ExLineCaseDown,
    ExLineCaseToggle,
    ExLineTrans,
    ExLineInsert,
    ExLineAdd,
    ExLineSplit,
    ExLineJoin,
    ExLineNew,
    ExLineIndent,
    ExLineTrim,
    ExLineDuplicate,

    ExBlockBegin,
    ExBlockEnd,
    ExBlockUnmark,
    ExBlockCut,
    ExBlockCopy,
    ExBlockCutAppend,
    ExBlockCopyAppend,
    ExBlockClear,
    ExBlockPaste,
    ExBlockKill,
    ExBlockIndent,
    ExBlockUnindent,
    ExBlockMarkStream,
    ExBlockMarkLine,
    ExBlockMarkColumn,
    ExBlockCaseUp,
    ExBlockCaseDown,
    ExBlockCaseToggle,
    ExBlockTrans,
    ExBlockExtendBegin,
    ExBlockExtendEnd,
    ExBlockReIndent, 
    ExBlockSelectWord,
    ExBlockSelectLine,
    ExBlockSelectPara,
    ExBlockPasteStream,
    ExBlockPasteLine,
    ExBlockPasteColumn,
    ExBlockPrint,
    ExBlockRead,
    ExBlockReadStream,
    ExBlockReadLine,
    ExBlockReadColumn,
    ExBlockWrite,
    ExBlockSort,
    ExBlockSortReverse,

    ExUndo,
    ExRedo,

    ExFoldCreate,
    ExFoldCreateByRegexp,
    ExFoldDestroy,
    ExFoldDestroyAll,
    ExFoldPromote,
    ExFoldDemote,
    ExFoldOpen,
    ExFoldOpenNested,
    ExFoldClose,
    ExFoldOpenAll,
    ExFoldCloseAll,
    ExFoldToggleOpenClose, 

    ExMoveToLine,
    ExMoveToColumn,
    ExMoveSavedPosCol,
    ExMoveSavedPosRow,
    ExMoveSavedPos,
    ExSavePos,
    ExMovePrevPos,
    // ExCursorPush,
    // ExCursorPop,
    
    ExPlaceBookmark,
    ExRemoveBookmark,
    ExGotoBookmark,
    
    ExInsertString,
    ExInsertSpace,
    ExInsertChar,
    ExTypeChar,
    ExInsertTab,
    ExInsertSpacesToTab,
    ExSelfInsert,
    ExWrapPara,
    ExInsPrevLineChar,
    ExInsPrevLineToEol,
    ExCompleteWord,
    
    ExFilePrev,
    ExFileNext,
    ExFileLast,
    ExSwitchTo,

    ExFileOpen,
    ExFileOpenInMode,
    ExFileReload,
    ExFileSave,
    ExFileSaveAll,
    ExFileSaveAs,
    ExFileWriteTo,
    ExFilePrint,
    ExFileClose,
    ExFileCloseAll,
    
    ExDirOpen,
    ExDirGoUp,
    ExDirGoDown,
    ExDirGoRoot,
    ExDirGoto,

    ExIncrementalSearch,
    ExFind,
    ExFindReplace,
    ExFindRepeat,
    ExFindRepeatOnce,
    ExFindRepeatReverse,
    ExMatchBracket,
    ExHilitWord,
    ExSearchWordPrev,
    ExSearchWordNext,
    ExHilitMatchBracket,
    ExSearch,
    ExSearchB,
    ExSearchRx,
    ExSearchAgain,
    ExSearchAgainB,
    ExSearchReplace,
    ExSearchReplaceB,
    ExSearchReplaceRx,
    
    ExWinHSplit,
    ExWinNext,
    ExWinPrev,
    ExWinClose,
    ExWinZoom,
    ExWinResize,

    ExViewBuffers,
    ExListRoutines,
    ExCompile,
    ExViewMessages,
    ExCompilePrevError,
    ExCompileNextError,

    ExExitEditor,
    ExShowEntryScreen,
    ExRunProgram,

    ExShowPosition,
    ExShowVersion,
    ExShowKey,
    ExWinRefresh,

    ExMainMenu,
    ExShowMenu,
    ExLocalMenu,

    ExChangeMode,
    ExChangeKeys,
    ExChangeFlags,

    ExToggleAutoIndent,
    ExToggleInsert,
    ExToggleExpandTabs,
    ExToggleShowTabs,
    ExToggleUndo,
    ExToggleReadOnly,
    ExToggleKeepBackups,
    ExToggleMatchCase,
    ExToggleBackSpKillTab,
    ExToggleDeleteKillTab,
    ExToggleSpaceTabs,
    ExToggleIndentWithTabs,
    ExToggleBackSpUnindents,
    ExToggleWordWrap,
    ExToggleTrim,
    ExToggleShowMarkers,
    ExSetLeftMargin,
    ExSetRightMargin,
    ExToggleSysClipboard,
    ExSetPrintDevice,
    ExChangeTabSize,
    ExChangeLeftMargin,
    ExChangeRightMargin,

    ExCancel,
    ExActivate,
    ExRescan,
    ExCloseActivate,
    ExActivateInOtherWindow,

    ExASCIITable,
    ExDesktopSave,
    ExClipClear,
    ExDesktopSaveAs,
    ExChildClose,

    ExBufListFileSave,
    ExBufListFileClose,

    ExViewModeMap,
    ExClearMessages,
    ExBlockUnTab,
    ExBlockEnTab,

    ExTagFind,
    ExTagFindWord,
    ExTagNext,
    ExTagPrev,
    ExTagPop,
    ExTagLoad,
    ExTagClear,
    ExTagGoto,

    // JAL
    ExBlockMarkFunction, 
    ExIndentFunction,
    ExMoveFunctionPrev,
    ExMoveFunctionNext,
    ExInsertDate,
    ExInsertUid,

    ExFrameNew,
    ExFrameClose,
    ExFrameNext,
    ExFramePrev,

    ExBufferViewNext,
    ExBufferViewPrev,
} ExCommands;

#endif
