//=======================================================================
//@V@:Note: This file generated by vappgen V 1.00.
//	vgmdlg.cpp:	Source for vgModalDialog class
//=======================================================================

#include "vgmdlg.h"
#include <v/vnotice.h>
#include <v/vfilesel.h>

//@V@:BeginIDs
    enum {
    lblMainMsg = 1000,

    frmNames,
    lblAppName,			// App name
    txiAppName,
    lblFileName,		// file base name
    txiFileName,
    lblTitle,			// app title
    txiTitle,

    frmCmdWin,			// frame for cmdwin stuff
    lblCmdWin,
    blkCmdWin,
    chkGenTool,			// if generate toolbar
    chkWinSDI,			// if Windows SDI
    chkGenStatus,		// if generate status bar
    chkGenDate,

    frmCanvas,			// frame for canvas stuff
    lblCanvas,
    blkCanvas,
    chkVScroll,			// for vert scroll
    chkHScroll,			// for horiz scroll
    rdbStdCnv,			// Standard Canvas
    rdbTextCnv,			// Text Canvas

    frmOther,			// frame for other options
    lblOther,
    blkOther,
    chkGenDialog,		// if generate a dialog
    chkGenModal,		// if generate a modal dialog
    chkGenMake,			// if generate make file
    lblHOMEV,
    txiHOMEV,

    btnSetPath,			// to set save path
    blkLast
  };
//@V@:EndIds

//@V@:BeginDialogCmd DefaultCmds
    static DialogCmd DefaultCmds[] =
      {
	{C_Label, lblMainMsg, 0,"X",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},

	{C_Frame, frmNames, 0, "",NoList,CA_NoBorder,isSens,NoFrame, 0,lblMainMsg},
	{C_Label, lblAppName, 0,"Application Base Name:",
	    NoList, CA_None, isSens,frmNames,0, 0},
	{C_TextIn, txiAppName, 0,"x",
	    NoList, CA_None, isSens,frmNames,lblAppName, 0},
	{C_Label, lblFileName, 0,"       File Base Name:",
	    NoList, CA_None, isSens,frmNames,0, txiAppName},
	{C_TextIn, txiFileName, 0,"x",
	    NoList, CA_None, isSens,frmNames,lblFileName, txiAppName},
	{C_Label, lblTitle, 0,  "    Application Title:",
	    NoList, CA_None, isSens,frmNames,0, txiFileName},
	{C_TextIn, txiTitle, 0,"x",
	    NoList, CA_None, isSens,frmNames,lblTitle, txiFileName},


	{C_Frame, frmCmdWin, 0, "",NoList,CA_NoBorder,isSens,NoFrame, 0,frmNames},
	{C_Label, lblCmdWin, 0, "Command Window Options",
	    NoList, CA_None, isSens,frmCmdWin,0, 0},
	{C_Blank, blkCmdWin, 0, " ",
	    NoList, CA_None, isSens,frmCmdWin,0, lblCmdWin},
	{C_CheckBox, chkGenTool, 1, "Include Tool Bar         ",
	    NoList, CA_None, isSens,frmCmdWin,blkCmdWin, lblCmdWin},
	{C_CheckBox, chkGenStatus, 1, "Include Status Bar",
	    NoList, CA_None, isSens,frmCmdWin,chkGenTool, lblCmdWin},
  	{C_CheckBox, chkWinSDI, 0,  "Windows SDI (MDI Default)",
	    NoList, CA_None, isSens,frmCmdWin,blkCmdWin, chkGenTool},
	{C_CheckBox, chkGenDate, 0, "Time/Date on Status Bar",
	    NoList, CA_None, isSens,frmCmdWin,chkWinSDI, chkGenStatus},

	{C_Frame, frmCanvas, 0, "",NoList,CA_NoBorder,isSens,NoFrame, 0,frmCmdWin},
	{C_Label, lblCanvas, 0, "Canvas Options",
	    NoList, CA_None, isSens,frmCanvas,0, 0},
	{C_Blank, blkCanvas, 0, " ",
	    NoList, CA_None, isSens,frmCanvas,0, lblCanvas},
	{C_CheckBox, chkVScroll, 1, "Vertical Scroll Bar      ",
	    NoList, CA_None, isSens,frmCanvas,blkCanvas, lblCanvas},
	{C_CheckBox, chkHScroll, 1, "Horizontal Scroll Bar",
	    NoList, CA_None, isSens,frmCanvas,chkVScroll, lblCanvas},
	{C_RadioButton, rdbStdCnv, 1, "vCanvasPane              ",
	    NoList, CA_None, isSens,frmCanvas,blkCanvas, chkVScroll},
	{C_RadioButton, rdbTextCnv, 0, "vTextCanvasPane",
	    NoList, CA_None, isSens,frmCanvas,rdbStdCnv, chkVScroll},

	{C_Frame, frmOther, 0, "",NoList,CA_NoBorder,isSens,NoFrame, 0,frmCanvas},
	{C_Label, lblOther, 0, "Other Options",
	    NoList, CA_None, isSens,frmOther,0, 0},
	{C_Blank, blkOther, 0, " ",
	    NoList, CA_None, isSens,frmOther,0, lblOther},

	{C_CheckBox, chkGenDialog, 1, "Generate Modeless Dialog ",
	    NoList, CA_None, isSens,frmOther,blkOther, lblOther},
	{C_CheckBox, chkGenModal, 0, "Generate Modal Dialog",
	    NoList, CA_None, isSens,frmOther,chkGenDialog, lblOther},
#ifdef V_VersionX			// X version
  	{C_CheckBox, chkGenMake, 1, "Generate GNU makefile",
	    NoList, CA_None, isSens,frmOther,blkOther, chkGenModal},
#else					// Windows Version
  	{C_CheckBox, chkGenMake, 0, "Generate GNU makefile",
	    NoList, CA_None, isSens,frmOther,blkOther, chkGenModal},
#endif
	{C_Label, lblHOMEV, 0," HOMEV:",
	    NoList, CA_None, isSens,frmOther,chkGenMake, chkGenModal},
	{C_TextIn, txiHOMEV, 0,"x",
	    NoList, CA_Small, isSens,frmOther,lblHOMEV, chkGenModal,20},
  
	{C_Button, btnSetPath, 0, " Set Save Path ",NoList,CA_None,
	    isSens,NoFrame,0, frmOther},
	{C_Blank, blkLast, 0, "           ",
	    NoList,CA_None, isSens,NoFrame,btnSetPath, frmOther},
	{C_Button, M_Cancel, 0, " Cancel ",NoList,CA_None,
	    isSens,NoFrame,blkLast, frmOther},
	{C_Button, M_OK, 0, " Generate ", NoList, CA_DefaultButton, 
	    isSens, NoFrame, M_Cancel, frmOther},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
    };
//@V@:EndDialogCmd

//==========================>>> SetCmdObjAttr <<<==============================
  void SetCmdObjTitle(CommandObject* cList, ItemVal id, char* newtitle)
  {
    // This is called to change the attrs field of the item with given id

    // scan the entire list

    int ix;
    for (ix = 0 ; cList && (cList[ix].cmdType != C_EndOfList) ; ++ix)
      {
	if (cList[ix].cmdId == id)		// the one we want!
	  {
	    cList[ix].title = newtitle;		// change
	    break;
	  }
      }
   }

//======================>>> vgModalDialog::vgModalDialog <<<==================
  vgModalDialog::vgModalDialog(vBaseWindow* bw, char* title) :
    vModalDialog(bw,title)
  {
    UserDebug(Constructor,"vgModalDialog::vgModalDialog()\n")
  }

//===================>>> vgModalDialog::~vgModalDialog <<<====================
  vgModalDialog::~vgModalDialog()
  {
    UserDebug(Destructor,"vgModalDialog::~vgModalDialog() destructor\n")
  }

//====================>>> vgModalDialog::vgAction <<<====================
  int vgModalDialog::vgAction(char* msg, vgOptions& op)
  {
    ItemVal ans,rval;

    SetCmdObjTitle(DefaultCmds,txiAppName,op.appName);
    SetCmdObjTitle(DefaultCmds,txiFileName,op.fileName);
    SetCmdObjTitle(DefaultCmds,txiTitle,op.title);
    SetCmdObjTitle(DefaultCmds,txiHOMEV,op.home);

    AddDialogCmds(DefaultCmds);		// add the predefined commands

    ans = ShowModalDialog(msg,rval);
    if (ans == M_Cancel)
	return 0;

    // Retrieve values from fields of the dialog

    (void) GetTextIn(txiAppName,op.appName,99);
    (void) GetTextIn(txiFileName,op.fileName,99);
    (void) GetTextIn(txiTitle,op.title,99);
    (void) GetTextIn(txiHOMEV,op.home,99);
    op.addDialog = GetValue(chkGenDialog);
    op.addModal = GetValue(chkGenModal);
    op.addMake = GetValue(chkGenMake);
    op.addToolBar = GetValue(chkGenTool);
    op.addStatus = GetValue(chkGenStatus);
    if (op.addStatus)
	op.addDate = GetValue(chkGenDate);
    else
	op.addDate = 0;
    op.vScroll = GetValue(chkVScroll);
    op.hScroll = GetValue(chkHScroll);
    op.fullMenu = 1;
    if (GetValue(rdbStdCnv) == 1)
	op.canvasType = 0;
    else
	op.canvasType = 1;
    op.winSDI = GetValue(chkWinSDI);

    // *** Add code to process dialog values here

    return ans == M_OK;
  }

//====================>>> vgModalDialog::DialogCommand <<<====================
  void vgModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {
    UserDebug2(CmdEvents,"vgModalDialog::DialogCommand(id:%d, val:%d)\n",id, retval)

    switch (id)		// We will do some things depending on value
      {
	 case chkGenStatus:	// Need to toggle sensitivity of Date
	  {
	    if (retval == 1)
	      {
		SetValue(chkGenDate,1,Sensitive);
	      }
	    else
	      {
		SetValue(chkGenDate,0,Value);
		SetValue(chkGenDate,0,Sensitive);
	      }
	    break;
	  }

	case btnSetPath:		// set path to save in
	  {
	    char path[100];
	    int tmp = 0;
	    (void) GetTextIn(txiFileName,path,99);
	    strcat(path,"app.cpp");	// use xxapp.cpp as default name
	    vFileSelect fsel(this);

	    int oans = fsel.FileSelectSave("Save code in directory",
		path,99,NULL,tmp);
	    break;
	  }
      }

    vModalDialog::DialogCommand(id,retval,ctype);
  }
