.de ES          \" start example
.PP
.RS
.PD 0
.nf
..
.de EE          \" end example
.fi
.RE
.PD
.PP
..
.\" $Id: xmailtool.man,v 1.36 1994/10/11 19:51:17 bobo Exp $
.TH XMAILTOOL 1 "93/09/27" "Cray Research, Inc."
.SH NAME
xmailtool \- X-Window(X11R5)- and mouse-based, \fIBSD-style\fP mail utility
.SH SYNOPSIS
.B xmailtool [X-Toolkit Options...] [XMailTool Options...]
[options]
.SH DESCRIPTION
.IX xmailtool "" "\fLxmailtool\fR \(em X Window mail interface"
.IX tools xmailtool "" "\fLxmailtool\fR"
.LP
\fBXMailTool\fP manages your mail in much the same manner as \fImail\fP(1), 
but provides a more convenient and powerful user interface.
Scrollable windows allow easy access to 
your mailbox and mail folders. Software "buttons" make the most frequently 
used commands readily available. 
The full editing capabilities of \fIxedit\fP(1)
are available for modifying and composing mail.
In addition, the behavior of \fBXMailTool\fP may be customized 
by setting parameters with \fIxrdb\fP(1).
Users who are not familiar with the \fImail\fP(1)
program should read 
the manual for \fIMail\fP(1), \fImail\fP(1), or \fImailx\fP(1).
.SH OPTIONS
.LP
\fBXMailTool\fP accepts all of the standard X Toolkit command line options
along with the additional options listed below.    See \fIX\fP(1).
.TP 8
.B \+|\-autoHelp
This option turns off (on) the Auto-Help feature.  If \fBXMailTool\fP is being
run over a slow connection, the Auto-Help strings can slow down the overall
performance of the server.
.TP 8
.B \+|\-cmdBox
This option indicates that the button box in the middle of the tool should
be a box (form) widget.  Additional geometry control is provided for form
widgets.  However, some people have expressed a dislike for its appearance.
.TP 8
.B \-color
This option indicates that \fBXMailTool\fP should use the app-defaults file
that defines some really cool colors.  The default is that \fBXMailTool\fP
uses the default foreground and background colors.
.TP 8
.B \+|\-stateBox
This option indicates that the state toggle buttons shouldn't (should) be
created.
.TP 8
.B \-interval \fIseconds\fP
This option specifies the frequency in  seconds at which \fBXMailTool\fP
should check the system mailbox for a state change.  The default is 15 seconds.
.TP 8
.B \-file \fIfile_name\fP
This option specifies the file to be used as the system mailbox.  This 
can be used to force \fBXMailTool\fP to monitor a file other than the standard
system mailbox file.  In conjunction with a mail filter utility this can be a
very useful option.
.SH SUBWINDOWS
.LP
\fBXMailTool\fP consists of several subwindows.  They are:
.IP "state (state_cmd_box)" 12
a subwindow with software buttons used to change the action taken by selecting
a message header from the header subwindow.  This window also holds the XFace
image if supported.
.IP "folder name (folder_name)" 12
a label indicating the name of the current mailbox file. 
.IP "help message (help_msg)" 12
a label that changes to give information about the window the pointer is in.
.IP "header (header_box)" 12
a text subwindow which lists the header information (\fIFrom:\fP
and \fISubject:\fP and so on) for mail messages in the current mailbox file
.IP "command (cmd_box)" 12
a subwindow with
software buttons corresponding to the most frequently used \fImail\fP commands.
.IP "file (file_name)" 12
a subwindow in which to enter the file name for the file and save
commands.
.IP "directory (directory_name)" 12
a subwindow in which to enter the directory to which to change.  After a cd command
has been given, this window contains the current directory name.
.IP "Mail Output (mail_output)"
responses from \fBMail\fP other than messages or header information will be
displayed in this window.  In addition, error messages from \fBXMailTool\fP
will be displayed in this window.
.IP "message (msg_box)"12
a text subwindow that allows reading of messages that you have received
.IP "Author information (about_box)" 12
a Pop-up that tell you about me.  Click once on it to dismiss it.  There is 
currently no way to view this window.
.IP "composition (outbound_msg)" 12
a Pop-up text subwindow in which to compose and reply to messages.  This subwindow
appears only when composing, replying, forwarding, or sending a gripe message.
This window may also be an xterm named \fBoutbound_msg\fP if the \fIEDITOR\fP
variable in your .mailrc file is set to use \fBvi\fP.
.IP "Folder List (Folder_List)" 12
a Pop-up window that displays a list of mailbox files found in the directory
pointed to by the \fIfolder\fP variable.
.SH "State Buttons"
.LP
These buttons are used to change the action taken when selecting a message
from the header window.  The specified action will be taken as long as the
corresponding toggle is set.  In addition, the state command box contains
the bitmap for X-Face: header line support, and toggles for controlling
the headers displayed and the message text.
.IP  "\fBShow Message\fP" 12
When this toggle is set and a message header is selected from the header
window, the message associated with that header is displayed in the message
window.
.IP "\fBDelete Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is deleted.  The message following the deleted message
becomes the current message and is displayed in the message window.
.IP "\fBSave Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is saved in the file or folder specified in the file
window.
.IP "\fBPreserve Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is marked to be preserved when the changes are committed
.IP "\fBShow Deleted\fP" 12
When this toggle is set messages that have been marked for deletion will
be displayed.  A message is marked for deletion if it is explicitly deleted
or saved to another file.  The initial value of this toggle is controlled by
the \fIshowdeleted\fP variable.  for more information on Variables, see the Variables
section bellow.  When this toggle is off, messages marked for deletion will be
removed from the header window.
.IP "\fBBody Only\fP" 12
When this toggle is set, only the body of the message will be displayed in the
message text window.  This is particularly useful when a message has a
significantly long header section.
.IP "\fBSave Current\fP" 12
When this toggle is set, \fBXMailTol\fP writes an extra header line to the
mailbox file for the currently viewed message.  This extra header line helps
\fBXMailTol\fP remember which message was being viewed last.  Since this header
line is written to the mailbox file, the current message will be remembered even
after the current session of \fBXMailTol\fP has terminated.  If this toggle is
clear, \fBXMailTol\fP will not write the extra header line.  Unfortunately,
\fBXMailTol\fP must write the whole mailbox file in order to write this one header
line.  If you really don't care to remember the last message you read, you
would be advised to save the disk access, and cpu time by having this toggle off.
.SH "COMMAND BUTTONS"
.LP
All buttons except \fBnext\fP operate on the 
currently selected message.  
To select a message, make a selection anywhere 
on the line in the header subwindow corresponding to the desired message.
This is accomplished by positioning the cursor anywhere on the line,
and clicking the select mouse button (the leftmost one).  The selected message
will automatically be displayed in the message subwindow.
.LP
The  set of command buttons in the \fIcommand subwindow\fP 
is as follows.
.LP
.IP "\fBnext/prev\fP" 12
advance to the next message if there is one.  Move to the previous message if
there isn't a message following the current message.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBprev\fP.  By pressing on this
button while it is \fBprev\fP causes \fBXMailtool\fP to display the
previous message if there is one.  If this is the first message in the
current mailbox, \fBXMailTool\fP will display the next message instead.
.IP \fBdelete\fP 12
delete the selected message 
.IP \fBundelete\fP 12
undelete the current message.  This button is only useful if the deleted
message header is viewable (the Show Deleted toggle is set).
.IP "\fBsave/Save/copy/Copy\fP" 12
save the selected message in the file or folder specified in the \fBFile\fP 
subwindow.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBSave\fP.  By pressing
on this button while it is \fBSave\fP, causes \fBXMailTool\fP to save
the current message to a file based on the senders user name.  If you
press a Control key while in this button, it becomes \fBcopy\fP.  By pressing
this button while it is \fBcopy\fP, causes \fBXMailTool\fP to copy the
current message to the file specified in the \fBFile\fP subwindow.  The
current message isn't marked for deletion.  If you press both a Shift and
Control keys while in this button, it becomes \fBCopy\fP.  By pressing
this button while it is \fBCopy\fP, causes \fBXMAilTool\fP to copy the
current message to a file based on the senders user name.  The current
message isn't marked for deletion.
.IP \fBpreserve\fP 12
mark a previously saved message to be kept in the mailbox file.  Normally
a saved message will be removed from the mailbox when the changes have been
committed.  This button is identical to the \fBundelete\fP button, and is
also only useful if the deleted message header is viewable (the Show Deleted
toggle is set).
.IP \fBprint/enscript/Queue/print-Q\fP 12
print the selected message on a hardcopy printer.  This causes a copy of the
current message to be piped to the command in the \fIprint_cmd\fP variable. 
The user specifies this variable in the .mailrc file.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBenscript\fP.  By pressing
on this button while it is \fBenscript\fP causes \fBXMailTool\fP to use enscript
to print this message instead of the value in the \fIprint_cmd\fP variable.
If you press a Control key while in this button, it becomes \fBQueue\fP.  By
pressing this button while it is \fBQueue\fP causes \fBXMailTool\fP to append
the contents of this message to a temporary file (the Queue).  If you press both
Shift and Control keys while in this button, it becomes \fBprint-Q\fP.  By 
pressing this button while it is \fBprint-Q\fP causes \fBXMailTool\fP to print
the Queue file from above.  After the Queue file is printed, \fBXMailTool\fP
removes the Queue file.
.IP "\fBnew mail/Update\fP" 12
commit changes and load the messages from the system mailbox file.
.IP "" 12
The key bindings for this button have been changes so that if you press
a Shift key while in this button, it becomes \fBUpdate\fP.  By pressing on this
button while it is \fBUpdate\fP causes \fBXMailTool\fP to load the messages
that have been added to your mailbox file since the last time messages were
loaded.  No changes are committed when \fBUpdate\fP is pressed.  \fBUpdate\fP
can be useful if loading your mailbox file takes a considerable amount of
time.
.IP "\fBdone\fP" 12
commit changes and attempt to iconify the tool window.  If a window manager isn't
running, it will simply commit the changes.  
.IP \fBreply/reply-all/reply-inc/reply-all-inc\fP 12
open a composition subwindow to reply to the selected message.  If the
\fIinclude_msg\fP variable has been set, the current message will be copied
to the reply buffer optionally with a string prepended to every line.  The
user specifies this string with the \fImprefix\fP variable in the .mailrc file.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBreply-all\fP.  If you press
a Control key while in this button, it becomes \fBreply-inc\fP.  If you
press both Shift and Control keys while in this button, it becomes
\fBreply-all-inc\fP.
.IP \fBcompose/forward\fP 12
Pop-up the composition subwindow to compose a new message.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBforward\fP.  By pressing on this
button while it is \fBforward\fP causes \fBXMailTool\fP to Pop-up a
composition subwindow.  The current message is copied to the composition
buffer optionally with a string prepended to every line.  The user specifies
this string with the \fImprefix\fP variable in the .mailrc file.
.IP \fBgripe\fP 12
open a composition subwindow.  My address, a subject, and the beginning of
a message will be copied to the reply buffer.  The information in a gripe
window tells me what kind of machine you are using, what the \fIEDITOR\fP variable
is set to and what version of \fBXMailTool\fP you are running.
.IP \fBmailrc\fP 12
source your ~/.mailrc file and thereby acquire the current option/variable settings
.IP \fBFolder\fP 12
Pop-up a window asking the user to select a file in the folder directory.  The
folder directory is specified with the \fIfolder\fP variable in the .mailrc file.
.IP \fBfile/cd\fP 12
commit changes and switch to the file or folder specified in the \fBFile\fP 
window.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBcd\fP.  By pressing on this
button while it is \fBcd\fP causes \fBXMailtool\fP  to change to the directory specified in the \fBdirectory\fP subwindow.
.IP "mime" 12
If the currently selected message contains something other than plain text,
this button becomes sensitive (clickable).  By pressing on this button causes
\fBXMailTool\fP to spawn an \fImetamail\fP(1) with this message as input.
\fImetamail\fP(1) will then attempt to interpret the MIME portions of this
message.
.IP "\fBquit/abort\fP" 12
This causes \fBXMailTool\fP to terminate without saving the changes made
to the current mailbox file.
.IP "" 12
the key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBabort\fP.  By pressing on this
button while it is \fBabort\fP causes \fBXMailTool\fP to terminate
immediately.  The changes made to the system mailbox are not saved.
This is equivalent to the abort \fBMail(1)\fP command.
.IP \fBload\fP 12
Save changes made to current message.  Currently this isn't supported.
.IP \fBhelp\fP 12
Pop-up a window containing a list of the accelerators.
.IP \fBFile Name:/File Menu\fP 12
circulate through the list of saved file names.
.IP "" 12
the key bindings for this button have been changed so that if you press a 
Shift key while in this button, it becomes \fBFile Menu\fP.  By pressing on
this button while it is \fBFile Menu\fP causes \fBXMailTool\fP to pop up the
\fIFile List\fP menu.  See the \fBSAVED FILE NAMES\fP section below.
.IP \fBcancel\fP 12
abort the operation being performed.  This button appears in each of the
Pop-up subwindows and allows you to abort certain activities.  If your
\fIEDITOR\fP variable is set to something like \fBvi\fP, there won't be
a cancel button on the outbound message window.
.IP \fBsend\fP 12
send the message being composed in the composition subwindow.  This button
appears in the composition subwindow.  Pressing it causes the subwindow to
Pop-down and the message is transferred to \fBMail\fP.  If your
\fIEDITOR\fP variable is set to something like \fBvi\fP, there won't be
a send or cancel button on the outbound message window.
.SH XMT-NOTIFY
.LP
\fBXMailTool\fP allows the user to pass strings to a number of buttons.  These
strings affect the action taken by \fBXMailTool\fP when that button is pressed.
Buttons affected by such strings and key bindings are marked with a small X logo
bitmap to the left of the button name string.  A list of the buttons and their
use of the strings is as follows:
.IP \fBnext\fP 12
The string is used to determine if the next message or the previous message
is to be displayed.  The two valid values are "next" and "prev".  Any other
value will cause an error message.
.IP \fBsave\fP 12
\fBXMailTool\fP interprets this string to be the command to use.  Valid values
are "save", "Save", "copy", and "Copy".
.IP \fBprint\fP 12
The string is executed by \fBsh\fP.  The stdin of the command will be
a file containing the message.
.IP "\fBnew mail\fP" 12
Valid values are "new mail" and "Update".
.IP \fBcompose\fP 12
The string is used to determine how \fBXMailTool\fP is to create an outbound
message.  The string can be a space, comma, or dash (-) separated list of any
of the following strings:  "include" -- include the current message,
"noinclude" -- don't include the current message, "notinclude" -- do the
opposite of the include_msg flag set in the .mailrc file, "sign" -- append the
~/.signature file, "nosign" -- don't append the ~/.signature file, "notsign" --
do the opposite of the do_signature flag in the .mailrc file.  Any other
value will cause an error message.
.IP \fBreply\fP 12
The string is used to determine how \fBXMailTool\fP is to create a reply
message.  The string can be a space, comma, or dash (-) separated list of any
of the strings used by the compose button and the string "all" -- reply to
the originator and all recipients of the original message.
.IP "\fBfile\fP 12
The string determines if the cd or file action should be taken.  Valid values
are "file" and "cd".
.IP \fBquit\fP 12
The string is used to determine how \fBXMailTool\fP should terminate
\fBMail(1)\fP.  The two valid values are "quit" and "abort".  Any other
value will cause an error message.
.SH FOLDER SELECTION
.LP
\fBXMailTool\fP allows the user to traverse through the directory structure
that begins at the directory specified by the \fIfolder\fP variable.  When the
Folder button is pressed, a pop-up window appears containing a list of files
in the folder directory.  Subdirectories are marked with a "/" (slash) after
their name.  If the user selects a subdirectory from the list, the current list
is destroyed and the list of files from the subdirectory are displayed.  Other
files are treated as mailbox files.  As \fBXMailTool\fP builds the folder
list, it checks the access time and modification time to determine if the
file contains new mail.
.LP
When a mailbox file is selected, there are three possible actions that 
\fBXMailTool\fP will take.  These actions may be specified in any combination
and are passed to XMT-Notify as strings.  They are as follows:
.IP \fBSAVE\fP 12
The currently selected message is saved in the file specified by this name.
The default is that this action is taken when ever a Shift key is depressed
while selecting a mailbox file.
.IP \fBCHANGE\fP 12
The text that appears in the "File Name:" string will be changed to this
value.  The default is that this action is taken when ever a Control key is
depressed while selecting a mailbox file.
.IP \fBLOAD\fP 12
Changes to the current mailbox file are committed and messages from this
mailbox file are read and displayed.  The default is that this action is taken
when ever a Mod1 key (usually the Meta or Alt keys) are depressed or no 
modifier keys are depressed while selecting a mailbox file.
.LP
From the description above, it can be concluded that if a mailbox file is
selected while the Shift and Control keys are depressed, the current message
will be saved to that file and the "File Name:" string will be changed.
.SH SAVED FILE NAMES
.LP
\fBXMailTool\fP will save the names of the mailbox files that have most
recently been saved to or viewed.  The number of file names \fBXMailTool\fP
will remember is configured by the user by setting the \fInum_saved_fnames\fP
variable.  The primary difference between a folder and a saved file is that
a folder must be a child of the directory specified by the \fIfolder\fP variable while a saved file can be located anywhere.  The saved file name list is added to in a FIFO style -- file names added to the list can force file names off the bottom of the list.  \fBXMailTool\fP doesn't attempt to remember how frequently, or how recently a file has been accessed.  The \fIsaved_fnames\fP variable holds the initial value for saved file name list.
Each time the .mailrc file is read, the saved file name list is reinitialized
to this value.  The value of the "File Name:" text can be circulated through the values of the saved file name list by clicking on the "File Name:" label as described above.  The "File List" window has the same key bindings as the "Folder List" window above.
.SH HEADER SEARCHING
.LP
\fBXMailTool\fP allows the user to search for message header information.  This
is done by pressing \fICtrl-s\fP in the header_box window.  The search dialog
for this window acts slightly different than the normal Xaw Text Widget search
dialog in that if you press the "search" button, any matches will cause those
messages to be displayed.
.SH VISUAL EDITOR
.LP
\fBXMailTool\fP allows the user to specify the visual editor to use when
composing an outbound message.  This is done by setting the EDITOR variable
in the .mailrc file.  See the VARIABLES section below.  \fBXMailTool\fP
supports three sets of editors.
.IP Internal 12
An Athena Widgets Text editor is used when the EDITOR variable is set to
"none" in the .mailrc file.  This editor gives the user the most control
and a more intuitive user interface.  The key bindings are almost identical
to the Xaw Text Widget with the exception to special tilde bindings.  See
the TILDE COMMANDS section below.  For more information about the key bindings
for the Xaw Text Widget, see the \fIAthena Widget Set - C Language
Interface\fP manual from M.I.T.  This editor is essentially \fBemacs\fP based.
.IP "Terminal Based" 12
\fBXMailTool\fP allows the user to specify a terminal based editor such as
\fBvi\fP.  This is done by setting the EDITOR variable to the desired editor
and setting the edit_needs_xterm variable.  An \fBxterm\fP is forked specifying
the -e option as follows:  "xterm -e $EDITOR message_file", where message_file
is the temporary file containing the outbound message.  In order to indicate
that the message is to be sent, the user must update the file so that it's
modification time is after it's creation time.  To indicate that the
message is not to be sent, the user must either remove the file, or not
update the file.  The modification time is checked when \fBxmailtool\fP
receives the death of child signal from \fBxterm\fP.
.IP "Independent" 12
\fBXMailTool\fP allows the user to specify an editor which doesn't require
an \fBxterm\fP.  This is done by setting the EDITOR variable to the desired
editor and setting the edit_needs_xterm to zero.  NOTE:  by default the
edit_needs_xterm variable is assumed to be 1.  A shell is forked specifying
the -c option as follows:  "$SHELL -c $EDITOR message_file", where message_file
is the temporary file containing the outbound message.  As above, if the file's
modification time is after it's creation time, \fBxmailtool\fP assumes the
message is to be sent.
.SH TILDE COMMANDS
.LP
\fBXMailTool\fP supports a number of tilde (~) commands in the composition
window if the user has set the EDITOR variable to "none."  These commands may
be slightly different than your implementation of \fBMail\fP.  Each tilde
command must start at the beginning of a line.  If a tilde (~) is typed at
the beginning of the line followed by a character that isn't a recognized
command, both the tilde (~) and the second character are printed.  The
recognized commands are as follows:
.IP "~r" 12
read a file into the current outbound message beginning at the current line.
This command is almost synonymous to the Meta-i command except that it
must begin the line -- Meta-i can be used in the middle of a line.
.IP "~a" 12
insert the contents of the sign variable into the current outbound message
beginning at the current line.  The sign variable is scanned for escaped
characters prior to insertion.  Currently only n,r, and t are supported
escaped characters.
.IP "~A" 12
insert the contents of the Sign variable into the current outbound message
beginning at the current line.  As above the Sign variable is scanned for
escaped characters.
.IP "~d" 12
inserts the contents of the file named in the DEAD variable.  This is normally
the dead.letter file.
.IP "~f" 12
inserts the currently viewed message into the current outbound message.  The
current viewed message is the one being viewed in the \fBxmailtool\fP window.
.IP "~m" 12
inserts the currently viewed message into the current outbound message
prepending the contents of the mprefix variable to each line.  The current
message is the one being viewed in the \fBxmailtool\fP window.
.IP "~v" 12
Switch to the editor specified by the VISUAL variable.  This has got to be
one of the coolest features I've done.  It pops down the Xaw editor window
and forks a process as described above in the VISUAL EDITOR section.  When
you are done editing the file, it switches you back to the Xaw editor.
.IP "~~" 12
insert the tilde character at the first position of the line.
.IP "~y" 12
Insert the currently selected text into the current outbound message
prepending the contents of the mprefix variable to each line.
.SH ALIASES
.LP
\fBXMailTool\fP supports recursive aliases.  That is to say that if you
have defined aliases in your .mailrc file, \fBXMailTool\fP will expand an
address in an outbound message that matches your aliases.  Most versions of
\fBMail\fP don't support recursive aliases -- aliases that reference other
aliases.  I'm not sure why that is, but I choose to support them.
.LP
If an alias contains the name of the alias as one of its entries,
\fBXMailTool\fP will not expand that entry.  That is, if the alias "man"
expands to "foo, man, choo," \fBXMailTool\fP will attempt to expand only
"foo" and "choo."  It is important that the user be careful not to specify
aliases in such a way as to create a loop.  An example of this would be if
the user defined an alias "foo" that expands to "bar," and an alias "bar"
that expands to "foo."  Because of the scope of such loops, \fBXMailTool\fP
does not make an attempt to detect such loops.
.LP
Aliasing can be turned off by setting the do_xmtaliases to 0. See the
VARIABLES section for more details.
.SH HEADER SORTING
.LP
By setting the \fIsortFields\fP variable the user can control the order in which
\fBXMailTool\fP displays header lines.  Message headers can be sorted on
more than one header line value, message size, and mailbox order.  
The internal order remains in mailbox order.  That is, when they are written
to the mailbox file, they will be in the same order they originally were, not
the order in which they appeared in the header window.
.SH VARIABLES
.LP
Not every version of mail supports each of the variables that \fBXMailTool\fP
supports.  Special \fBXMailTool\fP variables are as follows -- these are
specified in the .mailrc file:
.LP
.IP sortFields
This is a space separated list of header fields that indicate how you want the
message headers to be sorted.  If a header field name is preceded by a minus sign
(-) the headers will be sorted in reverse order.  Field priority goes from left
to right.  An empty header field is considered to have a value of 0 when comparing
header fields of two messages.  The valid header field strings include:
.RS
.IP From 12
The ascii address of the person who sent this message.  All message have
this field.
.IP Cc 12
The ascii list of people who got copies of this message.
.IP Subject 12
The ascii subject string.
.IP ReturnPath 12
The ascii address found in the Return-Path header line.
.IP ReplyTo 12
The ascii address found in the Reply-To header line.
.IP References 12
the ascii string found in the References header line.
.IP Keywords 12
the ascii string found in the Keywords header line.
.IP Date 12
the ascii string found in the Date header line.  Note that this
is an ascii comparison, not an actual time/date comparison.
.IP MessageId 12
the ascii string found in the Message-Id header line.
.IP Sender 12
the ascii address of the person who sent this message.
.IP Position 12
the byte offset from the beginning of the mailbox file to
the first character of the header of this message.  Note
that no two messages can have the same Position value and
therefore any field string that appears to the right of
Position in the \fIsortFields\fP variable has no meaning.
Also, the Position value is determined by when the message
was written to the mailbox file and may not actually reflect
any chronological order of messages.  This value however is more
useful than Date when trying to sort messages chronologicaly.
.IP Size 12
the number of bytes of disk space this message (including header and
body) takes up.
.IP Status 12
If a message is new and unread, this value will be 0.  If a message is
old and unread, this value will be 1.  If a message is old and read,
this value will be 2.
.IP Face 12
the ascii encoded string found in the X-Face header line.
.RE
.IP do_signature 12
if the file $HOME/.signature exists and this variable is set to 1, the contents
of the $HOME/.signature file will be appended to the outbound message
buffer when a compose, reply, forward, or gripe button is pressed.  The
default is 1.
.IP do_xmtaliases 12
if this variable is set to 1, \fBXMailTool\fP will attempt to perform
it's own alias expansion.  If this variable is set to 0, the contents of
the outbound message buffer will be passed to the mail sender as is.  The
default is 1.
.IP do_xmtrecord 12
if this variable is set to 1 and the record variable is set, then
\fBXMailTool\fP will append the contents of the outbound message buffer to
the contents of the file specified by the record variable.  The default is 1
if \fBXMailTool\fP has been compiled to use sendmail, and 0 otherwise.
.IP fromAddress 12
if this variable is set to 1, \fBXMailTool\fP will attempt to determine the 
"Real Name" of the sender from the From: line of the message.  It will use 
this string in the header window.  If this variable is set to 0, 
\fBXMailTool\fP will use the email address instead.  The default is 0.
.IP showlast 12
the last message in the mailbox should be displayed first after deiconifying
\fBXMailTool\fP, pressing the newmail button, or selecting a new mailbox file.
The default is 0 (show first new or unread message).
.IP showold 12
the oldest unread message in the mailbox should be displayed first after
deiconifying \fBXMailTool\fP, pressing the new mail button, or selecting a new
mailbox file.  The default is 1.
.IP  shownew 12
the newest unread message in the mailbox should be displayed first after
deiconifying \fBXMailTool\fP, pressing the new mail button, or selecting a new
mailbox file.  The default is 0.
.IP saveCurrent 12
the last message being viewed in an \fBXMailTool\fP session with this mailbox file
should be displayed first after deiconifying \fBXMailTool\fP, pressing the new
mail button, or selecting a new mailbox file.  This also specifies the starting
value of the Save Current toggle.  The default is 0 (ignore X-Current header lines
and don't write X-Current header lines to the mailbox file). 
.IP "" 12
Note:  the above four variables control which message should be viewed first
when deiconifying \fBXMailTool\fP, pressing the new mail button, or selecting a new
mailbox file.  The priority of these variables is \fIsaveCurrent\fP, \fIshownew\fP,
\fIshowold\fP, then \fIshowlast\fP.  That is to say that if \fIsaveCurrent\fP is
set to 1 (true, on, yes, etc.) the values of the other three variables is
meaningless.  The showlast variable is considered only if one of the other three
variables isn't set or if there aren't any messages that meat their required
conditions.
.IP bodyOnly 12
specifies the starting value of the Body Only toggle and indicates if the header
of a displayed message should be printed as well as the body of that message.  The
default is 0 (show both body and header).
.IP showeleted 12
specifies the starting value of the Show Deleted toggle and indicates if header
lines for messages that have been marked for deletion should be displayed in
the message header window.  The default is 0 (don't show deleted messages).
.IP skipDeleted 12
if \fIshowdeleted\fP is set \fBXMailTool\fP will not move the current message
pointer when a message is deleted or saved unless this is set to 1.  The
default is 1.
.IP saved_fnames 12
the list of file names the saved file name list will be set to when \fBXMailTool\fP first starts and every time the mailrc button is pressed. Note that if there are more file names specified by this variable than as specified by the \fInum_saved_fnames\fP variable the list will be truncated to hold
only \fInum_saved_fnames\fP names.
.IP num_saved_fnames 12
the number of strings that should be allocated for saving file names that are
referenced.  The default is 5.
.IP include_msg 12
insert the original message body within the reply buffer just after the message
header information and just before the signature information when the reply
button is pressed.  The default is 0 (don't include the message).
.IP interval 12
the frequency in seconds that \fBXMailTool\fP should check the system mailbox
for a state change.  The default is 15 seconds.
.IP mprefix 12
.IP indentprefix 12
when including the original message body as in a reply or forward, prepend each
line with this string.  Both mprefix and indentprefix are stored internally in
the same place.  If both variables are used, the last one set will override the
first.
.IP asksub 12
always ask the user to specify a subject in a compose message.
.IP askcc 12
always ask the user to specify a carbon copy list.
.IP askbcc 12
always ask the user to specify a blind carbon copy list.
.IP bell 12
ring the bell this number of times.  The default is 1.
.IP print_cmd 12
use this command for the print command.  The stdin of this command will be
the message.
.IP edit_needs_xterm 12
indicates that the command in the EDITOR variable needs to be wrapped with
an \fBxterm\fP.  The default is 1.
.IP cmd_box 12
indicates whether the command box is to be a box widget or a form widget.
In a box widget, button placement is very loose.  In a form widget a great
deal of control is enforced on the buttons.  By setting this variable, the
user indicates that they want a box widget.  The default is 0 (use a form).
.IP confirm_EDITOR 12
indicates that when the \fIEDITOR\fP variable is set to use an external editor,
\fBXMailTool\fP should ask the user whether to send the message when the
editor process terminates.  The default is 1 (confirm outbound messages).
.IP outbound_suffix 12
some editors are able to identify a file type by it's suffix or extension.
The value of this variable is added to the end of temporary files used
for sending messages.  The default value is ".mai".
.IP state_box 12
indicates whether the state command box is to be created.  If you find the
toggles at the top of the \fBXMailTool\fP window to be annoying, set this
variable to zero (0).  The default is 1 (show state box).
.SH FILES
.br
/usr/spool/mail/*       post office
.br
~/\fB.\fPmailrc		file giving initial mail commands
.br
~/\fB.\fPsignature	file to be appended to each outbound message
.br
~/\fB.\fPenvelope	file containing mail headers to include in
			outbound messages
.SH SEE ALSO
.br
.IR binmail (1), 
.IR xrdb (1),
.IR mail (1), 
.IR xedit (1)
.br 
.IR aliases (5),  
.IR mailaddr (7),
.IR newaliases( 8), 
.IR sendmail (8)
.SH BUGS
.LP
New mail status is only approximate, therefore the presence of new mail
is not always accurately reflected in the icon image.
.LP
Some versions of \fBMail\fP don't handle multiple definitions of an alias.
If you have two lines that define the same alias, the second may augment
the first line.  In addition, if you source your .mailrc file, your aliases
will be doubled on themselves.
.SH ACKNOWLEGEMENTS
.LP
Thanks go to the following people for their contribution in the
shaping and creation of \fBXMailTool\fP.
.IP "\fBSharon and Ward Kierski\fP (my Mom and Dad)" 12
.IP "\fBKeith A. Fredericks\fP" 12
.IP "\fBSam Moore (and his daughter C.E.M.)" 12
.IP "\fBSteve Crooks, Intergraph\fP" 12
.IP "\fBGordon Lack\fP" 12
.IP "\fBRichard K. Lloyd, Computer Science Dept., Liverpool University\fP" 12
.IP "\fBHarald* Vogt, Department of Computer Science, Utrecht University\fP" 12
.IP "\fBJose Manuel Menendez, Universidad Politecnica de Madrid, Spain\fP" 12
.IP "\fBPhill Everson, Sequent\fP" 12
.IP "\fBFrederick R. Phelan Jr.\fP" 12
.IP "\fBGrant Totten, Trent University, Peterborough Ontario\fP" 12
.IP "\fBPaul A. Weber, Loral Command & Control Systems\fP" 12
.IP "\fBZdenek Sekera\fP" 12
.IP "\fBJohn Gillono\fP" 12
.IP "\fBJohn Freeman\fP" 12
.IP "\fBNeil Williams\fP" 12
.IP "\fBChris Butler\fP" 12
.IP "\fBJohn Carlson\fP (He signs my check)" 12



