;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  basicio.asm
;* Purpose: Basic I/O functions for DOS simulator
;* Entries: dos01, dos02, dos03, dos04, dos05, dos06, dos07, dos08, dos09,
;*          dos0A, dos0B, dos0C
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Include assembler macros:
;
include ..\..\headers\asm\macros.inc
include ..\..\headers\asm\layout.inc
include ..\..\headers\asm\memory.inc
include .\dospriv.inc


;
;**************************************************************************
;
; Miscalleneous equates
;
AUX_INIT	equ	10100011b	; AUX port initialization value:
					;  2400 Baud, no parity, 1 stop bit,
					;  8 data bits


;
;**************************************************************************
;
; BSS segment
;
bss_start

	extrn	dos1_regs:byte
	extrn	dos2_regs:byte

ifdef NEEDEXTIO
; BSS gets initialized to zero automatically, so no need to specify a
; data value here.
auxflag		db	?		; flag if serial port initialized
prnflag		db	?		; flag if printer port initialized
endif

bss_end


;
;**************************************************************************
;
; Start code segment.
;
text_start

ifdef NEEDLINEIO
ifdef NEEDFILEIO
	extrn	dos3F:near
endif
endif

	public	dos01, dos02, dos03	; define entry points
	public	dos04, dos05, dos06
	public	dos07, dos08, dos09
	public	dos0A, dos0B, dos0C


;
;**************************************************************************
;
; Read character from keyboard and then send it to the screen
; Input:  none
; Output: AL  -  character
; Registers changed: AL
;
dos08		label	near
dos07		label	near
dos01		proc	near

	push	bx
	mov	bh,ah			; save AH
	call	keywait			; wait for character from keyboard
	mov	bl,al
	cmp	bh,1			; only print character with fn 01h
	jne	short dos011
	int	29h			; print character
dos011:	mov	ax,bx			; restore AH
	pop	bx
	ret

dos01		endp


;
;**************************************************************************
;
; Print character onto screen
; Input:  DL  -  character
; Output: none
; Registers changed: none
;
dos02		proc	near

	push	ax
	mov	al,dl
	int	29h			; print character
	pop	ax
	ret

dos02		endp


;
;**************************************************************************
;
; Receive character on serial port COM1
; Input:  none
; Output: AL  -  character
; Registers changed: AL
;
dos03		proc	near

ifdef NEEDEXTIO
	push	bx
	mov	bh,ah
	mov	al,DEV_AUX
	call	devinit			; initialize serial device
	mov	ah,02h
	int	14h			; receive character
	mov	ah,bh			; restore AH
	pop	bx
endif

	ret

dos03		endp


;
;**************************************************************************
;
; Send character to serial port COM1
; Input:  DL  -  character
; Output: none
; Registers changed: none
;
dos04		proc	near

ifdef NEEDEXTIO
	push	ax
	push	dx
	mov	al,DEV_AUX
	call	devinit			; initialize serial device
	pop	ax
	push	ax			; restore character
	mov	ah,01h
	int	14h			; send character
	pop	dx
	pop	ax
endif

	ret

dos04		endp


;
;**************************************************************************
;
; Send character to printer port
; Input:  DL  -  character
; Output: none
; Registers changed: none
;
dos05		proc	near

ifdef NEEDEXTIO
	push	ax
	push	dx
	mov	al,DEV_PRN
	call	devinit			; initialize parallel port
	pop	ax
	push	ax			; restore character
	xor	ah,ah
	int	17h			; send character
	pop	dx
	pop	ax
endif

	ret

dos05		endp


;
;**************************************************************************
;
; Direct console I/O
; Input:  DL  -  character for console output, or 0FFh for console input
; Output: AL  -  character from console input, or 0 for console output
; Changed registers: AL
;
dos06		proc	near

	xor	al,al
	cmp	dl,0FFh			; check for function
	jne	short dos02		; print character

	call	keycheck		; get character from keyboard
	jz	short dos068		; got no character
	xor	ah,ah
	int	16h			; get character from buffer
	or	dl,dl			; reset zero flag
	jmp	short dos069
dos068:	xor	al,al			; set return value 0
dos069:	mov	ah,06h			; restore AH
	ret

dos06		endp


;
;**************************************************************************
;
; Print character string onto screen. String is terminated by '$' character.
; Input:  DS:DX  -  pointer to string
; Output: none
; Registers changed: none
;
dos09		proc	near

	cld
	push	ax
	push	si
	push	es
	mov	es,old_ds[bp]		; get caller's DS
	mov	si,dx
dos091:	lods	byte ptr es:[si]	; get next character
	cmp	al,'$'			; end of string?
	je	short dos092
	int	29h			; print character
	jmp	short dos091		; proceed with next character

dos092:	pop	es
	pop	si
	pop	ax
	ret

dos09		endp


;
;**************************************************************************
;
; Read string from keyboard. The first character of the buffer contains
; the buffer size, the next character will receive the actual number
; of characters read.
; Input:  DS:DX  -  pointer to buffer
; Output: none
; Registers changed: none
;
dos0A		proc	near

ifndef NEEDLINEIO

	push	es
	push	bx
	mov	es,old_ds[bp]
	mov	bx,dx			; simply mark the buffer as
	mov	byte ptr es:[bx+1],0	; empty
	pop	bx
	pop	es
	ret

else					;; NEEDLINEIO

	push	ax
	push	bx
	push	di
	push	es
	mov	es,old_ds[bp]
	mov	di,dx
	xor	bx,bx			; BX - offset into buffer

dos0A1:	cmp	bl,es:[di]		; end of buffer reached?
	jae	short dos0A4
	call	keywait			; get next character

	cmp	al,CHR_BS		; backspace?
	jne	short dos0A2
	or	bx,bx			; don't delete past beginning of
	jz	short dos0A1		; buffer
	dec	bx			; kill character in the buffer and
	jmp	short dos0A5		; on the screen

dos0A2:	cmp	al,CHR_RET		; carriage return?
	je	short dos0A3
	mov	es:[di+bx+2],al		; save character
	inc	bx
dos0A5:	int	29h			; and print it
	jmp	short dos0A1

dos0A3:	int	29h
	mov	al,CHR_LF		; print CR/LF
	int	29h
dos0A4:	mov	es:[di+1],bl		; save length in the buffer
	pop	es
	pop	di
	pop	bx
	pop	ax
	ret

endif					;; NEEDLINEIO

dos0A		endp


;
;**************************************************************************
;
; Get keyboard status
; Input:  none
; Output: AL  -  0FFh -> key pressed, 000h -> no key pressed
; Changed registers: AL
;
dos0B		proc	near

	call	keycheck		; check BIOS keyboard buffer
	jz	short dos0B9		; no character in buffer
	mov	al,0FFh			; yes, we have a character available
dos0B9:	mov	ah,0Bh			; restore AH
	ret

dos0B		endp


;
;**************************************************************************
;
; Clear input buffer and then call input routine.
; Input:  AL  -  input function number
; Output: AL  -  input character
; Registers changed: depending on input function
;
dos0C		proc	near

	push	ax
dos0C1:	mov	ah,01h			; get keyboard status (don't use
	int	16h			; keycheck here - not necessary)
	jz	short dos0C2		; no more characters in buffer
	xor	ah,ah
	int	16h			; get character from input buffer
	jmp	short dos0C1		; repeat until buffer empty
dos0C2:	pop	ax

dos0C4:	cmp	al,06h
ifdef IS386
	je	dos06			; call DOS function 06
else
	jne	short dos0C5
	jmp	dos06			; call DOS function 06
endif

dos0C5:	cmp	al,0Ah
ifdef IS386
	je	dos0A			; call DOS function 0A
else
	jne	short dos0C6
	jmp	dos0A			; call DOS function 0A
endif

dos0C6:	mov	ah,al
	jmp	dos01			; call DOS function 01

dos0C		endp


;
;**************************************************************************
;
; Check BIOS for a key press
; Input:  none
; Output: AL  -  character
;         Zero flag reset if character found in buffer
; Registers changed: AX
;
keycheck	proc	near

	cmp	bp,offset dgroup:dos1_regs
	jne	short keych1
	push	es
	push	ds
	pushall
	int	28h			; care for "multitasking" interrupt
	popall				; only if the correct stack is active
	pop	ds
	pop	es
keych1:	mov	ah,01h
	int	16h			; check BIOS keyboard buffer
	jnz	short keych9		; found character in buffer
	xor	al,al			; no character found in buffer
keych9:	ret

keycheck	endp


;
;**************************************************************************
;
; Wait for a key press
; Input:  none
; Output: AL  -  character
; Registers changed: AX
;
keywait		proc	near

keyw1:	call	keycheck		; wait for key to be pressed
	jz	short keyw1
	xor	ah,ah
	int	16h			; get character from keyboard
	ret

keywait		endp


ifdef NEEDEXTIO
;
;**************************************************************************
;
; Initialize a device.
; Input:  AL  -  device type (CON, AUX, PRN)
; Output: none
; Registers changed: AX
;
devinit		proc	near

	push	dx
	mov	ah,1			; default device flag
	xor	dx,dx			; default device number

; Initialize serial port

	cmp	al,DEV_AUX
	jne	short devin2
	xchg	ah,auxflag		; already initialized?
	or	ah,ah
	jnz	short devin9
	mov	ax,AUX_INIT
	int	14h			; initialize serial port
	jmp	short devin9

; Initialize parallel port

devin2:	cmp	al,DEV_PRN
	jne	short devin9
	xchg	ah,prnflag		; already initialized?
	or	ah,ah
	jnz	short devin9
	mov	ah,01h
	int	17h			; initialize printer port

devin9:	pop	dx
	ret

devinit		endp
endif					;; NEEDEXTIO


;
;**************************************************************************
;
text_end

	end

