;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  time.asm
;* Purpose: Various time related functions
;* Entries: _set_timeout, _chk_timeout, _get_ticks
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Include assembler macros:
;
include ..\..\headers\asm\macros.inc
include ..\..\headers\asm\layout.inc
include ..\..\headers\asm\memory.inc
include .\libpriv.inc


;
;**************************************************************************
;
; BSS segment:
;
bss_start

endval		dd	?		; counter tick end value

bss_end


;
;**************************************************************************
;
; Start code segment.
;
text_start

	public	_set_timeout		; define entry points
	public	_chk_timeout
	public	_get_ticks

	extrn	_pktpoll:near


;
;**************************************************************************
;
; Get current number of timer ticks.
; Input:  none
; Output: DX:AX  -  number of timer ticks
;
_get_ticks	proc	near

	xor	ah,ah
	int	1Ah			; get current timer count from BIOS
	mov	ax,dx			; prepare return value
	mov	dx,cx
	ret

_get_ticks	endp



;
;**************************************************************************
;
; Set timer tick end value for timeout.
; Input:  1. arg  -  number of timer ticks until timeout
; Output: none
;
_set_timeout	proc	near

	penter
	getarg	bx,0			; get numer of ticks to sleep
	call	setend			; set end value
	pleave
	ret

_set_timeout	endp


;
;**************************************************************************
;
; Check if timer reached timeout value.
; Input:  none
; Output: non-zero, if timeout value reached
;
_chk_timeout	proc	near

	call	_pktpoll		; care for polling events
	xor	ah,ah
	int	1Ah			; get current time
	xor	ax,ax
	cmp	cx,word ptr [endval+2]	; compare current tick count with
	jb	short chkt2		; end count
	ja	short chkt1
	cmp	dx,word ptr [endval+0]
	jb	short chkt2
chkt1:	mov	ax,1
chkt2:	ret

_chk_timeout	endp


;
;**************************************************************************
;
; Set timer tick end value for timeout.
; Input:  BX  -  timeout time in timer ticks
; Output: none
; Registers changed: AX, CX, DX
;
setend		proc	near

	xor	ah,ah
	int	1Ah			; get current timer count from BIOS
	add	dx,bx
	adc	cx,0			; compute end count
	mov	word ptr [endval+0],dx
	mov	word ptr [endval+2],cx
	ret

setend		endp


;
;**************************************************************************
;
text_end

	end

