/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgInfo.c                                                     */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:45 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Info"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  char *type_name;
  int width,height;
  double min_value,max_value;
  
  IFHELP
    {
      fprintf(stderr,"img%s - Show information about the current image\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: None\n");
      exit(0);
    }

  imgStart(PRGNAME);
  
  do {
    image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(image==NULL)
      ERROR("can't import image file");
    width=image->width;
    height=image->height;
    min_value=image->min_value;
    max_value=image->max_value;
    switch(image->type)
      {
      case IT_BIT:
	type_name="Bit image (pbm)";
	min_value=0.0;
	max_value=1.0;
	break;
      case IT_BYTE:
	type_name="Byte image (pgm)";
	min_value=0.0;
	max_value=255.0;
	break;
      case IT_RGB:
	type_name="RGB image (ppm)";
	min_value=0.0;
	max_value=255.0;
	break;
      case IT_FLOAT:
	type_name="Float image";
	break;
      case IT_DOUBLE:
	type_name="Double image";
	break;
      case IT_COMPLEX:
	type_name="Complex image";
	break;
      case IT_POLAR:
	type_name="Polar image";
	break;
      case IT_LONG:
	type_name="Long image";
	break;
      default:
	type_name="unrecognised image";
	break;
      }
    fprintf(stderr,"%s: type       %s.\n",PRGNAME,type_name);
    fprintf(stderr,"%s: size       (%dx%d)\n",PRGNAME,width,height);
    fprintf(stderr,"%s: valid area (%d,%d)(%dx%d)\n",PRGNAME,image->valid_x,
	    image->valid_y,image->valid_width,image->valid_height);
    fprintf(stderr,"%s: min/max    (%g,%g)\n",PRGNAME,min_value,max_value);

    i_destroy_image(image);
  } while(!feof(stdin));
  
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
