/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgInverseFFT.c                                               */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:46 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "InverseFFT"
#define ERROR(e) imgError(e,PRGNAME)

void test_size(int);

int main(int argc,char **argv)
{
  it_image *image,*cpx_image;
  int width,height;
  it_float *flt_ptr;
  it_complex *cpx_ptr;
  long size,count;
  double min,max,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate the inverse Fourier transform\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    cpx_image=i_read_image_file(stdin,IT_COMPLEX,IM_CONTIG);
    if(cpx_image==NULL)
      ERROR("can't import image file");
    width=cpx_image->width;
    height=cpx_image->height;
    test_size(width);
    test_size(height);

    /* Carry out inverse FFT of cpx_image */
    i_fourier_transform_2d(cpx_image,IFFT);

    image=i_create_image(width,height,IT_FLOAT,IM_CONTIG);
    if(image==NULL)
      ERROR("out of memory");

    /* Copy real part of complex image to output float image */
    flt_ptr=im_float_row(image,0);
    cpx_ptr=im_complex_row(cpx_image,0);
    size=(long) width *(long) height;
    imgInitMinMax(min,max);
    for(count=size;count--;)
      {
	val=(cpx_ptr++)->Re;
	*flt_ptr++=val;
	if(val>max) max=val;
	if(val<min) min=val;
      }
    image->max_value=max;
    image->min_value=min;
    image->valid_x=cpx_image->valid_x;
    image->valid_y=cpx_image->valid_y;
    image->valid_width=cpx_image->valid_width;
    image->valid_height=cpx_image->valid_height;

    i_destroy_image(cpx_image);
    i_write_image_file(stdout,image,IF_BINARY);
    i_destroy_image(image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}

void test_size(int size)
{    
  int temp=size;
  
  while(size>>=1)
    if(size&temp)
      ERROR("image dimensions must be a power of two");
}

/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
