/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgPnmToFlt.c                                                 */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:51 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "PnmToFlt"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *pnm_image,*flt_image;
  long length;
  it_byte *byte_ptr;
  it_float *flt_ptr;
  it_rgb *rgb_ptr;
  int x,y,width,height;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert pbm, pgm or ppm images to Float format\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: pbm, pgm, ppm\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);
  
  /* Loop through images */
  do {
    pnm_image=i_read_image_file(stdin,IT_BIT | IT_BYTE | IT_RGB,IM_CONTIG);
    if(pnm_image==NULL)
      ERROR("can't import image file");
    width=pnm_image->width;
    height=pnm_image->height;
    
    flt_image=i_create_image(width,height,IT_FLOAT,IM_CONTIG);
    if(flt_image==NULL)
      ERROR("out of memory");
    
    flt_image->min_value=0.0;
    length=(long) width*(long) height;
    flt_ptr=im_float_row(flt_image,0);
    switch(pnm_image->type)
      {
      case IT_BYTE:
	flt_image->max_value=255.0;
	byte_ptr=im_byte_row(pnm_image,0);
	while(length--)
	  *flt_ptr++ =(it_float) *byte_ptr++;
	break;
	
      case IT_BIT:
	flt_image->max_value=1.0;
	for(y=0;y<height;y++)
	  for(x=0;x<width;x++)
	    *flt_ptr++ =(it_float) (1-im_get_bit_value(pnm_image,x,y));
	break;
	
      default:
	flt_image->max_value=255.0;
	rgb_ptr=im_rgb_row(pnm_image,0);
	while(length--)
	  {
	    *flt_ptr++ =(it_float) im_luminance(rgb_ptr);
	    rgb_ptr++;
	  }
	break;
      }
    i_write_image_file(stdout,flt_image,IF_BINARY);
    i_destroy_image(pnm_image);
    i_destroy_image(flt_image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
