/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgThresh.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:46:01 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Thresh"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2;
  int width,height,x,y;
  double val,low_thresh,high_thresh;
  it_float *flt_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Threshold image\n",PRGNAME);
      fprintf(stderr,"img%s [low_thresh [high_thresh]]\n",PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: pbm\n");
      exit(0);
    }

  imgStart(PRGNAME);

  low_thresh=high_thresh=0.0;
  if(argc>3)
    ERROR("invalid arguments");
  if(argc>1)
    low_thresh=atof(argv[1]);
  if(argc>2)
    high_thresh=atof(argv[2]);

  do {
    i1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_BIT,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    for(y=0;y<height;y++)
      {
	flt_ptr=im_float_row(i1,y);
	for(x=0;x<width;x++)
	  {
	    val=1;
	    if(*flt_ptr>=low_thresh)
	      {
		val=0;
		if(argc==3 && *flt_ptr>high_thresh)
		  val=1;
	      }
	    im_put_bit_value(i2,x,y,val);
	    flt_ptr++;
	  }
      }

    i_destroy_image(i1);
    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
