/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** sRefSetStack.h
*/

# ifndef sRefSetStack_H
# define sRefSetStack_H

typedef struct _sRefSetStack *sRefSetStack ;

typedef struct _sRefSetStack
{
  sRefSet elements;
  sRefSet allElements;
  sRefSetStack thisbranch;
  sRefSetStack lastbranch;
  sRefSetStack parent;
  int lexlevel;
} _sRefSetStack ;

extern sRefSetStack sRefSetStack_new(void);

extern void sRefSetStack_push (sRefSetStack s, sRef el) ;
extern sRefSetStack sRefSetStack_pop (sRefSetStack s) ;
extern sRefSet sRefSetStack_top (sRefSetStack s) ;

extern cstring sRefSetStack_unparse (sRefSetStack s) ;
extern void sRefSetStack_free (/*@only@*/ sRefSetStack s) ;
extern sRefSetStack sRefSetStack_init (void);

extern sRefSetStack sRefSetStack_branch (sRefSetStack s);
extern sRefSetStack sRefSetStack_trueBranch (sRefSetStack s);
extern sRefSetStack sRefSetStack_altBranch (sRefSetStack s);
extern sRefSetStack sRefSetStack_popBranches (sRefSetStack alt);
extern sRefSetStack sRefSetStack_popTrueBranch (sRefSetStack s);

# define sRefSetStackBASESIZE    MIDBASESIZE
# define sRefSetStackNULL        ((sRefSetStack)0)
# define sRefSetStack_undefined  (sRefSetStackNULL)

# else
# error "Multiple include"
# endif




